################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################


# Store files in an array and always print them after the dirs.
# We cannot rely on ls --group-directories-first because it is too new.
BEGIN {
   nfiles = 0;
}
END {
    for (i = 0; i < nfiles; i++) {
        print files[i];
    }
}

/^-/ {
    if (target == "file" || target == "both") {
        files[nfiles] = "<fm:item type=\"file\" modified=\"" getTimestamp() "\" size=\"" $5 "\" name=\"" escapeXmlAttribute(getName()) "\"/>";
        nfiles++;
    }
    next
}

/^d/ {
    print "<fm:item type=\"folder\" modified=\"" getTimestamp() "\" name=\"" escapeXmlAttribute(getName()) "\"/>";
    next
}


function getName() {
    # Remove the first 8 fields and keep the filename. Note that we can't
    # use $9 etc since awk would not handle multiple spaces in the file name
    m = match($0, "^([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ +)([^ ]+ )");
    if (m > 0)
        return substr($0, 1 + RLENGTH);
    else
        # This should never happen
        return "Could not obtain file name";
}


# Format the date according to 'YYYY-MM-DDTHH:mm:ss+HH:mm' pattern
# The format is RFC 3339 a profile of ISO 8601
# As an example, 2009-09-28T12:17:00+0200
function getTimestamp() {

    # Translate months to numbers
    # copy $6 to a string before using sub, otherwise for some reason the leading spaces of a filename get lost
    s = $6;
    sub("Jan", "01", s);
    sub("Feb", "02", s);
    sub("Mar", "03", s);
    sub("Apr", "04", s);
    sub("May", "05", s);
    sub("Jun", "06", s);
    sub("Jul", "07", s);
    sub("Aug", "08", s);
    sub("Sep", "09", s);
    sub("Oct", "10", s);
    sub("Nov", "11", s);
    sub("Dec", "12", s);

    if (split($8, a, ":" ) > 1) {
      # Compare file month+day with current month+day, since ls may not indicate
      # the year from up to six months ago
      FILE_MONTHDAY=sprintf("%.2d%.2d", s, $7);
      if ( FILE_MONTHDAY > CURRENT_MONTHDAY )
        iso_timestamp=sprintf("%d-%.2d-%.2dT%s:00%s", CURRENT_YEAR - 1 , s, $7, $8, MYTIMEZONE);
      else
        iso_timestamp=sprintf("%d-%.2d-%.2dT%s:00%s", CURRENT_YEAR, s, $7, $8, MYTIMEZONE);
    }
    else {
      iso_timestamp=sprintf("%d-%.2d-%.2dT00:00:00%s", $8, s, $7, MYTIMEZONE);
    }

    return iso_timestamp;
}
