################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################

BEGIN {
    FS="/"
    RS="\n"
    paths = "";
}

{
    stack[t = 0] = "";
    for (i = 1; i<= NF; i++) {
        if ($i == ".." || $i == "..\n") {
#            printf("pop %d: %s\n", i, $i);
            pop()
        }
        else if ($i != "." && $i != "") {
#            printf("push %d: %s\n", i, $i);
            push($i)
        }
        else {
#            printf("skip %d: %s\n", i, $i);
        }
    }

    if (t == 0) {
        printf ("/");
    }
    else {
        path = "";
        for (i = 0; i < t; i++) {
            #  printf("/%s", stack[i])
            path = sprintf("%s/%s", path, stack[i])
        }
    }

    # printf ("\n");
    paths = sprintf("%s%s\n", paths, path);
}

END {
    # At the ends emits either the resolved paths or the path with errors.
    printf("%s", paths);
}

function push(x) {
    stack[t++] = x
}

function pop() {
    if (t > 0) {
        return stack[--t]
    }
    else {
        # In case of error returns the input pattern that breaks.
        paths = sprintf("%s\n", $0);
        exit 1
    }
}

