<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:func="http://exslt.org/functions"
  xmlns:date="http://exslt.org/dates-and-times"
  xmlns:java="http://xml.apache.org/xalan/java"
  exclude-result-prefixes="grid func date java"
>

<!-- ====================================================================== -->
<!-- This file contains some useful xsl functions used to transform GridML  -->
<!-- ====================================================================== -->


  <!-- Get timezone -->
  <xsl:variable name="_timezone" select="substring(date:date-time(),20)" />
  <xsl:variable name="timezone">
    <xsl:choose>
      <xsl:when test="$_timezone = 'Z'">+00:00</xsl:when>
      <xsl:otherwise><xsl:value-of select="$_timezone"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- check timezone for Xalan bug https://issues.apache.org/jira/browse/XALANJ-2536 -->
  <xsl:variable name="timezone-offset">
    <xsl:value-of select="substring-after($timezone,':')" />
  </xsl:variable>

  <xsl:variable name="timezone-offset-checked">
    <xsl:choose>
      <xsl:when test="$timezone-offset > 0">:<xsl:value-of select="round($timezone-offset div 60000)" /></xsl:when>
      <xsl:otherwise>:<xsl:value-of select="$timezone-offset" /></xsl:otherwise>
     </xsl:choose>
  </xsl:variable>


  <!-- main functions -->

  <!-- convert number with unit of measurement -->
  <func:function name="grid:convert-unit">
    <xsl:param name="input" />
    <func:result select="java:com.enginframe.xslt.GridFilterLibrary.convertUnitToBytes(string($input))"/>
  </func:function>

  <!-- convert gridml date-time attributes to standard format -->
  <func:function name="grid:date-time">
    <xsl:param name="input" />

    <xsl:choose>
      <!-- if there's a text node, assume the it is already in iso 8601 combined format -->
      <xsl:when test="$input/text()"/>
      <xsl:otherwise>
        <!-- build iso 8601 combined format -->
        <xsl:variable name="seconds">
          <xsl:choose>
            <xsl:when test="$input/@second"><xsl:value-of select="$input/@second" /></xsl:when>
            <xsl:otherwise>00</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <func:result select="concat(
            $input/@year,
            '-',grid:_get-month($input/@month),
            '-',grid:_get-day($input/@day),
            'T',
            $input/@hour,':',$input/@minute,':',$seconds, substring-before($timezone,':'), $timezone-offset-checked
          )" />
      </xsl:otherwise>
    </xsl:choose>
  </func:function>


  <!-- utilities used internally -->

  <!-- convert unit name to unit value -->
  <func:function name="grid:_get-unit">
    <xsl:param name="unit" />
    <func:result select="java:com.enginframe.xslt.GridFilterLibrary.unitAsNumber(string($unit))"/>
  </func:function>

  <!-- convert month name to month number -->
  <func:function name="grid:_get-month">
    <xsl:param name="month" />
    <func:result select="java:com.enginframe.xslt.GridFilterLibrary.monthAsNumber(string($month))"/>
  </func:function>

  <!-- format day with two digits -->
  <func:function name="grid:_get-day">
    <xsl:param name="day" />
    <xsl:variable name="result">
      <xsl:if test="string-length($day) = 1">0</xsl:if>
      <xsl:value-of select="$day" />
    </xsl:variable>
    <func:result select="$result" />
  </func:function>

</xsl:stylesheet>
