<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
>

  <!-- import filter library -->
  <xsl:import href="$(EF_ROOT)/lib/xsl/com.enginframe.filter.xsl" />

  <!-- import library with useful functions to handle GridML -->
  <xsl:import href="$(EF_ROOT)/plugins/grid/lib/xsl/grid.filter.library.xsl" />

  <!-- mapper file - the path in @select must be absolute or relative to $EF_ROOT/lib/xsl -->
  <xsl:variable name="conf" select="'../../plugins/grid/conf/mappers/grid.list.hosts.xconf'" />

  <!-- special template to handle memory specified with unit of measure -->
  <xsl:template match="grid:resource[@name='mem' or @name='swp']" mode="filter">
    <!-- copy text node with no unit -->
    <xsl:variable name="value">
        <xsl:value-of select="grid:convert-unit(text())" />
    </xsl:variable>
    <xsl:variable name="maxvalue">
        <xsl:value-of select="grid:convert-unit(@max)" />
    </xsl:variable>
    <xsl:copy>
      <!-- copy all attributes but @max -->
      <xsl:apply-templates select="@*[not(@name='max')]" mode="filter"/>
      <!-- re-define @max with no unit -->
      <xsl:attribute name="max">
        <xsl:choose>
          <xsl:when test="$maxvalue > $value">
            <xsl:value-of select="$maxvalue" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$value" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$value" />
    </xsl:copy>
  </xsl:template>

  <!-- special template to handle tmp specified with unit of measure -->
  <xsl:template match="grid:resource[@name='tmp']" mode="filter">
    <!-- copy this tag -->
    <xsl:copy>
      <!-- copy all attributes -->
      <xsl:apply-templates select="@*" mode="filter"/>
      <!-- re-define text node with no unit -->
      <xsl:value-of select="grid:convert-unit(text())" />
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
