<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:encode="org.owasp.encoder.Encode"
>

  <!-- import filter library -->
  <xsl:import href="$(EF_ROOT)/lib/xsl/com.enginframe.filter.xsl" />

  <!-- import library with useful functions to handle GridML -->
  <xsl:import href="$(EF_ROOT)/plugins/grid/lib/xsl/grid.filter.library.xsl" />

  <!-- encode grid:name -->
  <xsl:template match="grid:name" mode="filter">
    <!-- Use the encode:forUriComponent function to encode the content of grid:name -->
    <xsl:variable name="encodedName" select="encode:forUriComponent(.)"/>
    <!-- Recreate the grid:name element with the encoded content -->
    <grid:name>
      <xsl:value-of select="$encodedName"/>
    </grid:name>
<!--  <xsl:message>
    <xsl:text>Encoded value of 'encodedGridName': </xsl:text>
    <xsl:value-of select="$encodedName" />
  </xsl:message>
-->
  </xsl:template>
  
  <!-- mapper file - the path in @select must be absolute or relative to $EF_ROOT/lib/xsl -->
  <xsl:variable name="conf" select="'../../plugins/grid/conf/mappers/grid.list.jobs.xconf'" />

  <!-- special template to handle the old format of timestamp of GridML -->
  <xsl:template match="grid:submission-time | grid:execution-time | grid:termination-time" mode="filter">
    <!-- copy this tag -->
    <xsl:copy>
      <!-- copy all attributes and child nodes -->
      <xsl:apply-templates select="node()|@*" mode="filter"/>
      <!-- define a text node -->
      <xsl:value-of select="grid:date-time(.)" />
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
