/*global jQuery, window */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */
/* Dynacloud wrapper to associate with a hydrogen table. 
 * This must be istantiated in the tableName.init function. 
 * The conf parameter must be in the format:
    {
        tableVar: 'tableName',
        widgetId: tableId,
        toolbar: hyToolbar,
        table: hyTable,
        filters: hyFilters,
        searchCols: [ 'columns', 'used' , 'inSearch' ],
        filterKey: 'filterName',
        refreshFunc: function () { ..function to call at refresh action.. });
    }
*/
var wordcloud = {

    init: function (conf) {
        var groupCloud;

        wordcloud._id = '#' + conf.widgetId + '-wordcloud';
        wordcloud._filterKey = conf.filterKey;
        wordcloud._refreshFunc = conf.refreshFunc;
        groupCloud = jQuery(wordcloud._id).addClass('hy-box hy-group-cloud ui-widget ui-helper-hidden');

        // header
        groupCloud.headerDiv = jQuery('<div class="dynacloud-header hy-box-header ui-widget-header" />').appendTo(groupCloud).text(conf.title);
        jQuery('<div id="groupdata" style="display: none"><pre></pre></div>').appendTo(groupCloud);
        jQuery('<div class="wordcloud-delete-item-box ui-icon ui-icon-trash"/>').appendTo(groupCloud.headerDiv).hide().click(function () {
            wordcloud._reset();
        });
        // content
        groupCloud.contentDiv = jQuery('<div class="dynacloud hy-box-content ui-widget-content" />').appendTo(groupCloud);
        jQuery('<ul class="ui-helper-_reset" />').appendTo(groupCloud.contentDiv);
        jQuery('<img />').hide().appendTo(groupCloud.contentDiv);

        // redefine table actions
        wordcloud._bindTable(conf.tableVar, conf.widgetId, conf.toolbar, conf.table, conf.filters, conf.searchCols);
        // populate cloud
        wordcloud._refresh();
    },

    setData: function (data) {
        if (data !== '') {
            jQuery(wordcloud._id).show();
            jQuery(wordcloud._id + ' #groupdata > pre').text(data);
            jQuery(wordcloud._id + ' #groupdata').dynaCloud('.dynacloud');

            var itemFound = false;
            jQuery(wordcloud._id + ' > .dynacloud > a > span').each(function () {
                if (jQuery(this).text() === wordcloud._currentFilter) {
                    wordcloud._selectItem(this);
                    itemFound = true;
                }
            });
            if (!itemFound) {
                wordcloud._reset();
            }

            jQuery(wordcloud._id + ' > .dynacloud > a > span').click(function () {
                if (jQuery(this).hasClass('ui-state-highlight')) {
                    wordcloud._reset(this);
                }
                else {
                    wordcloud._selectItem(this);
                }
            });
        }
        else {
            jQuery(wordcloud._id).hide();
            wordcloud._reset();
        }
    },

    _refresh: function () {
        wordcloud._refreshFunc();
    },

    _bindTable: function (tableVar, widgetId, toolbar, table, filters, searchCols) {
        // redefine refresh
        window[tableVar].refresh = function () {
            wordcloud._refresh();
        },

        // redefine table filters
        wordcloud._tableFilters = filters;
        filters.unbind('hyfiltersselect');
        filters.bind('hyfiltersselect', function (e, filter) {
            toolbar.hytoolbar('search', '');
            if (!filter) {
                filter = '';
            }

            if (filter.formula === 'all') {
                filter.formula = '';
            }
            var currentView = filter.formula? filter.formula : '';
            wordcloud._currentTableFilter = filter;

            if (wordcloud._currentFilter) {
                var filters = wordcloud._currentFilter.split(";");
                var addFilter = currentView? true : false;
                currentView += addFilter? ' and (' : '';
                jQuery.each(filters, function(index, element) {
                    currentView += wordcloud._filterKey + " ~= \'(.*,)?" + element + "(:.*)?(,.*)?\'";
                        if (index !== filters.length - 1) {
                            currentView += ' or ';
                        }
                });
                currentView += addFilter? ')' : '';
            }
            table.hytable('filter', currentView);
            table.data('filter', currentView);
        });

        // redefine table search
        toolbar.unbind('hytoolbarsearch');
        toolbar.bind('hytoolbarsearch', function (e, s) {

            var formula = wordcloud._currentTableFilter.formula? wordcloud._currentTableFilter.formula : '';
            if (wordcloud._currentFilter) {
                formula += formula? ' and ' : '';
                formula += wordcloud._filterKey + " ?:= \'" + wordcloud._currentFilter + "\'";
            }
            if (formula) {
                if (s.search !== '') {
                    formula += " and (";
                    jQuery.each(searchCols, function (index, value) {
                        if (index) {
                            formula += " or ";
                        }
                        formula += value + " ?:= '" + s.search + "'";
                    });
                    formula += ")";
                }
            } else {
                if (s.search !== '') {
                    jQuery.each(searchCols, function (index, value) {
                        if (index) {
                            formula += " or ";
                        }
                        formula += value + " ?:= '" + s.search + "'";
                    });
                } else {
                    formula = "";
                }
            }
            table.hytable('filter', formula);
        });

        // redefine refresh actions
        var msg = jQuery('#' + widgetId + '-message').hymessage();
        table.unbind('hytableaction');
        table.bind('hytableaction', function (e, data) {
            jQuery.hydrogen.executeAction(data.action,
                {'%CURRENT_ID%': data.currentId},
                function () {
                    window[tableVar].refresh();
                },
                msg);
        });
        toolbar.unbind('hytoolbaraction');
        toolbar.bind('hytoolbaraction', function (e, action) {
            jQuery.hydrogen.executeAction(action,
                {'%SELECTED_IDS%': function () {
                    return table.hytable('selected').join('\n');
                }
                    },
                function () {
                    window[tableVar].refresh();
                },
                msg);
        });
    },

    _selectItem: function (item) {
        if (wordcloud._currentFilter) {
            wordcloud._currentFilter += ";" + jQuery(item).text();
        }
        else {
            wordcloud._currentFilter = jQuery(item).text();
        }
        jQuery(item).addClass('ui-state-highlight dynacloud');
        jQuery(wordcloud._id + ' .wordcloud-delete-item-box').css({
            'display' : 'inline',
            'float' : 'right',
            'cursor' : 'pointer',
            'margin-top' : '-5px'
         });
        jQuery(wordcloud._tableFilters).trigger('hyfiltersselect', [ wordcloud._currentTableFilter ]);
    },

    _reset: function (item) {
        if (item && wordcloud._currentFilter) {
            var filters = wordcloud._currentFilter.split(";");
            filters.splice( jQuery.inArray(jQuery(item).text(), filters), 1);
            wordcloud._currentFilter = filters.join(";");
        }
        if (item) {
            jQuery(item).removeClass('ui-state-highlight');
        }
        else {
            wordcloud._currentFilter = '';
            jQuery(wordcloud._id + ' > .dynacloud > a > span').removeClass('ui-state-highlight');
        }
        if (!wordcloud._currentFilter) {
            jQuery(wordcloud._id + ' .wordcloud-delete-item-box').hide();
        }
        jQuery(wordcloud._tableFilters).trigger('hyfiltersselect', [ wordcloud._currentTableFilter ]);
    }
};
