/*global jQuery, confirm */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

Date.prototype.getWeek = function () {
    var onejan = new Date(this.getFullYear(), 0, 1);
    return Math.ceil((((this - onejan) / 86400000) + onejan.getDay() + 1) / 7);
};

String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1).toLowerCase()
}

String.prototype.efEncodeHtml = function() {
    return efEncodeHtml(this)
}

(function ($) {

    var aMonths, aDays, mimeTypes;

    aMonths = [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
            "Sep", "Oct", "Nov", "Dec" ];

    aDays = [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ];


    function parseISO8601(iso8601) {
        var s;

        // s = jQuery.trim(iso8601);
	s = String.prototype.trim.call(iso8601);
	
        s = s.replace(/-/, "/").replace(/-/, "/");
        s = s.replace(/T/, " ").replace(/Z/, " UTC");
        s = s.replace(/([\+\-]\d\d)\:?(\d\d)/, " $1$2"); // -04:00 -> -0400

        return new Date(s);
    }

    // Pads numbers with a preceding 0 if the number is less than 10.
    function padWithZero(val) {
        if (parseInt(val, 10) < 10) {
            return "0" + val;
        }

        return val;
    }

    /*
     * Accepts the client's time zone offset from GMT in minutes as a parameter.
     * returns the timezone offset in the format [+|-}DDDD
     */
    function getTZOString(timezoneOffset) {
        var hours, modMin, absHours, s;

        hours = Math.floor(timezoneOffset / 60);
        modMin = Math.abs(timezoneOffset % 60);
        s = (hours > 0) ? "-" : "+";
        absHours = Math.abs(hours);
        s += (absHours < 10) ? "0" + absHours : absHours;
        s += ((modMin === 0) ? "00" : modMin);

        return s;
    }

    /*
     * Accepts a Javascript Date object as the parameter; outputs an
     * RFC822-formatted datetime string.
     */
    function formatAsRFC822(oDate) {
        var dtm;

        dtm = aDays[oDate.getDay()] + ", ";
        dtm += padWithZero(oDate.getDate()) + " ";
        dtm += aMonths[oDate.getMonth()] + " ";
        dtm += oDate.getFullYear() + " ";
        dtm += padWithZero(oDate.getHours()) + ":";
        dtm += padWithZero(oDate.getMinutes()) + ":";
        dtm += padWithZero(oDate.getSeconds()) + " ";
        dtm += getTZOString(oDate.getTimezoneOffset());

        return dtm;
    }

    /* FIXME: improve it to better manage the case in which you
     * are in different Years
     * but in near dates (e.g. today is Dec 31 and the spooler expires on
     * Jan 3) and test the sameWeek case
     */
    function prettyDateFormatterReal(value, options) {
        var date, dtm, today, sameYear, sameWeek, dayDistance, op;

        if (!value || value.length === 0 || value.startsWith("--T")) {
            return "-";
        }

        op = {showTime: true, showSeconds: true, useRelativeDate: true, inSentence: false};

        if (options !== undefined) {
            op = $.extend(op, options);
        }

        today = new Date();
        date = parseISO8601(value);

        sameYear = (today.getFullYear() ===  date.getFullYear());
        sameWeek = sameYear && (today.getWeek() ===  date.getWeek());

        dtm = "";
        if (sameYear && op.useRelativeDate) {
            if (sameWeek) {
                dayDistance = date.getDate() - today.getDate();
                switch (dayDistance) {
                case 0:
                    dtm += op.inSentence ? "<b>today</b>" : "Today ";
                    break;
                case -1:
                    dtm += op.inSentence ? "<b>yesterday</b>" : "Yesterday ";
                    break;
                case 1:
                    dtm += op.inSentence ? "<b>tomorrow</b>" : "Tomorrow ";
                    break;
                default:
                    dtm += op.inSentence ? "on <b>" : "";
                    if (dayDistance > 1) {
                        dtm += aMonths[date.getMonth()] + " ";
                        dtm += padWithZero(date.getDate()) + " ";
                    } else {
                        dtm += aDays[date.getDay()] + " ";
                    }
                    dtm += op.inSentence ? "</b>" : "";
                }
            } else {
                dtm += op.inSentence ? "on <b>" : "";
                dtm += aMonths[date.getMonth()] + " ";
                dtm += padWithZero(date.getDate()) + " ";
                dtm += op.inSentence ? "</b>" : "";
            }

        } else {
            dtm += op.inSentence ? "on <b>" : "";
            dtm += aMonths[date.getMonth()] + " ";
            dtm += padWithZero(date.getDate()) + ", ";
            dtm += date.getFullYear();
            dtm += op.inSentence ? "</b>" : "";
        }

        if (op.showTime && (!op.useRelativeDate || sameYear)) {
            dtm +=  op.inSentence ? " at <b>" : " ";
            dtm += padWithZero(date.getHours()) + ":";
            dtm += padWithZero(date.getMinutes());
            if (op.showSeconds) {
                dtm += ":" + padWithZero(date.getSeconds());
            }
            dtm += op.inSentence ? "</b>" : "";
        }

        return "<abbr class=\"timeago\" title=\"" + formatAsRFC822(date) +
               "\">" + dtm + "</abbr>";
    }

    function nameFormatterReal(cellvalue, op, rowObject, rowId) {
        var href, id, sdf, idName, realParams;

        sdf = op.sdf || document.location.pathname;
        idName = op.idName || "id";

        if (op.id) {
            id = op.id;
        } else if (op.idRef) {
            if (op.idRef.charAt(0) === '@') {
                id = $(rowObject).attr(op.idRef.substring(1));
            } else {
                id = $(rowObject).children(op.idRef).text();
            }
        } else {
            id = rowId;
        }

        // Job-specific operations
        if (op.idName === "jobid" && id.lastIndexOf("app://", 0) === 0) {
            return "-"
        }

        // Define anchor
        href = sdf + "?" + "_uri=" + op.serviceURI + "&" +
               op.idName + "=" + encodeURIComponent(id);

        // Cluster-specific operations
        if (op.idName === "cluster") {
            href += "&" + $.param({ "grid": $(rowObject).children("type").text() });
        }

        // Needed for backward compatibility in case some old code uses addParam as string
        if (typeof op.addParam === 'object') {
            realParams = {};
            $.each(op.addParam, function (k, v) {
                var newValue;
                if (v) {
                    newValue = v.replace(/(^@\{col:)(.+)(\}$)/, function (match, p1, p2, p3, offset, string) {
                        return $(rowObject).children(p2).text();
                    });
                    newValue = newValue.replace(/(^@\{attr:)(.+)(\}$)/, function (match, p1, p2, p3, offset, string) {
                        return $(rowObject).attr(p2);
                    });
                    realParams[k] = newValue.replace(/^@\{rowId\}$/, function () {
                        return rowId;
                    });
                } else {
                    realParams[k] = "";
                }
            });
            href += "&" + $.param(realParams);
        } else if (op.addParam !== undefined && op.addParam !== '') {
            // Backward compatibility mode (in case some old code uses addParam as string)
            href += "&" + op.addParam;
        }

        if (cellvalue === undefined || cellvalue.length === 0) {
            // otherwise IE does not show borders
            cellvalue = '&nbsp;';
        } else if (!!op.idName && op.idName.toLowerCase().includes("host")) {
            hostnameSeparator = "_";
            cellvalue = cellvalue.split(hostnameSeparator)[0]; // if we have a <hostname>_<server id> composite, we get only the host name
            cellvalue = efEncodeHtml(cellvalue);
        }

        return "<a href='" + href + "'>" + cellvalue + "</a>";
    }

    function formatNumber(value, unit) {
        var v;

        function formatNumberReal(number, decimals, dec_point, thousands_sep) {
            // http://kevin.vanzonneveld.net
            // + original by: Jonas Raoni Soares Silva
            // (http://www.jsfromhell.com)
            // + improved by: Kevin van Zonneveld
            // (http://kevin.vanzonneveld.net)
            // + bugfix by: Michael White (http://crestidg.com)
            // + bugfix by: Benjamin Lupton
            // + bugfix by: Allan Jensen (http://www.winternet.no)
            // + revised by: Jonas Raoni Soares Silva
            // + improved by: Paolo Maggi
            // (http://www.jsfromhell.com)
            // * example 1: number_format(1234.5678, 2, '.', '');
            // * returns 1: 1234.57
            var n, c, d, t, i, x, s, j;

            n = number;
            c = isNaN(decimals = Math.abs(decimals)) ? 2 : decimals;
            d = dec_point === undefined ? ',' : dec_point;
            t = thousands_sep === undefined ? '.' : thousands_sep;
            s = n < 0 ? '-' : '';
            i = String(parseInt(n = Math.abs(+n || 0).toFixed(c), 10));
            j = (j = i.length) > 3 ? j % 3 : 0;
            x = Math.abs(n - i);

            return s + (j ? i.substr(0, j) + t : "") +
                       i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) +
                       ((c && x !== 0) ? d + x.toFixed(c).slice(2) : "");
        }

        if (typeof value === 'number') {
            // special case bytes units
            if (unit === 'B') {
                if (value >= 1099511627776) {
                    v = formatNumberReal(value / 1099511627776, 2, '.', '') + ' TB';
                } else if (value >= 1073741824) {
                    v = formatNumberReal(value / 1073741824, 2, '.', '') + ' GB';
                } else if (value >= 1048576) {
                    v = formatNumberReal(value / 1048576, 2, '.', '') + ' MB';
                } else if (value >= 1024) {
                    v = formatNumberReal(value / 1024, 0) + ' KB';
                } else {
                    v = formatNumberReal(value, 0) + ' bytes';
                }
            } else {
                if (value >= 1000000000000) {
                    v = formatNumberReal(value / 1000000000000, 2, '.', '') + ' T';
                } else if (value >= 1000000000) {
                    v = formatNumberReal(value / 1000000000, 2, '.', '') + ' G';
                } else if (value >= 1000000) {
                    v = formatNumberReal(value / 1000000, 2, '.', '') + ' M';
                } else if (value >= 1000) {
                    v = formatNumberReal(value / 1000, 0) + ' K';
                } else {
                    v = formatNumberReal(value, 0);
                }
            }
        } else {
            v = value;
        }

        return v;
    }

    $.hydrogen = $.hydrogen || {};

    $.extend($.hydrogen, {

        SDF: "/" + $.enginframe.rootContext + "/hydrogen/ui.hydrogen.xml",

        fileManagerSDF: "/" + $.enginframe.rootContext + "/fm/lib/xml/com.enginframe.fm.xml",

        openPopupWindow : function (instanceSettings, onclose) {
            var settings, windowFeatures, windowName, winx, winy, w;

            $.hydrogen.openPopupWindow.defaultSettings = {
                centerBrowser: 1, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left
                centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left
                height: 500, // sets the height in pixels of the window.
                left: 0, // left position when the window appears.
                location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.
                menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.
                resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}. Can also be overloaded using resizable.
                scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.
                status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.
                width: 500, // sets the width in pixels of the window.
                windowName: '', // name of window set from the name attribute of the element that invokes the click
                windowURL: '', // url used for the popup
                top: 0, // top position when the window appears.
                toolbar: 0, // determines whether a toolbar (includes the forward and back buttons) is displayed {1 (YES) or 0 (NO)}.
                titlebar: 0, // determines whether a titlebar is displayed {1 (YES) or 0 (NO)}.
                title: null
            };

            settings = $.extend({}, $.hydrogen.openPopupWindow.defaultSettings, instanceSettings || {});

            windowFeatures = 'height=' + settings.height +
                             ',width=' + settings.width +
                             ',toolbar=' + settings.toolbar +
                             ',titlebar=' + settings.titlebar +
                             ',scrollbars=' + settings.scrollbars +
                             ',status=' + settings.status +
                             ',resizable=' + settings.resizable +
                             ',location=' + settings.location +
                             ',menubar=' + settings.menubar +
                             ',directories=0' +
                             ',copyhistory=0';

            // MSIE complains about non-alphanumeric name of window
            windowName = settings.windowName.replace(/[^0-9a-zA-Z]/g, "_").replace(/-/g, "_");

            if (settings.centerBrowser) {
                if (false) { // $.browser.msie   hacked together for IE browsers    
                    winx = window.screenLeft + ((((document.body.offsetWidth + 20) / 2) - (settings.width / 2)));
                    winy = (window.screenTop - 120) + ((((document.documentElement.clientHeight + 120) / 2) - (settings.height / 2)));
                } else {
                    winx = window.screenX + (((window.outerWidth / 2) - (settings.width / 2)));
                    winy = window.screenY + (((window.outerHeight / 2) - (settings.height / 2)));
                }
            } else if (settings.centerScreen) {
                winx = (screen.width - settings.width) / 2;
                winy = (screen.height - settings.height) / 2;
            } else {
                winx = settings.left;
                winy = settings.top;
            }

            w = window.open(settings.windowURL, windowName, windowFeatures + ',left=' + winx + ',top=' + winy);
            w.trigger("focus");

            if (settings.title) {
                $(w.document).ready(function () {
                    w.document.title = settings.title;
                });
            }

            return w;
        },

        // normalize consecutive '/' and remove trailing '/' (unless it's the only char)
        normalizeFilepath: function (path) {
            var ret = path.replace(/\/+/g, '/');
            return ret === '/' ? ret : ret.replace(/\/$/, '');
        },

        escapeSelector: function (sel) {
            return sel.replace(/[!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~]/g, '\\$&');
        },

        starFormatter : function (cellvalue, options, rowObject) {
            var cl;

            cl = "hy-star-off";

            if (cellvalue === "true") {
                cl = "hy-star-on";
            }

            return "<div class='hy-star hy-table-active-element " + cl + "'></div>";
        },

        nameFormatter : function (cellvalue, options, rowObject) {
            return nameFormatterReal(cellvalue, options.colModel.formatoptions, rowObject, options.rowId);
        },
	jobNameFormatter: function(cellvalue, options, rowObject) {
            // console.log(cellvalue);
	    var cellvalueURI=decodeURI(cellvalue)
            return nameFormatterReal(cellvalueURI, options.colModel.formatoptions, rowObject, options.rowId)
        },
        defaultOrValueFormatter : function (value, options) {
            if (value == null || value === "") {
                const formatOptions = options.colModel.formatoptions || {};
                return formatOptions.defaultPlaceholder || "-";
            }
            return value;
        },
        sizeFormatter : function (cellvalue, options, rowObject) {
            if (cellvalue !== undefined && cellvalue.length > 0) {
                return formatNumber(parseInt(cellvalue, 10), 'B');
            }

            return "--";
        },

        ratioFormatter : function (cellvalue, options, rowObject) {
            var op, value, maxValue, str, w;

            op = {maxValue: 100, showChart: true, isPercentage: false, unit: '', used: false};

            if (options.colModel.formatoptions !== undefined) {
                op = $.extend(op, options.colModel.formatoptions);
            }

            if (typeof op.maxValue === 'number') {
                maxValue = op.maxValue;
            } else {
                if (op.maxValue.charAt(0) === '@') {
                    maxValue = $(rowObject).attr(op.maxValue.substring(1));
                } else {
                    maxValue = $(rowObject).children(op.maxValue).text();
                }
            }

            if (op.used) {
                value = parseInt(cellvalue, 10);
            } else {
                value = parseInt((maxValue - cellvalue), 10);
            }

            if (typeof maxValue !== 'number') {
                maxValue = parseInt(maxValue, 10);
            }

            if (op.isPercentage) {
                if (isNaN(value)) {
                    str = "--";
                    value = -1;
                } else {
                    value = 100 * value / maxValue;
                    str = value + "%";
                }
            } else {
                if (cellvalue !== '') {
                    if (maxValue > 0) {
                        str = formatNumber(value, op.unit) + " / " + formatNumber(maxValue, op.unit);
                    } else {
                        str = formatNumber(value, op.unit);
                    }
                } else {
                    value = -1;
                    str = '--';
                }
            }


            if (maxValue > 0) {
                if (op.showChart) {
                    if (value < 0) {
                        w = 'na';
                    } else {
                        w = Math.min(10, Math.floor(10 * (value / maxValue) + 0.5));
                    }
                    str = '<div class="hy-bar-icon hy-bar-icon-' + w + '" ></div>' + str;
                }
            }

            return str;
        },

        prettyDateFormatter : function (cellvalue, options, rowObject) {
            return prettyDateFormatterReal(cellvalue, options.colModel.formatoptions);
        },

        clusterStatusFormatter: function (cellvalue, options, rowObject) {
            if (cellvalue === undefined || cellvalue === "") {
                cellvalue = $(rowObject).find('status').text();
            }

            var status = efEncodeHtml(cellvalue.replace(/_/g, ' ').capitalize())

            return '<span class="hy-cluster-status hy-cluster-status-' + cellvalue.toLowerCase() + '">' + status + '</span>'
        },

        clusterGroupsFormatter: function (cellvalue, options, rowObject) {
            var access = 'allow'
            var allUsersGroup = "<div class='ef-service-group-tag ef-service-group-tag-" + access + "' title='" + efEncodeHtml("all-users") + "'>" + efEncodeHtml("all-users") + "</div>";
            var adminOnlyGroup = "<div class='ef-service-group-tag ef-service-group-tag-" + access + "' title='" + efEncodeHtml("admin-only") + "'>" + efEncodeHtml("admin-only") + "</div>";

            if (typeof cellvalue !== 'undefined' && cellvalue !== '') {
                var userGroups = cellvalue.split(',');
                var encGroups = []

                for (var i = 0; i < userGroups.length; i++) {
                    var group, plugin, name, encName;

                    var rx = /allow-to\[(.*)]/g;
                    var match = rx.exec(userGroups[i]) || [null, null];
                    group = match[1];
                    if (group === null)
                        continue;

                    plugin = group.split(':')[0];
                    name = group.split(':')[1];
                    if (name === '' || name === 'admin')
                        continue;

                    encName = efEncodeHtml(name);
                    encGroups.push("<div class='ef-service-group-tag ef-service-group-tag-" + access + "' title='" + encName + "'>" + encName + "</div>");
                }
                if (encGroups.length === 0)
                    encGroups.push(adminOnlyGroup)

                cellvalue = encGroups.join('');
            } else {
                cellvalue = allUsersGroup
            }
            return "<div class='applications-groups-list'>" + cellvalue + "</div>";
        },

        jobStatusFormatter: function (cellvalue, options, rowObject) {
            var cls, reasons, resources, tipDiv, array_jobs, array_pend, array_done, array_run,
                array_exit, array_susp, array_int, array_status_table, tooltip;

            if (cellvalue === undefined || cellvalue === "") {
                cellvalue = $(rowObject).find('status').text();
            }

            if (cellvalue === "") {
                array_jobs = $(rowObject).find('array-jobs').text();
                array_pend = $(rowObject).find('array-pend').text();
                array_done = $(rowObject).find('array-done').text();
                array_run = $(rowObject).find('array-run').text();
                array_exit = $(rowObject).find('array-exit').text();
                array_susp = $(rowObject).find('array-susp').text();
                array_int = $(rowObject).find('array-int').text();

                array_status_table = '<div class="hy-array-status"><table class="hy-array-status"><tr>';

                tooltip = "";
                if (array_pend > 0) {
                    tooltip = tooltip + ' ' + array_pend + " pending ";
                }
                if (array_done > 0) {
                    tooltip = tooltip + ' ' + array_done + " completed ";
                }
                if (array_run > 0) {
                    tooltip = tooltip + ' ' + array_run + " running ";
                }
                if (array_exit > 0) {
                    tooltip = tooltip + ' ' + array_exit + " exited ";
                }
                if (array_susp > 0) {
                    tooltip = tooltip + ' ' + array_susp + " suspended ";
                }
                if (array_int > 0) {
                    tooltip = tooltip + ' ' + array_int + " interrupted ";
                }

                if (array_pend > 0) {
                    array_pend = array_pend * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_pend + '%" class="hy-array-status-pend" title="' + tooltip + '" alt="' + tooltip + '">';
                    if (array_pend === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-pend">Pending</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }
                if (array_done > 0) {
                    array_done = array_done * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_done + '%" class="hy-array-status-done" title="' + tooltip + '" alt="' + tooltip + '">';
                     if (array_done === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-done">Done</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }
                if (array_run > 0) {
                    array_run = array_run * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_run + '%" class="hy-array-status-run" title="' + tooltip + '" alt="' + tooltip + '">';
                    if (array_run === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-run">Running</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }
                if (array_exit > 0) {
                    array_exit = array_exit * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_exit + '%" class="hy-array-status-exit" title="' + tooltip + '" alt="' + tooltip + '">';
                    if (array_exit === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-exit">Exit</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }
                if (array_susp > 0) {
                    array_susp = array_susp * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_susp + '%" class="hy-array-status-susp" title="' + tooltip + '" alt="' + tooltip + '">';
                    if (array_susp === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-susp">Suspending</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }
                if (array_int > 0) {
                    array_int = array_int * 100 / array_jobs;
                    array_status_table = array_status_table + '<td width="' + array_int + '%" class="hy-array-status-int" title="' + tooltip + '" alt="' + tooltip + '">';
                    if (array_int === 100) {
                        array_status_table = array_status_table + '<span class="hy-job-status hy-array-status-int">Interrupted</span>';
                    }
                    array_status_table = array_status_table + '</td>';
                }

                array_status_table = array_status_table + '</tr></table></div>';
                return '<span>' + array_status_table + '</span>';
            }

            cls = "hy-job-status hy-job-status-" + cellvalue.toLowerCase();

            if (cellvalue === 'Pending') {
                reasons = [];
                $('reason', rowObject).each(function (i) {
                    reasons.push($(this).text());
                });
                if (reasons.length > 0) {
                    return '<span class="hy-vtip ' + cls + '" title="' + reasons.join('|') + '">' + cellvalue + '</span>';
                }
            }

            resources = {
                'total-cpu-usage': 'CPU Usage',
                'memory-usage': 'Memory Usage',
                'swap-usage': 'Swap Usage'
            };

            tipDiv = null;

            $.each(resources, function (k, v) {
                var item = $(k, rowObject);
                if (item !== null && item.text().length > 0) {
                    if (tipDiv === null) {
                        tipDiv = $('<div></div>');
                    }
                    $('<p><strong>' + efEncodeHtml(v) + ':</strong> ' + efEncodeHtml(item.text()) + '</p>').appendTo(tipDiv);
                }
            });

            if (tipDiv !== null) {
                return '<span class="hy-vtip ' + cls + '">' + efEncodeHtml(cellvalue) + '<div class="ui-helper-hidden hy-vtip-content">' + tipDiv.html() + '</div></span>';
            }

            return '<span class="' + cls + '">' + efEncodeHtml(cellvalue) + '</span>';
        },

        executionHostFormatter: function (cellvalue, options, rowObject) {
            var n, html, op, grid, cluster;

            n = $(rowObject).find('execution-host').attr('n');
            if (n > 0) {
                html = '<div class="ef-grid-execution-hosts">' + n + ' Hosts</div>';
                /*
                html += '<ul>';
                $(rowObject).find('execution-host>host').each(function (index, hostElement) {
                    html += '<li>' + $(hostElement).text() + '</li>';
                });
                html += '</ul>';
                */
                return html;
            }

            grid = $(rowObject).attr("type");
            cluster = $(rowObject).find("cluster").text();

            op = {
                idName: 'host',
                id: cellvalue,
                serviceURI: '//com.enginframe.grid/host.info',
                addParam: {
                    'grid': grid,
                    'cluster': cluster
                }
            };
            return nameFormatterReal(cellvalue, op);
        },

        hostStatusFormatter: function (cellvalue, options, rowObject) {
            var str, cls, statusFormats;

            cls = null;
            statusFormats = {
                'ok': ['Ok', 'hy-host-status-ok'],
                'busy': ['Busy', 'hy-host-status-busy'],
                'unavailable': ['Unavailable', 'hy-host-status-unavailable'],
                'closed': ['Closed', 'hy-host-status-closed'],
                'starting': ['Starting', 'hy-host-status-starting'],
                'PoweredDown': ['PoweredDown', 'hy-host-status-PoweredDown'],
                'unknown': ['Unknown', 'hy-host-status-unknown'],
                'unlicensed': ['Unlicensed', 'hy-host-status-unlicensed'],
                'ef-unlicensed': ['Unlicensed', 'hy-host-status-unlicensed'],
                'registered': ['Registered', 'hy-host-status-registered']
            };

            try {
                str = statusFormats[cellvalue][0];
                cls = statusFormats[cellvalue][1];
            } catch (e) {
                str = cellvalue;
            }

            return "<span class='" + cls + "'>" + str + "</span>";
        },

        spoolerStatusFormatter: function (cellvalue, options, rowObject) {
            var status, cls, tooltip;

            if (cellvalue === undefined || cellvalue === "") {
                status = 'No_jobs';
            } else {
                status = cellvalue;
            }

            cls = "hy-spooler-status-" + status.toLowerCase().replace(/_/g, '-');

            switch (status) {
            case 'Waiting':
                tooltip = 'All jobs are pending';
                break;
            case 'Processing':
                tooltip = 'One or more jobs are running and no job has failed';
                break;
            case 'Processing_with_failed':
                status = 'Processing';
                tooltip = 'One or more jobs are running but at least one job has failed';
                break;
            case 'Completed':
                tooltip = 'All jobs are successfully completed';
                break;
            case 'Failed':
                tooltip = 'All jobs are completed but at least one job has failed';
                break;
            case 'Unknown':
                tooltip = 'Spooler status is unknown';
                break;
            case 'No_jobs':
                status = '--';
                tooltip = 'Spooler has no associated jobs';
                break;
            default:
                status = 'Invalid';
                cls = "hy-spooler-status-invalid";
                tooltip = 'Spooler status is invalid';
                break;
            }

            return '<span class="hy-spooler-status ' + cls + '" title="' + tooltip + '">' + status + '</span>';
        },

        addColumn : function (conf, id, coldata, opts) {
            conf[id] = conf[id] || {};
            conf[id].colmodel = conf[id].colmodel || [];

            // FIXME: also add 'before' and 'after' opts
            if (opts && opts.position !== undefined) {
                conf[id].colmodel.splice(opts.position, 0, coldata);
            } else {
                conf[id].colmodel.push(coldata);
            }
        },

        deleteColumn : function (conf, id, index) {
            if (conf[id] !== undefined && conf[id].colmodel !== undefined) {
                conf[id].colmodel = jQuery.grep(conf[id].colmodel, function (e, i) {
                    return e.index === index;
                }, true);
            }
        },

        addFilter : function (conf, id, filterdata, opts) {
            conf[id] = conf[id] || {};
            conf[id].filters = conf[id].filters || [];

            // FIXME: also add 'before' and 'after' opts
            if (opts && opts.position !== undefined) {
                conf[id].filters.splice(opts.position, 0, filterdata);
            } else {
                conf[id].filters.push(filterdata);
            }
        },

        composeFilter : function (params, op) {
            var filter;

            filter = "("
            $.each(params, function(i, element) {
                filter += element.key + " " + element.comparator + " '" + element.value + "'";
                if (i !== params.length - 1) {
                    filter += " " + op + " ";
              }
            });
            filter += ")"

            return filter;
        },

        deleteFilter : function (conf, id, filterId) {
            if (conf[id] !== undefined && conf[id].filters !== undefined) {
                conf[id].filters = jQuery.grep(conf[id].filters, function (e, i) {
                    return e.id === filterId;
                }, true);
            }
        },

        addChart : function (conf, id, chartdata, opts) {
            conf[id] = conf[id] || {};
            conf[id].charts = conf[id].charts || [];

            // FIXME: also add 'before' and 'after' opts
            if (opts && opts.position !== undefined) {
                conf[id].charts.splice(opts.position, 0, chartdata);
            } else {
                conf[id].charts.push(chartdata);
            }
        },

        deleteChart : function (conf, id, chartid) {
            if (conf[id] !== undefined && conf[id].charts !== undefined) {
                conf[id].charts = jQuery.grep(conf[id].charts, function (e, i) {
                    return e.chartid === chartid;
                }, true);
            }
        },

        addGlobalItemAction : function (conf, id, itemdata, opts) {
            conf[id] = conf[id] || {};
            conf[id]['global-action-items'] = conf[id]['global-action-items'] || [];

            // FIXME: also add 'before' and 'after' opts
            if (opts && opts.position !== undefined) {
                conf[id]['global-action-items'].splice(opts.position, 0, itemdata);
            } else {
                conf[id]['global-action-items'].push(itemdata);
            }
        },

        deleteGlobalItemAction : function (conf, id, item) {
            if (conf[id] !== undefined && conf[id]['global-action-items'] !== undefined) {
                conf[id]['global-action-items'] = jQuery.grep(conf[id]['global-action-items'], function (e, i) {
                    return e.id === item;
                }, true);
            }
        },

        addSingleItemAction : function (conf, id, itemdata, opts) {
            conf[id] = conf[id] || {};
            conf[id]['single-action-items'] = conf[id]['single-action-items'] || [];

            // FIXME: also add 'before' and 'after' opts
            if (opts && opts.position !== undefined) {
                conf[id]['single-action-items'].splice(opts.position, 0, itemdata);
            } else {
                conf[id]['single-action-items'].push(itemdata);
            }
        },

        deleteSingleItemAction : function (conf, id, item) {
            if (conf[id] !== undefined && conf[id]['single-action-items'] !== undefined) {
                conf[id]['single-action-items'] = jQuery.grep(conf[id]['single-action-items'], function (e, i) {
                    return e.id === item;
                }, true);
            }
        },

        addVRoot : function (conf, id, vrootdata, opts) {
            conf[id] = conf[id] || {};
            conf[id].vroots = conf[id].vroots || [];

            if (opts && opts.position !== undefined) {
                conf[id].vroots.splice(opts.position, 0, vrootdata);
            } else {
                conf[id].vroots.push(vrootdata);
            }
        },

        deleteVRoot : function (conf, id, vrootid) {
            if (conf[id] !== undefined && conf[id].vroots !== undefined) {
                conf[id].vroots = jQuery.grep(conf[id].vroots, function (e, i) {
                    return e.id === vrootid;
                }, true);
            }
        },

        addCluster : function (conf, id, cluster) {
            conf[id] = conf[id] || {};
            conf[id].clusters = conf[id].clusters || [];
            conf[id].clusters.push(cluster);
        },

        setParam : function (conf, id, pname, val) {
            conf[id] = conf[id] || {};
            conf[id].params = conf[id].params || {};
            conf[id].params[pname] = val;
        },

        populateConfiguration : function (actions) {
            var conf = {};

            jQuery.each(actions, function (i, f) {
                f(conf);
            });

            return conf;
        },

        invokeService: function (settings) {
            var wrapper;

            // console.log(settings);
            if (settings.modal != undefined && settings.modal == true) {
                var _action = "action";
                if (settings.modal_message) _action = settings.modal_message;
                var _modal_str = 'Please wait until action \"' + _action + '\" has finished ...';
                var modalHTML =
                    '<div id="hyModal" class="modal" onClick="javascript: $(\'#hyModal\').remove();">' +
                    '  <div class="modal-content">' + _modal_str +
                    '    <div style="margin-top: 30px;" class="loader">' +
                    '      <div class="loader-inner">' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '        <div class="loader-line-wrap">' +
                    '          <div class="loader-line" />' +
                    '        </div>' +
                    '      </div>' +
                    '    </div>' +
                    '  </div>' +
                    '</div>';
                // '    <span class="modal-close">&times;</span>' +
                // Append modal to body
                $('body').append(modalHTML);
                $('#hyModal').css('display', 'block');
                // create monitor
                $.hydrogen.fm_timer = window.setTimeout(function() {
                    jQuery.hydrogen.check_fm_log(settings);
                }, 500);
            }
            wrapper = $.extend({}, settings);

            wrapper.success = function (data, textStatus) {
                if (wrapper.messagebox !== null) {
                    $(wrapper.messagebox).hymessage('clear');
                }

                if ($.isFunction(settings.success)) {
                    settings.success(data, textStatus);
                }
            };

            wrapper.error = function (xhr, textStatus, errorThrown) {
                if (xhr.getAllResponseHeaders()) {
                    // If there are no headers, it means that the user navigated away and aborted the request
                    if (xhr.status === 403) {
                        $(wrapper.messagebox).hymessage('info', '<strong>The HTTP session is expired, you need to reintroduce your credentials to continue.</strong>');
                        setTimeout(function () {
                            // Refresh the entire page if the session is timed out
                            var loc = window.location;
                            window.location = loc.protocol + '//' + loc.host + loc.pathname + loc.search;
                        }, 2000);
                        return;
                    }

                    if (xhr.status === 200 && textStatus === 'parsererror') {
                        // This is a horrible trick to avoid problems when an empty XML document is produced
                        // server side

                        if ($.isFunction(settings.success)) {
                            if (xhr.responseXML) {
                                settings.success(xhr.responseXML, textStatus);
                            } else {
                                settings.success(xhr.responseText, textStatus);
                            }
                        }
                        return;
                    }

                    if (xhr.readyState !== 4 && wrapper.messagebox !== null) {
                        $(wrapper.messagebox).hymessage('alert', '<strong>An unknown error occurred while performing the requested action.</strong>');
                    } else if (wrapper.messagebox !== null) {
                        // Try to parse <ef:error>
                        if (xhr.responseXML) {
                            // xml result
                            if (wrapper.defaultErrorMessage) {
                                $(wrapper.messagebox).hymessage('error', $(xhr.responseXML), '<strong>' + efEncodeHtml(wrapper.defaultErrorMessage) + '</strong>');
                            } else {
                                $(wrapper.messagebox).hymessage('error', $(xhr.responseXML));
                            }
                        } else {
                            // text result
                            if (wrapper.defaultErrorMessage) {
                                $(wrapper.messagebox).hymessage('alert', xhr.responseText, '<strong>' + efEncodeHtml(wrapper.defaultErrorMessage) + '</strong>');
                            } else {
                                $(wrapper.messagebox).hymessage('alert', xhr.responseText);
                            }
                        }
                    }

                    if ($.isFunction(settings.error)) {
                        settings.error();
                    }
                }
            };

            $.enginframe.invokeService(wrapper);
        },

        executeAction: function (action, env, refresh, messagebox) {

            function replaceActionParams(aps, env) {
                var params;

                params = jQuery.extend({}, aps);

                // FIXME: implement a better param substitution method
                if (env !== null) {
                    $.each(params, function (key, val) {
                        var ids, subst;

                        if (env[val] !== undefined) {
                            if ($.isFunction(env[val])) {
                                subst = env[val]();
                            } else {
                                subst = env[val];
                            }
                            params[key] = subst;
                        }
                    });
                }

                return params;
            }

            if (action.confirmation !== undefined && action.confirmation !== '') {
                if (!confirm(action.confirmation)) {
                    return;
                }
            }

            var params, sdf, href, needQM, expandedEnv, js, browser, newWindow;

            switch (action.type) {
            case 'invoke-service':
                if (action.sdf && action.sdf !== "") {
                    sdf = action.sdf;
                } else {
                    sdf = $.hydrogen.SDF;
                }

                params = replaceActionParams(action.params, env);

                $.hydrogen.invokeService({
                    sdf: sdf,
                    uri: action.uri,
                    data: params,
                    success: function (data, textStatus) {
                        if (action.refresh && action.refresh === "page") {
                            location.reload();
                        } else {
                            refresh();
                        }
                    },
                    messagebox: messagebox
                });
                break;

            case 'open':
                params = replaceActionParams(action.params, env);

                href = action.href;

                if ((href.length === 0) && (action.uri.length > 0)) {
                    if (action.uri.substring(0, 2) === '//') {
                        href = location.pathname + '?_uri=';
                    } else {
                        href = location.pathname + '?_service=';
                    }

                    href += encodeURIComponent(action.uri);
                }

                if (href.length !== 0) {
                    needQM = false;
                    if (href.indexOf('?') === -1) {
                        needQM = true;
                    }

                    $.each(params, function (k, v) {
                        if (needQM) {
                            href += '?';
                            needQM = false;
                        } else {
                            href += '&';
                        }

                        href += encodeURIComponent(k) + '=' + encodeURIComponent(v);
                    });

                    if (action.target !== undefined && action.target !== '') {
                        browser = $.hydrogen.getBrowser();
                        if (browser.name === 'MSIE') {
                            // In this way IE sends Referer header needed to CSRF filter
                            newWindow = window.open('', action.target);
                            newWindow.location.href = href;
                        }
                        else {
                            window.open(href, action.target);
                        }
                    } else {
                        window.location = href;
                    }
                }
                break;
            case 'invoke-javascript':
                expandedEnv = {};
                if (env) {
                    $.each(env, function (key, val) {

                        if (val !== undefined) {
                            if ($.isFunction(val)) {
                                expandedEnv[key] = val();
                            } else {
                                expandedEnv[key] = val;
                            }
                        }
                    });
                }

                js = 'var environment;\nenvironment = ' + JSON.stringify(expandedEnv) + ';\n';
                js += action.js;
                eval(js);

                break;

            default:
                break;
            }
        },

        manageTableLoadErrorResult: function (data, genericMessage, messagebox) {
            var xmlResult;

            if (data.xhr.getAllResponseHeaders()) {
                // If there are no headers, it means that the user navigated away and aborted the request
                if (data.xhr.status === 403) {
                    messagebox.hymessage('info',
                    '<strong>The HTTP session is expired, you need to reintroduce your credentials to continue.</strong>');
                    setTimeout(function () {
                        // Refresh the entire page if the session is timed out
                        var loc = window.location;
                        window.location = loc.protocol + '//' + loc.host + loc.pathname + loc.search;
                    }, 2000);
                } else {
                    if (data.xhr.readyState !== 4) {
                        messagebox.hymessage('alert', '<strong>' + efEncodeHtml(genericMessage) + '</strong>');
                    } else {
                        // Try to parse <ef-error>
                        if (data.xhr.responseXML) {
                            xmlResult = jQuery(data.xhr.responseXML);
                        } else {
                            xmlResult = jQuery(data.xhr.responseText);
                        }

                        messagebox.hymessage('error', xmlResult, '<strong>' + efEncodeHtml(genericMessage) + "</strong>");
                    }
                }
            }
        },

        setupAutoRefresh: function (id, configuration, refreshFunc) {
            if (configuration[id] &&
                    configuration[id].params &&
                    configuration[id].params.autorefresh &&
                    configuration[id].params.autorefresh > 0 &&
                    jQuery.isFunction(refreshFunc)) {
                return setInterval(function () {
                    refreshFunc(id);
                }, configuration[id].params.autorefresh * 1000);
            }

            return -1;
        },

        formatDate: function (datestr, options) {
            return prettyDateFormatterReal(datestr, options);
        },

        // This function accepts other paramters beyond the first two.
        // They will be forwarded to the function to be executed.
        executeFunctionByName: function (functionName, context) {
            var args, namespaces, func, i;
            args = [].slice.call(arguments).splice(2);
            namespaces = functionName.split('.');
            func = namespaces.pop();
            for (i = 0; i < namespaces.length; i += 1) {
                context = context[namespaces[i]];
            }
            return context[func].apply(this, args);
        },

        getBrowser: function () {
            var userAgent, engine, client;

            userAgent = navigator.userAgent;
            engine = userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
            // engine[0] is the full match. I.e. "Firefox/52"
            // engine[1] is the name. I.e. "Firefox"
            // engine[2] is the version. I.e. "52"

            if (/trident/i.test(engine[1])) {
                client = userAgent.match(/\brv[ :]+(\d+)/) || [];
                return { name: 'MSIE', version: (client[1] || '') };
            }
            if (engine[1] === 'Chrome'){
                client = userAgent.match(/\b(OPR|Edge)\/(\d+)/)
                if (client != null) {
                    // client[0] is the full match. I.e. "Edge/14"
                    // client[1] is the name. I.e. "Edge"
                    // client[2] is the name. I.e. "14"
                    return { name: client[1].replace('OPR', 'Opera'), version: client[2] };
                }
            }
            engine = engine[2] ? [engine[1], engine[2]] : [navigator.appName, navigator.appVersion, '-?'];
            if ((client = userAgent.match(/version\/(\d+)/i)) != null) {
                engine.splice(1, 1, client[1]);
            }
            return { name: engine[0], version: engine[1] };
        },
    	check_fm_log: function(settings) {
	    // console.log('Timer run ... !');
	    jQuery.hydrogen.invokeService({
		sdf: "/" + jQuery.enginframe.rootContext + "/fm/lib/xml/com.enginframe.fm.xml",
		uri: "//com.enginframe.fm/fm_update_info",
		no_modal: true,
		data: {
		    spooler: settings.data.spooler,
		    vroot: settings.data.vroot,
		    path: settings.data.path,
		    fm_update: 1000
		},
		success: function(j) {
		    // fill info box
		    if (j == "" || j.match("FM_BEGIN")  ) return; 
		    if ( j.match("FM_FINISHED") ) {
			    jQuery.hydrogen.clear_fm_log();
			    return;
		    }
		    if (!$('#fmInfoDiv').length) {
			    var infoHTML =
			        '<div id="fmInfoDiv" class="fmInfoDiv">'+j+'</div>';
			    $('body').append(infoHTML);
			    $('#fmInfoDiv').css('display', 'block').draggable().css({cursor: 'move'});
                $(document).on('click', '#fmInfoDiv', function() {
                    $(this).remove();
                });
		    } else {
			    r = $('#fmInfoDiv')[0];
			    // console.log(r);
			    r.innerHTML=j;
		    }
		}
	    });
	    $.hydrogen.fm_timer = window.setTimeout(function() {
		jQuery.hydrogen.check_fm_log(settings);
	    }, 2100);
	},
	clear_fm_log: function() {
	    clearTimeout($.hydrogen.fm_timer);
	    $('#fmInfoDiv').remove();
	    $('#hyModal').remove();
	}
    });

    /*
     * Toggles whether an object is starred.
     */
    $.fn.toggleStar = function (uri) {
        return this.each(function () {
            var self;

            self = $(this);

            self.click(function () {
                var parent;

                self.toggleClass("hy-star-off").toggleClass("hy-star-on");
                parent = $(this).closest("tr").get(0);

                $.enginframe.invokeService({
                    sdf: $.hydrogen.SDF,
                    uri: "//ui.hydrogen/spooler.set.star",
                    data: {
                        _spooler_uri: uri || $(parent).attr("id"),
                        _star: self.hasClass("hy-star-on")
                    }
                });

                return false;
            });
        });
    };

    $.fn.vtip = function () {
        return $(this).tooltip({
            items: ".hy-vtip, [title]",
            content: function () {
                var element = $(this);

                if (element.is('.hy-vtip') && element.is('[title]')) {
                    return '<p>' + element.attr('title').replace(/\|/g, '<br />') + '</p>';
                }
                if (element.is('.hy-vtip')) {
                    return $('div.hy-vtip-content', element).html();
                }
                return element.attr('title');
            }
        });
    };

    /*--------------------------------------------------------------------
     * jQuery plugins: toEm() and toPx()
     * by Scott Jehl (scott@filamentgroup.com), http://www.filamentgroup.com
     * Copyright (c) Filament Group
     * Dual licensed under the MIT (filamentgroup.com/examples/mit-license.txt) and GPL (filamentgroup.com/examples/gpl-license.txt) licenses.
     * Article: http://www.filamentgroup.com/lab/update_jquery_plugin_for_retaining_scalable_interfaces_with_pixel_to_em_con/
     * Options:
            scope: string or jQuery selector for font-size scoping
     * Usage Example: $(myPixelValue).toEm(); or $(myEmValue).toPx();
    --------------------------------------------------------------------*/

    $.fn.toEm = function (settings) {
        var that, scopeTest, scopeVal;
        settings = jQuery.extend({
            scope: 'body'
        }, settings);
        that = parseInt(this[0], 10);
        scopeTest = jQuery('<div style="display: none; font-size: 1em; margin: 0; padding:0; height: auto; line-height: 1; border:0;">&nbsp;</div>').appendTo(settings.scope);
        scopeVal = scopeTest.height();
        scopeTest.remove();
        return (that / scopeVal).toFixed(8) + 'em';
    };


    $.fn.toPx = function (settings) {
        var that, scopeTest, scopeVal;
        settings = jQuery.extend({
            scope: 'body'
        }, settings);
        that = parseFloat(this[0]);
        scopeTest = jQuery('<div style="display: none; font-size: 1em; margin: 0; padding:0; height: auto; line-height: 1; border:0;">&nbsp;</div>').appendTo(settings.scope);
        scopeVal = scopeTest.height();
        scopeTest.remove();
        return Math.round(that * scopeVal) + 'px';
    };

    $.fn.inputHint = function (callerSettings) {
        var settings = $.extend(true, {}, $.fn.inputHint.settings, callerSettings);
        return this.each(function () {
            var n = $(this), v = settings.value || $(this).attr('title'), f = $(this.form);
            n.on("focus", function () {
                if (n.val() === v) {
                    n.val('').removeClass(settings.className);
                }
            }).on("blur", function () {
                if (n.val() === '') {
                    n.addClass(settings.className).val(v);
                }
            }).trigger("blur");

            if (f) {
                f.on("submit", function (e) {
                    n.trigger('focus');
                });
            }
        });
    };

    $.fn.inputHint.settings = {
        value: false,
        className: false
    };

    $.fn.idle = function (time) {
        var i = $(this);
        i.queue(function () {
            setTimeout(function () {
                i.dequeue();
            }, time);
        });

        return this;
    };

    $.fn.collapsibleBox = function (callerSettings) {
        var settings = $.extend(true, {
                title: null,
                speed: 'normal',
                initialState: 'open',
                /* cookieNamePrefix: null, */
                callback: null
            }, callerSettings);
        return this.each(function () {
            var self, /* cookieName ,*/ openClass, header, content, expander;
            self = $(this);

            /*
            cookieName = settings.cookieNamePrefix + '-' + (self.attr('id') || "");
            openClass = ($.cookie(cookieName) || settings.initialState) == 'open' ?
                'hy-collapsible-box-open' : 'hy-collapsible-box-closed';
            */

            openClass = (settings.initialState === 'open') ? 'hy-collapsible-box-open' : 'hy-collapsible-box-closed';

            self.addClass('hy-box hy-collapsible-box ui-widget');
            self.addClass(openClass);

            header = $('div:first', self).addClass('hy-box-header ui-widget-header ui-state-default');
            if (settings.title) {
                header.html(settings.title);
            }

            /* We add our own hy-box-content class since
             * IE6 does not support .hy-box > .ui-widget-content selector
             * and we do not want to apply properties to inner widgets in
             * in the box */
            content = header.next().hide().addClass('hy-box-content ui-widget-content');

            expander = $('<span class="ui-icon hy-collapsible-box-expander-icon"></span>').prependTo(header);
            if (openClass === 'hy-collapsible-box-open') {
                expander.addClass('ui-icon-triangle-1-s');
                content.show();
            } else {
                expander.addClass('ui-icon-triangle-1-e');
            }

            header.hover(
                function () {
                    $(this).addClass('ui-state-hover');
                },
                function () {
                    $(this).removeClass('ui-state-hover');
                }
            ).click(function () {
                if (self.hasClass('hy-collapsible-box-open')) {
                    expander.removeClass('ui-icon-triangle-1-s');
                    expander.addClass('ui-icon-triangle-1-e');

                    content.fadeOut(settings.speed, function () {
                        self.removeClass('hy-collapsible-box-open');
                        self.addClass('hy-collapsible-box-closed');
                        // $.cookie(cookieName, 'closed');
                        if (settings.callback) {
                            settings.callback(false);
                        }
                    });
                } else {
                    expander.removeClass('ui-icon-triangle-1-e');
                    expander.addClass('ui-icon-triangle-1-s');

                    content.fadeIn(settings.speed, function () {
                        self.removeClass('hy-collapsible-box-closed');
                        self.addClass('hy-collapsible-box-open');
                        // $.cookie(cookieName, 'open');
                        if (settings.callback) {
                            settings.callback(true);
                        }
                    });
                }
            });
        });
    };

    jQuery.event.special.widthchange = {

        setup: function () {
            var self, oldw, neww;

            self = this;
            oldw = $(self).width();

            $(self).data('widthchange_timer', setInterval(function () {
                neww = $(self).width();
                if (neww !== oldw) {
                    oldw = neww;
                    // NSW jQuery.event.handle.call(self, {type: 'widthchange'});
		    jQuery(self).trigger('widthchange');
                }
            }, 200));
        },

        teardown: function () {
            clearInterval($(this).data('widthchange_timer'));
        }
    };

    /*
     * Based on (changed because it was not handling escape correctly and to support openNewTab parameter)
     *
     * --------------------------------------------------------------------
     * jQuery-Plugin - $.download - allows for simple get/post requests for files
     * by Scott Jehl, scott@filamentgroup.com
     * http://www.filamentgroup.com
     * reference article: http://www.filamentgroup.com/lab/jquery_plugin_for_requesting_ajax_like_file_downloads/
     * Copyright (c) 2008 Filament Group, Inc
     * Dual licensed under the MIT (filamentgroup.com/examples/mit-license.txt) and GPL (filamentgroup.com/examples/gpl-license.txt) licenses.
     * --------------------------------------------------------------------
     */

    $.download = function (url, data, openNewTab) {
        var newWindow, form;

        form = jQuery('<form action="' + url + '" method="get"></form>');
        jQuery.each(data, function (k, v) {
            jQuery('<input type="hidden">').attr('name', k).attr('value', v).appendTo(form);
        });

        if (openNewTab) {
            newWindow = window.open('', '_blank');
            newWindow.location.href = window.location.href;
            jQuery(newWindow).load(function() {
                form.appendTo(newWindow.document.body).trigger("submit").remove();
            });
        }
        else {
            form.appendTo('body').trigger("submit").remove();
        }
    };

}(jQuery));

// ex:ts=4:et:
