/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hycompactview', {

        options: {
            conf: {},
            messageArea: null,
            defaultFilter: null,
            defaultLoadErrorMessage: "Cannot obtain the requested data from the server."
        },

        _filter: '',
        _sidx: '',
        _sord: 'asc',

        _params: null,

        _menu: null,
        _lastMenuRequest: null,

        _create: function () {

            var self, sortBy;

            self = this;

            this.element.addClass('hy-compact-view ui-widget');

            this.loadDiv = $('<div class="hy-compact-view-loading-wrapper">' +
                               '<div class="loading ui-state-default ui-state-active">Loading ...</div>' +
                             '</div>').appendTo(this.element).find('.loading');

            this.headerDiv = $('<div class="hy-compact-view-header ui-widget-content"></div>').appendTo(this.element);
            this.contentDiv = $('<div class="hy-compact-view-content ui-widget-content"></div>').appendTo(this.element);

            this.sortBySelect =
                $('<div style="float:left">' +
                    '<span>Sort by:</span>' +
                    '<span><select class="hy-compact-view-sort-by" name="sort-by" class="ui-state-default"></select></span>' +
                  '</div>').appendTo(this.headerDiv).find('select');

            this.sortOrd =
                $('<div style="float:left" title="Change sort order">' +
                    '<span class="ui-grid-ico-sort ui-icon-asc ui-state-enabled ui-icon ui-icon-triangle-1-n"></span>' +
                    '<span class="ui-grid-ico-sort ui-icon-desc ui-state-disabled ui-icon ui-icon-triangle-1-s"></span>' +
                  '</div>').appendTo(this.headerDiv);

            this._params = {
                multiselect: false,
                sortBy: "_natural:asc",
                SDF: "",
                graphicServiceUri: "",
                graphicServiceParams: {},
                actionsServiceUri: null,
                actionsServiceParams: {},
                actionsServiceSDF: $.hydrogen.SDF
            };

            $.extend(this._params, this.options.conf.params);
            sortBy = this._params.sortBy.split(':', 2);

            if (this.options.defaultFilter) {
                this._filter = this.options.defaultFilter;
            }

            $.each(this.options.conf.colmodel, function (i, col) {
                var option;

                if (col.sortable && !col.hidden) {
                    option = $('<option value="' + efEncodeHtml(col.name) + '">' + efEncodeHtml(col.label) + '</option>').
                        appendTo(self.sortBySelect);

                    if (sortBy[0] === col.name) {
                        // NSW option.attr('selected', 'selected');
                        option.prop('selected', true);
                    }
                }
            });

            self._sidx = this.sortBySelect.val();

            this.sortBySelect.change(function (val) {
                self._sort($(this).val(), 'asc');
                self.reload();
            });

            this.sortOrd.click(function (val) {
                var sord;
                sord = self._sord === 'asc' ? 'desc' : 'asc';
                self._sort(self.sortBySelect.val(), sord);
                self.reload();
            });
        },

        _sort: function (sidx, sord) {
            var self = this;

            self._sidx = sidx;
            if (sord === 'asc') {
                self._sord = 'asc';
                self.sortOrd.find('.ui-icon-asc').addClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-asc').removeClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-desc').addClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-desc').removeClass('ui-state-enabled');
            } else {
                self._sord = 'desc';
                self.sortOrd.find('.ui-icon-asc').addClass('ui-state-disabled');
                self.sortOrd.find('.ui-icon-asc').removeClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-desc').addClass('ui-state-enabled');
                self.sortOrd.find('.ui-icon-desc').removeClass('ui-state-disabled');
            }
        },

        destroy: function () {

            this.element.removeClass('hy-compact-view ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        reload: function (refreshMode) {
            if (this.element.is(':visible')) {
                var self = this;

                self.loadDiv.show();
                $.hydrogen.invokeService({
                    sdf: self._params.SDF,
                    uri: self._params.graphicServiceUri,
                    data: $.extend({
                        filter: self._filter,
                        sidx: self._sidx,
                        sord: self._sord,
                        refresh: refreshMode || ""
                    }, self._params.graphicServiceParams),
                    complete: function () {
                        self.loadDiv.hide();
                    },
                    success: function (html) {
                        self.contentDiv.html(html);
                        if (self._params.multiselect) {
                            $(".hy-selectable", self.contentDiv).selectable(
                                {
                                    filter: ".hy-selectable-item",
                                    cancel: "a"
                                }
                            );
                            $(".hy-selectable-item", self.contentDiv).hover(
                                function () {
                                    $(this).addClass("ui-state-hover");
                                },
                                function () {
                                    $(this).removeClass("ui-state-hover");
                                }
                            );

                            $(".hy-selectable-item-menu", self.contentDiv).mousedown(
                                function () {
                                    var id;
                                    id = $(this).closest(".hy-selectable-item").attr("id");
                                    self._populateMenu(this, id);
                                    return false;
                                }
                            );
                        }

                        self._trigger('loadcomplete', null, {data: html});
                        self._trigger('selectionchanged');
                    },
                    dataType: 'html',
                    messagebox: self.options.messageArea,
                    defaultErrorMessage: self.options.defaultLoadErrorMessage
                });
            }

            return this;
        },

        selected: function () {
            var selectedItems = [];
            $(".hy-selectable-item.ui-selected", this.contentDiv).each(function () {
                selectedItems.push($(this).attr("id"));
            });
            return selectedItems;
        },

        filter: function (newFilter) {
            if (newFilter === undefined) {
                return this._filter;
            }

            this._setOption('filter', newFilter);

            return this;
        },

        _setOption: function (key, value) {
            switch (key) {
            case 'filter':
                this._filter = value;
                this.reload();
                this._trigger('filterchange', null, {formula: value});
                break;
            }

            $.Widget.prototype._setOption.apply(this, arguments);
        },

        _menuActivate: function (e, menuItem) {
            menuItem.data.widget._trigger('action', null,
                                            {action: menuItem.data.action, currentId: menuItem.data.rowid});
        },

        _populateMenu: function (element, id) {
            var menu_options, actionsServiceParams, self;

            self = this;

            if (this._menu !== null) {
                this._menu.destroy();
            }

            menu_options = {
                minWidth: 150,
                offsetLeft: 8,
                offsetTop: 1,
                onClick: this._menuActivate,
                divClass: "hy-compactview-menu hy-table-menu",
                // effect: "blind",
                onClose: function () {
                    // row.removeClass("ui-state-ef-highlight");
                    self._menu.destroy();
                    self._menu = null;
                }
            };  // 2px more cause margins

            this._menu = new $.Menu(element, null, menu_options);
            $.each(this.options.conf['single-action-items'], function (i, item) {
                self._menu.addItem(new $.MenuItem({
                    src: efEncodeHtml(item.name),
                    icon: item.icon,
                    addClass: item.classes,
                    data: {
                        menuid: item.id,
                        widget: self,
                        rowid: id,
                        action: item.action
                    }
                }, menu_options));
            });

            this._menu.show();
            if (this._params.actionsServiceUri && this._params.actionsServiceSDF) {

                if (this._lastMenuRequest) {
                    this._lastMenuRequest.abort();
                }

                actionsServiceParams = {
                    'rowId': id,
                    'widgetId': self._params.widgetId
                };
                $.extend(actionsServiceParams, self._params.actionsServiceParams);

                // Expand special action params
                $.each(actionsServiceParams, function (k, v) {
                    if (v) {
                        actionsServiceParams[k] = v.replace(/^@\{rowId\}$/, function () {
                            return id;
                        });
                    } else {
                        actionsServiceParams[k] = "";
                    }
                });

                // FIXME: do we really want to ignore error messages here?
                this._lastMenuRequest = $.enginframe.invokeService({
                    sdf: this._params.actionsServiceSDF,
                    uri: this._params.actionsServiceUri,
                    data: actionsServiceParams,
                    success: function (jsonObj) {
                        $.each(jsonObj, function (i, item) {
                            self._menu.addItem(new $.MenuItem({
                                src: efEncodeHtml(item.name),
                                icon: item.icon,
                                addClass: item.classes,
                                data: {
                                    menuid: item.id,
                                    widget: self,
                                    rowid: id,
                                    action: item.action
                                }
                            }, menu_options));
                        });
                        self._menu.show();
                    },
                    dataType: 'json'
                });
            }
        }
    });

}(jQuery));

// ex:ts=4:et:
