/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hyfilters', {

        options: {
            title: null,
            conf: {}
        },

        _create: function () {
            var self;

            self = this;
            this._selected = null;

            if (this.options.conf.filters && this.options.conf.filters.length > 0) {
                this.element.addClass('hy-box hy-filters ui-widget');

                this.headerDiv = $('<div></div>').appendTo(this.element);
                this.contentDiv = $('<div></div>').appendTo(this.element);
                this.contentUl = $('<ul></ul>').appendTo(this.contentDiv);

                this.headerDiv.addClass('hy-box-header ui-widget-header');
                this.contentDiv.addClass('hy-box-content ui-widget-content');
                this.contentUl.addClass('ui-helper-reset');

                if (this.options.title === null) {
                    this.headerDiv.text('Filters');
                } else {
                    this.headerDiv.text(this.options.title);
                }

                $.each(this.options.conf.filters, function (i, filter) {
                    var filterLi;

                    filterLi = $('<li>' + efEncodeHtml(filter.label) + '</li>');
                    self.contentUl.append(filterLi);

                    if ((i === 0) || filter.isDefault) {
                        self.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');
                        filterLi.addClass('ui-state-highlight');
                        self._selected = {
                            formula: filter.formula,
                            dataSourceQuery: filter.dataSourceQuery
                        };
                    }

                    filterLi.bind('click', {self: self, filter: filter}, function (event) {
                        var filterLi, self, filterFormula;
                        filterLi = $(this);

                        if (!filterLi.hasClass('ui-state-highlight')) {
                            self = event.data.self;
                            filterFormula = event.data.filter.formula;
                            filterDataSourceQuery = event.data.filter.dataSourceQuery;
                            self.unselectAll();
                            filterLi.addClass('ui-state-highlight');
                            self._selected = {
                                formula: filterFormula,
                                dataSourceQuery: filterDataSourceQuery
                            };
                            self._trigger('select', null, {
                                formula: filterFormula,
                                dataSourceQuery: filterDataSourceQuery
                                });
                        }

                        event.stopPropagation();
                    });
                });
            } else {
                // hide the filter box if no filters are specified
                this.element.hide();
                return;
            }
        },

        destroy: function () {

            this.element.removeClass('hy-box hy-filters ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        unselectAll: function () {
            this._selected = null;
            this.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');

            return this;
        },

        // For backward compatibility this method returns only the formula
        // Use selectedDataSourceQuery to get the query
        selected: function () {
            return this._selected.formula;
        },

        selectedDataSourceQuery: function () {
            return this._selected.dataSourceQuery;
        }
    });

}(jQuery));

// ex:ts=4:et:
