/* global jQuery, setTimeout */
/*
 * Copyright 2024 by NI SP Software GmbH, All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
 */

(function ($) {

    $.hydrogen = $.hydrogen || {};

    $.extend($.hydrogen, {

        changeNiceDialog: function (grid, cluster, jobIds, messagebox, onSuccess) {
            var dialog, entry, button;

            dialog = $('<div class="hy-simple-input-dialog"></div>').appendTo($('body'));
            $('<label for="new-value" style="display:block">Adjust to:</label>').appendTo(dialog);
            entry = $('<input type="number" name="value" id="new-value" value="10" style="width:90%"></input>');
            entry.appendTo(dialog);
            $('<div><br/>Standard users can adjust to positive values.</div>').appendTo(dialog);

            dialog.dialog({
                title: "Adjust Nice Value",
                resizable: false,
                modal: true,
                buttons: {
                    Cancel: function () {
                        $(this).dialog("close");
                    },
                    Change: function () {
                        var newValue;

                        newValue = entry.val();
                        if (newValue.length <= 0) {
                            return false;
                        }

                        $(this).dialog("close");

                        $.hydrogen.invokeService({
                            sdf: '/' + $.enginframe.rootContext + '/' + grid + '/grid.' + grid + '.job.actions.xml',
                            uri: '//grid.' + grid + '.job.actions/job.change.nice',
                            data: {
                                jobid: jobIds,
                                cluster: cluster,
                                value: newValue
                            },
                            success: function (out) {
                                if (out && out.match(/^Operation succeeded with errors:/)) {
                                    // TODO: a warning yellowish message would be nicer here
                                    messagebox.hymessage('alert', out);
                                } else {
                                    messagebox.hymessage('info', out);
                                    setTimeout(function() { onSuccess(); }, 3000);
                                }
                            },
                            messagebox: messagebox.hymessage()
                        });
                    }
                }
            });

            button = $('button:contains(Change)', dialog.parent('div.ui-dialog'));
            button.addClass('ui-priority-primary');
            entry.keypress(function (e) {
                if (e.which === 13) {
                    button.click();
                    return false;
                }

                return true;
            });
        }
    });

}(jQuery));

// ex:ts=4:et:
