/*global jQuery, escape, alert */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.hydrogen = $.hydrogen || {};

    $.extend($.hydrogen, {

        renameSpoolerDialog: function (spoolerUri, messagebox, onSuccess) {
            var dialog, entry, button;

            dialog = $('<div class="hy-simple-input-dialog"></div>').appendTo($('body'));
            $('<label for="new-value" style="display:block">New name:</label>').appendTo(dialog);
            entry = $('<input type="text" name="value" id="new-value" style="width:90%"></input>');
            entry.prop('disabled', true).appendTo(dialog);

            dialog.dialog({
                title: "Rename Spooler",
                resizable: false,
                modal: true,
                buttons: {
                    Cancel: function () {
                        $(this).dialog("close");
                    },
                    Rename: function () {
                        var newValue;

                        newValue = entry.val();
                        if (newValue.length <= 0) {
                            return false;
                        }

                        $(this).dialog("close");
                        $.hydrogen.invokeService({
                            sdf: '/' + $.enginframe.rootContext + '/lib/xml/com.enginframe.system.xml',
                            uri: '//com.enginframe.system/rename.spooler',
                            action: "rename",
                            data: {
                                _spooler: spoolerUri,
                                _new_name: newValue
                            },
                            success: function (xml) {
                                onSuccess();
                            },
                            messagebox: messagebox
                        });
                    }
                }
            });

            button = $('button:contains(Rename)', dialog.parent('div.ui-dialog'));
            button.prop('disabled', true).addClass('ui-priority-primary');
            entry.keypress(function (e) {
                if (e.which === 13) {
                    button.click();
                    return false;
                }

                return true;
            });

            dialog.dialog("option", "disabled", true);

            $.enginframe.invokeService({
                sdf: '/' + $.enginframe.rootContext + '/lib/xml/com.enginframe.system.xml',
                uri: '//com.enginframe.system/spooler.name',
                data: {
                    _spooler: spoolerUri
                },
                success: function (name) {
                    entry.val(name).prop('disabled', false).select();
                    button.prop('disabled', false);
                    dialog.dialog("option", "disabled", false);
                },
                error: function () {
                    entry.prop('disabled', false);
                    button.prop('disabled', false);
                    dialog.dialog("option", "disabled", false);
                }
            });
        }
    });

}(jQuery));

// ex:ts=4:et:
