/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hymessage', {

        options: {
            speed: 'normal'
        },

        _create: function () {
            var contentTable, self;

            this.element.addClass('hy-message');
            if (this.element.closest('.ui-widget').length <= 0) {
                this.element.addClass('ui-widget');
            }

            this.contentDiv = $('<div></div>').appendTo(this.element);
            contentTable = $('<table width="100%">' +
                             '  <tr>' +
                             '    <td><span></span></td>' +
                             '    <td width="99%"><span></span></td>' +
                             '    <td><span class="ui-icon ui-icon-close"></span></td>' +
                             '  </tr>' +
                             '</table>').appendTo(this.contentDiv);

            this.iconSpan = $('span', contentTable).eq(0);
            this.msgSpan = $('span', contentTable).eq(1);

            this.closeButtonSpan = $('span', contentTable).eq(2);

            self = this;
            this.closeButtonSpan.click(function () {
                self.clear();
            });

            this.element.hide();
        },

        destroy: function () {
            this.element.removeClass('hy-message ui-widget');
            this.contentDiv.remove();
            $.Widget.prototype.destroy.apply(this, arguments);
            return this;
        },

        info: function (html, timeout) {
            if (!html) {
                // getter
                return this.msgSpan.html();
            }

            this.contentDiv.removeClass();
            this.contentDiv.addClass('ui-state-highlight ui-corner-all');

            this.iconSpan.removeClass();
            this.iconSpan.addClass('ui-icon ui-icon-info');

            this.msgSpan.html(html);

            this.element.fadeIn(this.options.speed);
            if (timeout) {
                this.closeButtonSpan.hide();
                this.element.idle(timeout).fadeOut(this.options.speed, function () {
                    $(this).trigger('hymsgInfoFadeoutEvent');
                });
            } else {
                this.closeButtonSpan.show();
            }

            return this;
        },

        alert: function (html, timeout) {
            if (!html) {
                // getter
                return this.msgSpan.html();
            }

            this.contentDiv.removeClass();
            this.contentDiv.addClass('ui-state-error ui-corner-all');

            this.iconSpan.removeClass();
            this.iconSpan.addClass('ui-icon ui-icon-alert');

            this.msgSpan.html(html);

            this.element.fadeIn(this.options.speed);
            if (timeout) {
                this.closeButtonSpan.hide();
                this.element.idle(timeout).fadeOut(this.options.speed, function () {
                    $(this).trigger('hymsgAlertFadeoutEvent');
                });
            } else {
                this.closeButtonSpan.show();
            }

            return this;
        },

        /*
         * This is a special function to handle <ef:error>.
         * xmlResult must be a jQuery object containing the XML document)
         */
        error: function (xmlResult, genericMessage) {
            var errorMsg, primaryMessage, secondaryMessage, command, number;

            errorMsg = "";

            messageTitle = xmlResult.find('ef\\:title, title').eq(0).text();
            primaryMessage = xmlResult.find('ef\\:message, message').eq(0).text();
            secondaryMessage = xmlResult.find('ef\\:secondary-message, secondary-message').eq(0).text();
            command =  xmlResult.find('ef\\:command, command').eq(0).text();
            number =  xmlResult.find('ef\\:error-number, error-number').eq(0).text();

            if (messageTitle && messageTitle.length > 0) {
                errorMsg = "<div class=\"hy-error-title\">" + efEncodeHtml(messageTitle) + "</div>";
            }

            if (primaryMessage && primaryMessage.length > 0) {
                errorMsg += "<div class=\"hy-error-primary-message\">" + efEncodeHtml(primaryMessage) + "</div>";
            }

            if (secondaryMessage && secondaryMessage.length > 0) {
                errorMsg += "<div class=\"hy-error-secondary-message\">" + efEncodeHtml(secondaryMessage) + "</div>";
            }

            if (number && number.length > 0) {
                errorMsg += "<div class=\"hy-error-secondary-message\">The error number is: <strong>" + efEncodeHtml(number) + "</strong></div>";
            }

            if (command && command.length > 0) {
                errorMsg += "<div class=\"hy-error-command\">Error occurred executing the command: <tt>" + efEncodeHtml(command) + "</tt></div>";
            }

            if (errorMsg.length === 0) {
                if (genericMessage) {
                    errorMsg = genericMessage;
                } else {
                    errorMsg = '<strong>Error: </strong>An unknown error occurred while performing the requested action.</strong>';
                }
            }

            return this.alert(errorMsg);
        },

        clear: function () {
            this.element.fadeOut(this.options.speed);
        }
    });

}(jQuery));

// ex:ts=4:et:
