/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    var simpleEncoding = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

    function simpleEncode(valueArray, maxValue) {
        var i, chartData, currentValue;

        chartData = [];
        $.each(valueArray, function (i, v) {
            if (!isNaN(v) && v >= 0) {
                chartData.push(simpleEncoding.charAt(Math.round((simpleEncoding.length - 1) * v / maxValue)));
            } else {
                chartData.push('_');
            }
        });

        return chartData.join('');
    }

    $.widget('ui.hyqueues', {

        options: {
            conf: {},
            title: null
        },

        _create: function () {
            var title;

            this.element.hide();
            this.element.addClass('hy-box hy-queues ui-widget');

            this.headerDiv = $('<div class="hy-box-header ui-widget-header"></div>').appendTo(this.element);
            this.contentDiv = $('<div class="hy-box-content ui-widget-content"></div>').appendTo(this.element);
            this.contentUl = $('<ul class="ui-helper-reset"></ul>').appendTo(this.contentDiv);
            this.contentImg = $('<img/>').hide().appendTo(this.contentDiv);

            this.chartSrc = null;
            this.numOfQueues = 0;

            title = this.options.title || 'Queues';
            this.headerDiv.text(title);

            this._active = null;
        },

        destroy: function () {
            this.element.removeClass('hy-box hy-queues ui-widget');
            this.headerDiv.remove();
            this.contentDiv.remove();
            $.Widget.prototype.destroy.apply(this, arguments);
            return this;
        },

        update: function () {
            var self;
            self = this;
            $.enginframe.invokeService({
                sdf: this.options.conf.params.SDF,
                uri: this.options.conf.params.listQueuesServiceUri,
                data: $.extend({sidx: 'jobs', sord: 'desc', rows: 99999},
                         this.options.conf.params.listQueuesServiceParams || {}),
                success: function (xml) {
                    self._realUpdate(xml);
                },
                dataType: 'xml'
            });
        },

        resetSize: function () {
            if (this.chartSrc === null) {
                this._hideChart();
            } else {
                this._showChart();
            }

            return this;
        },

        _realUpdate: function (xml) {
            // Add queues
            var i, others, chartData, chartLegend, self, othersLi, maxValue, data, chartType;

            this.chartSrc = null;
            this.numOfQueues = 0;

            others = {
                jobs: 0,
                pend: 0,
                run: 0,
                susp: 0
            };
            maxValue = 0;
            chartData = {
                jobs: [],
                pend: [],
                run: [],
                susp: []
            };

            chartLegend = [];

            this.contentUl.empty();

            self = this;

            $('queue-list>queue', xml).each(function () {
                var queue, name, label, queueLi, count;

                queue = $(this);

                count = {
                    jobs: parseInt($('jobs', queue).text(), 10),
                    pend: parseInt($('job-pending', queue).text(), 10),
                    run: parseInt($('job-running', queue).text(), 10),
                    susp: parseInt($('job-suspended', queue).text(), 10)
                };

                if (count.jobs <= 0) {
                    return;
                }

                maxValue = Math.max(maxValue, count.jobs);

                self.numOfQueues += 1;

                if (self.numOfQueues < 6) {
                    name = $('name', queue).text();
                    label = name === "" ? "undefined" : name;

                    chartData.jobs.push(count.jobs);
                    chartData.pend.push(count.pend);
                    chartData.run.push(count.run);
                    chartData.susp.push(count.susp);

                    queueLi = $("<li>" + String.fromCharCode(64 + self.numOfQueues) + ' - ' + efEncodeHtml(label) +
                                " (" + count.jobs + ")</li>");
                    self.contentUl.append(queueLi);

                    if (name === self._active) {
                        queueLi.addClass("ui-state-highlight");
                    }

                    if (name === "") {
                        queueLi.addClass("hy-queue-undefined");
                    }

                    queueLi.bind('click', function () {
                        if (!queueLi.hasClass("ui-state-highlight")) {
                            self.unselectAll();
                            queueLi.addClass('ui-state-highlight');
                            self._active = name;
                            self._trigger('select', null, {formula: self.selected()});
                        }
                    });
                } else {
                    others.jobs += count.jobs;
                    others.pend += count.pend;
                    others.run += count.run;
                    others.susp += count.susp;
                }
            });

            if (this.numOfQueues === 0) {
                this.element.hide();
                return this;
            }

            if (this.numOfQueues >= 6) {
                othersLi = $('<li>' + String.fromCharCode(64 + 6) + ' - Others (' + others.jobs + ')</li>');
                othersLi.addClass('ui-state-disabled');
                this.contentUl.append(othersLi);

                chartData.jobs.push(others.jobs);
                chartData.pend.push(others.pend);
                chartData.run.push(others.run);
                chartData.susp.push(others.susp);
                maxValue = Math.max(maxValue, others.jobs);
            }

            this.element.show();

            chartType = this.options.conf.params.queuesChartType || "bar";

            if (maxValue > 0 && chartType !== 'none') {

                data = 's:';
                switch (chartType) {
                case "pie":
                    data += simpleEncode(chartData.jobs, maxValue);

                    for (i = 0; i < chartData.pend.length; i += 1) {
                        chartLegend.push(String.fromCharCode(65 + i));
                    }

                    this.chartSrc = $.enginframe.chartsBaseUrl + "?cht=p&chdlp=b&chdl=" +
                            chartLegend.join('%7C') + "&chd=" + data;
                    break;
                case "bar":
                    data += simpleEncode(chartData.pend, maxValue) + ',';
                    data += simpleEncode(chartData.run, maxValue) + ',';
                    data += simpleEncode(chartData.susp, maxValue);

                    for (i = chartData.pend.length; i > 0; i -= 1) {
                        chartLegend.push(String.fromCharCode(64 + i));
                    }

                    this.chartSrc = $.enginframe.chartsBaseUrl + "?cht=bhs&chco=FFCC00,3399CC,CCCCCC&" +
                            "chd=" + data +
                            "&chxr=1,0," + maxValue + "&chxt=y,x&chxl=0:%7C" + chartLegend.join('%7C') +
                            "&chdl=Pending+Jobs+Slots%7CRunning+Jobs+Slots%7CSuspended+Jobs+Slots&chdlp=bv";
                    break;
                }
            }

            if (this.chartSrc !== null) {
                // Makes queues box visible (it is hidden by default)
                this._showChart();
            } else {
                this._hideChart();
            }

            return this;
        },

        _showChart: function () {
            var src, imgWidth, imgHeight, chartType;

            chartType = this.options.conf.params.queuesChartType || "bar";

            imgWidth = this.contentUl.innerWidth();
            if (imgWidth < 140) {
                return this._hideChart();
            }

            imgHeight = imgWidth;

            if (chartType === "bar") {
                imgHeight = Math.max(100, Math.ceil(imgWidth / 3 + Math.min(this.numOfQueues, 6) * 35));
            }

            src = this.chartSrc + "&chs=" + Math.floor(imgWidth) + "x" + Math.floor(imgHeight);

            this.contentImg.attr({
                width: imgWidth,
                height: imgHeight,
                src: src
            });

            this.contentImg.show();

            return this;
        },

        _hideChart: function () {
            this.contentImg.hide();

            return this;
        },

        selected: function () {
            if (this._active === null) {
                return null;
            }

            if (this._active === '') {
                return '!queue';
            }
            return 'queue = \'' + this._active + '\'';
        },

        unselectAll: function () {
            this._active = null;
            this.contentUl.children('li.ui-state-highlight').removeClass('ui-state-highlight');

            return this;
        }
    });

}(jQuery));

// ex:ts=4:et:
