/*global jQuery */

/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {
    var serviceprofileSDF = '/' + jQuery.enginframe.rootContext + '/ef/lib/xml/com.enginframe.serviceprofile.xml';

    function compareProfiles(a, b) {
        if (a.name.toUpperCase() < b.name.toUpperCase()) {
            return -1;
        }
        if (a.name.toUpperCase() > b.name.toUpperCase()) {
            return 1;
        }
        return 0;
    }

    function defaultFormSerialize(form) {
        return $(form).formSerialize();
    }

    function defaultFormDeserialize(form, content) {
        return $(form).clearForm().deserialize(content, {change: function () {
            $(this).trigger("change");
        }});
    }


    $.extend($.hydrogen, {

        serviceProfileSelector: function (conf) {
            var form, messageArea, loadmenu, loadbutton, managebutton, profiles,
                agentId, serviceId, canCertify,
                formSerialize, formDeserialize;

            if (!jQuery.isPlainObject(conf)) {
                if (window.console && window.console.warn) {
                    window.console.warn("Expected object, got " + typeof conf);
                }
                return;
            }

            agentId = conf.agentId;
            serviceId = conf.serviceId;
            canCertify = conf.canCertify;

            formSerialize   = jQuery.isFunction(conf.formSerialize)   ? conf.formSerialize   : defaultFormSerialize;
            formDeserialize = jQuery.isFunction(conf.formDeserialize) ? conf.formDeserialize : defaultFormDeserialize;

            function loadProfiles(onSuccess) {
                profiles = {};

                if (loadmenu.hasClass('ui-menu')) {
                    loadmenu.menu('destroy');
                    loadmenu.empty();
                }

                $.hydrogen.invokeService({
                    sdf: $.hydrogen.SDF,
                    uri: '//ui.hydrogen/list.service.profiles',
                    data: {
                        agentId: agentId,
                        serviceId: serviceId
                    },
                    success: function (xml) {
                        var doc, userprofiles, certifiedprofiles;

                        doc = $(xml);

                        userprofiles = [];
                        certifiedprofiles = [];

                        $('service-profile', doc).each(function () {
                            var profile = {
                                id: $(this).attr('id'),
                                name: $(this).find('name').text(),
                                certified: $(this).attr('certified') === 'true',
                                options: []
                            };
                            $('option', $(this)).each(function () {
                                profile.options.push({
                                    name: $(this).attr('id'),
                                    value: $(this).text()
                                });
                            });
                            profiles[profile.id] = profile;
                            if (profile.certified) {
                                certifiedprofiles.push(profile);
                            } else {
                                userprofiles.push(profile);
                            }
                        });

                        if (userprofiles.length) {
                            $('<li class="hy-serviceprofile-loadmenu-header ui-state-disabled"><a class="ui-corner-all" href="#">Saved Profiles</a></li>').appendTo(loadmenu);
                            $.each(userprofiles.sort(compareProfiles), function (i, p) {
                                $('<li><a href="#">' + efEncodeHtml(p.name) + '</a></li>').attr('id', p.id).appendTo(loadmenu);
                            });
                        }

                        if (certifiedprofiles.length) {
                            $('<li class="hy-serviceprofile-loadmenu-header ui-state-disabled"><a class="ui-corner-all" href="#">Shared Profiles</span></li>').appendTo(loadmenu);
                            $.each(certifiedprofiles.sort(compareProfiles), function (i, p) {
                                $('<li><a href="#">' + efEncodeHtml(p.name) + '</a></li>').attr('id', p.id).appendTo(loadmenu);
                            });
                        }

                        if (!$.isEmptyObject(profiles)) {
                            loadmenu.menu({
                                select: function (event, ui) {
                                    formDeserialize(form, profiles[$(ui.item).attr('id')].options);
                                    $(form).trigger("serviceProfileLoaded", [agentId, serviceId,  profiles[$(ui.item).attr('id')].id,  profiles[$(ui.item).attr('id')].certified]);
                                }
                            }).hide();

                            loadbutton.show();
                            managebutton.show();
                        } else {
                            loadmenu.hide();
                            loadbutton.hide();
                            managebutton.hide();
                        }

                        if ($.isFunction(onSuccess)) {
                            onSuccess();
                        }
                    },
                    messagebox: messageArea
                });
            }

            form = $('#serviceform');
            if (form === undefined || form.length === 0) {
                return;
            }

            $('<div id="serviceprofile-message-area"></div>' +
                    '<ul id="serviceprofile-loadmenu" class="ui-helper-hidden"></ul>' +
                    '<div class="hy-serviceprofile-controls">' +
                    '  <button id="serviceprofile-load" style="display:none;">Load Profile</button>' +
                    '  <button id="serviceprofile-save">Save Profile</button>' +
                    '  <button id="serviceprofile-manage" style="display:none;">Manage Profiles</button>' +
                    '</div>').insertBefore($('#servicetitle'));

            messageArea = $("div#serviceprofile-message-area").hymessage();

            loadmenu = $("ul#serviceprofile-loadmenu");

            loadbutton = $("button#serviceprofile-load").button({
                icon: "ui-icon-triangle-1-s"
            }).click(function () {
                loadmenu.toggle().position({
                    my: "left top",
                    at: "left bottom",
                    of: this
                });
                $(document).one("click", function () {
                    loadmenu.hide();
                });
                return false;
            });

            $("button#serviceprofile-save").button().click(function () {
                var isSaving, dialog, entry, button, dialogButtons;

                isSaving = false;

                dialog = $('<div class="hy-simple-input-dialog"></div>').appendTo($('body'));
                $('<label for="new-value" style="display:block">Name:</label>').appendTo(dialog);
                entry = $('<input type="text" name="value" id="new-value" style="width:90%"></input>').appendTo(dialog);

                dialogButtons = {
                    Cancel: function () {
                        $(this).dialog("close");
                    },
                    Save: function () {
                        var self, profileName;

                        if (isSaving) {
                            return;
                        }

                        self = this;

                        profileName = entry.val();
                        if (profileName.length <= 0) {
                            return false;
                        }

                        isSaving = true;

                        $('<img class="hy-upload-indicator" src="/' + $.enginframe.rootContext + '/hydrogen/images/indicator.gif"></img>')
                            .appendTo($('.ui-dialog-buttonpane', dialog.parent('div.ui-dialog')));

                        $.hydrogen.invokeService({
                            sdf: serviceprofileSDF,
                            uri: '//com.enginframe.serviceprofile/save.profile',
                            data: {
                                agentId: agentId,
                                serviceId: serviceId,
                                serviceOptions: formSerialize(form),
                                profileName: profileName
                            },
                            complete: function () {
                                loadProfiles(function () {
                                    isSaving = false;
                                    dialog.dialog("close");
                                });
                            },
                            messagebox: messageArea,
                            defaultErrorMessage: "Cannot save the current profile."
                        });

                        // return false to prevent normal browser submit and page navigation
                        return false;
                    }
                };

                dialog.dialog({
                    title: "Save Profile",
                    resizable: false,
                    buttons: dialogButtons,
                    beforeclose: function (event, ui) {
                        if (isSaving) {
                            return false;
                        }
                    },
                    modal: true,
                    bgiframe: true
                });

                button = $('button:contains(Save)', dialog.parent('div.ui-dialog'));
                button.addClass('ui-priority-primary');
                entry.keypress(function (e) {
                    if (e.which === 13) {
                        button.click();
                        return false;
                    }
                    return true;
                });

                return false;
            });

            managebutton = $("button#serviceprofile-manage").button().click(function () {
                var dialog, msgArea, table, actionsBox, button, dialogButtons, isExecuting;

                dialog = $('<div class="hy-simple-input-dialog"></div>').appendTo($('body'));
                msgArea = $('<div></div>').appendTo(dialog);
                actionsBox = $('<div class="ui-wiget">' +
                    '  <div class="hy-serviceprofile-table-actions ui-widget-header ui-helper-clearfix">' +
                    '    <button id="serviceprofile-delete">Delete</button>' +
                    '    <button id="serviceprofile-certify">Share</button>' +
                    '  </div>' +
                    '</div>').appendTo(dialog);
                table = $('<div class="hy-serviceprofile-table" id="profiles-table"></div>').appendTo(dialog);

                msgArea.hymessage();

                if (!canCertify) {
                    $("button#serviceprofile-certify", actionsBox).hide();
                }

                function populateDialog() {
                    // Use an array so we can sortr
                    var arr = $.map(profiles, function (v, k) {
                        return v;
                    }).sort(compareProfiles);

                    $.each(arr, function (i, p) {
                        var entry, span;

                        if (canCertify || !p.certified) {
                            entry = $('<div class="hy-serviceprofile-item"></div>').appendTo(table);
                            entry.data("id", p.id);

                            $('<input type="checkbox" class="hy-serviceprofile-item-checkbox"></input>').click(function () {
                                return false;
                            }).appendTo(entry);
                            span = $('<span class="hy-serviceprofile-item-span">' + efEncodeHtml(p.name) + '</span>').appendTo(entry);

                            if (p.certified) {
                                entry.addClass("hy-serviceprofile-item-certified");
                                span.addClass("hy-serviceprofile-item-span-certified");
                            }

                            entry.hover(function () {
                                $(this).addClass("ui-state-hover");
                            }, function () {
                                $(this).removeClass("ui-state-hover");
                            }).mousedown(function () {
                                $(this).toggleClass("ui-state-highligh");
                                if ($(this).hasClass("ui-state-highligh")) {
                                    $("input:checkbox", this).prop("checked", true);
                                } else {
                                    $("input:checkbox", this).prop("checked", false);
                                }
                            });
                        }
                    });
                    $('input:checkbox:first', table).trigger("focus");
                }

                function getSelected() {
                    var ids = [];

                    $(".ui-state-highligh", table).each(function (index) {
                        if (canCertify || !$(this).hasClass("hy-serviceprofile-item-certified")) {
                            // Only admins can delete certified profiles
                            ids.push($(this).data("id"));
                        }
                    });

                    return ids;
                }

                $("button#serviceprofile-delete", actionsBox).button().click(function () {
                    var ids = getSelected();

                    if (ids.length <= 0) {
                        return false;
                    }

                    table.empty();

                    $.hydrogen.invokeService({
                        sdf: serviceprofileSDF,
                        uri: '//com.enginframe.serviceprofile/delete.profiles',
                        data: {
                            agentId: agentId,
                            serviceId: serviceId,
                            profileIds: ids.join('\n')
                        },
                        complete: function () {
                            loadProfiles(populateDialog);
                        },
                        messagebox: msgArea,
                        defaultErrorMessage: "Cannot delete the selected profiles."
                    });

                    return false;
                });

                $("button#serviceprofile-certify", actionsBox).button().click(function () {
                    var ids = getSelected();

                    if (ids.length <= 0) {
                        return false;
                    }

                    table.empty();

                    $.hydrogen.invokeService({
                        sdf: serviceprofileSDF,
                        uri: '//com.enginframe.serviceprofile/certify.profiles',
                        data: {
                            agentId: agentId,
                            serviceId: serviceId,
                            profileIds: ids.join('\n')
                        },
                        complete: function () {
                            loadProfiles(populateDialog);
                        },
                        messagebox: msgArea,
                        defaultErrorMessage: "Cannot share the selected profiles."
                    });

                    return false;
                });

                dialog.dialog({
                    title: "Manage Profiles",
                    resizable: false,
                    buttons: {
                        Close: function () {
                            $(this).dialog("close");
                        }
                    },
                    modal: true,
                    width: "500px",
                    beforeclose: function (event, ui) {
                        if (isExecuting) {
                            return false;
                        }
                    },
                    bgiframe: true
                });

                button = $('button:contains("Close")', dialog.parent('div.ui-dialog'));
                button.addClass('ui-priority-primary');

                populateDialog();
            });

            loadProfiles();
        }
    });

}(jQuery));

// ex:ts=4:sw=4:et:
