/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    $.widget('ui.hyspoolerbox', {

        options: {
            conf: {},
            speed: 'normal',
            spooler: null,
            initialVRoot: null,
            initialPath: null
        },

        _create: function () {
            var self;

            self = this;

            this.params = $.extend(true, {
                title: '&nbsp;',
                collapsible: true,
                collapsed: false,
                showFrame: true,
                targetPlugin: '',
                SDF: $.hydrogen.SDF,
                service: '//ui.hydrogen/show.spooler.data',
                serviceExtraData: '',
                updateMode: 'never' // 'once' or 'always' or 'explicit'
            }, this.options.conf.params || {
                // If no params is specified then suppose the user want to simply add a HTML fragment
                collapsible: false,
                showFrame: false
            });

            this.element.addClass('hy-spooler-box hy-box ui-widget');

            this.contentDiv = $('<div></div>').appendTo(this.element);

            this.loadDiv = $('<div class="hy-sessions-loading-wrapper">' +
                               '<div class="loading ui-state-default ui-state-active">Loading ...</div>' +
                             '</div>').prependTo(this.element).find('.loading');

            this.element.children().wrapAll('<div class="hy-spooler-box-content"></div>');
            if (this.params.showFrame || this.params.collapsible) {
                $(".hy-spooler-box-content", this.element).addClass('hy-box-content ui-widget-content');
            }

            if (this.params.showFrame || this.params.collapsible) {
                this.headerDiv = $('<div></div>').html(this.params.title).prependTo(this.element);
                this.headerDiv.addClass('hy-box-header ui-widget-header ui-state-default');
            }

            self.loaded = (this.params.updateMode === 'never');

            this.currentVRoot = this.options.initialVRoot;
            this.currentPath = this.options.initialPath;

            if (this.params.collapsible) {
                this.element.collapsibleBox({
                    initialState: (this.params.collapsed ? 'closed' : 'open'),
                    speed: this.options.speed,
                    callback: function (isOpen) {
                        if (isOpen && !self.loaded) {
                            self._load(self.currentVRoot, self.currentPath);
                        }
                    }
                });
            }

            if (!self.loaded) {
                this._load(this.currentVRoot, this.currentPath);
            }
        },

        _load: function (vroot, path) {
            this.currentVRoot = vroot;
            this.currentPath = path;
            if (this.contentDiv.is(':visible')) {
                var self = this;
                self.loadDiv.show();
                this.contentDiv.load(
                    this.params.SDF + '?_uri=' + this.params.service,
                    {
                        spooler: this.options.spooler,
                        vroot: vroot,
                        path: path,
                        targetPlugin: this.params.targetPlugin,
                        extra: this.params.serviceExtraData
                    },
                    function () {
                        self.loaded = true;
                        self.loadDiv.hide();
                    }
                );
            } else {
                this.loaded = (this.params.updateMode === 'never');
            }
        },

        destroy: function () {

            this.element.removeClass('hy-spooler-box hy-box ui-widget');

            this.headerDiv.remove();
            this.contentDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        refresh: function (vroot, path, explicit) {

            if (this.params.updateMode === 'always' ||
                    (explicit && this.params.updateMode === 'explicit')) {
                this._load(vroot, path);
            }

            return this;
        },

        collapsed: function (collapse) {
            if (collapse === undefined) {
                return this.element.hasClass('hy-collapsible-box-closed');
            }

            this._setOption('collapsed', collapse);
            return this;
        },

        _setOption: function (key, value) {
            switch (key) {
            case 'collapsed':
                if ((this.element.hasClass('hy-collapsible-box-closed') && !value) ||
                        (this.element.hasClass('hy-collapsible-box-open') && value)) {
                    // This is not very nice, but collapsible box
                    // is not a widget with proper methods
                    this.element.find('.hy-box-header').click();
                }
                break;
            }

            $.Widget.prototype._setOption.apply(this, arguments);
        }
    });

}(jQuery));

// ex:ts=4:et:
