/*global jQuery */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

(function ($) {

    function evaluateShowIfExpressionForSingleAction(expr) {
        var realExpr, code;

        realExpr = expr;
        code = "function _reqEval() {\n";
        code += "return (" + realExpr + ");\n";
        code += "}\n";
        code += "_reqEval();\n";

        try {
            return eval(code);
        } catch (e) {
            return false;
        }
    }

    $.widget('ui.hytable', {

        _sortname: '',
        _sortorder: 'asc',

        _params: null,

        options: {
            conf: {},
            xmlreader: {},
            loadDataOnInit: true,
            stickySelection: false, // If selection should persist across pagination
            noItemsLabel: "No records to view",  // If set to null no message is shown
            messageArea: null,
            defaultFilter: null,
            defaultLoadErrorMessage: "Cannot obtain the requested data from the server."
        },

        _create: function () {
            var multiselect, sortBy, dataurl, self, params;

            self = this;

            this.element.addClass('hy-table ui-widget');

            this.table = $('<table></table>').appendTo(this.element);
            this.pagerDiv = $('<div></div>').hide().appendTo(this.element);

            if (this.options.noItemsLabel) {
                this.noItemsDiv = $('<div class="hy-table-no-records ui-state-highlight">' +
                                    this.options.noItemsLabel + '</div>').hide().appendTo(this.element);
            }

            // just a dummy div we use to measure width, since
            // measuring width of the parent does not work on IE
            this.widthDiv = $('<div class="hy-table-widthsample"></div>').height(1).appendTo(this.element);

            // set sensible ids
            this.table.attr('id', this.element.attr('id') + '-hy-table');
            this.pagerDiv.attr('id', this.element.attr('id') + '-hy-table-pager');

            this._params = {
                multiselect: false,
                gridview: true,
                sortBy: "_natural:asc",
                SDF: "",
                serviceUri: "",
                serviceParams: {},
                rowNum: -1,
                rowList: [],
                height: 'auto',
                scroll: false,
                showPager: true,
                rowMenu: true,
                widgetId: "",
                actionsServiceUri: null,
                actionsServiceParams: {},
                actionsServiceSDF: $.hydrogen.SDF
            };

            $.extend(this._params, this.options.conf.params);

            multiselect = this._params.multiselect;
            if (this.options.stickySelection && multiselect) {
                // Keep our own array that persists across pagination
                this._selection = [];
            }
            this._lastSelected = null;

            // FIXME: manage cases where sortBy is malformed
            sortBy = this._params.sortBy.split(':', 2);
            this._sortname = sortBy[0];
            this._sortorder = sortBy[1];

            // if (this.options.defaultFilter && $.type(this.options.defaultFilter) === 'string') {
            if (this.options.defaultFilter && typeof(this.options.defaultFilter) === 'string') {
                $.extend(this._params.serviceParams, { filter: this.options.defaultFilter });
            }

            dataurl =  this._params.SDF + '?_uri=' + this._params.serviceUri;

            // define colmodel if necessary
            if (!this.options.conf.colmodel) {
                this.options.conf.colmodel = [];
            }

            // Add a fake column at the end of the column model
            this.options.conf.colmodel.push({
                name: '_natural',
                label: '&nbsp;',
                width: 20,
                fixed: true,
                sortable: false,
                resizable: false,
                ellipsize: false
            });

            // Turn ellipsize into ui-ellipsis class
            $.each(this.options.conf.colmodel, function (n, v) {
                if (typeof v.ellipsize !== 'boolean' || v.ellipsize) {
                    if (v.classes) {
                        v.classes += ' ui-ellipsis';
                    } else {
                        v.classes = 'ui-ellipsis';
                    }
                }
                delete v.ellipsize;
            });

            this._menu = null;
            this._selectedRow = null;

            this.table.jqGrid({

                // constant jqgrid options
                autoencode: true,
                datatype: this.options.loadDataOnInit ? 'xml' : 'local',
                autowidth: true,
                height: this._params.height,
                cellLayout: 4, // We set the borders to 0 in CSS
                pager: this.pagerDiv,
                mtype: 'POST',
                multiselect: multiselect,

                // whether to use incremental load
                scroll: this._params.scroll,

                // viewsortcols: [true, 'vertical', true],
                viewrecords: true,

                // type dependent jqgrid option
                xmlReader: this.options.xmlreader,

                // configuration options
                url: dataurl,
                postData: this._params.serviceParams,

                colModel: this.options.conf.colmodel,
                rowNum: this._params.rowNum,
                rowList: this._params.rowList,

                sortname: self._sortname,
                sortorder: self._sortorder,

                altRows: true,
                altclass: "hy-table-even-row",

                gridComplete: function () {
                    var lastTdClass, ids;

                    if (self.nRecords() === 0) {
                        if (self._params.showPager) {
                            self.pagerDiv.hide();
                        }
                        if (self.noItemsDiv && self.options.loadDataOnInit) {
                            self.noItemsDiv.show();
                        }
                    } else {
                        if (self.noItemsDiv) {
                            self.noItemsDiv.hide();
                        }
                        if (self._params.showPager) {
                            self.pagerDiv.show();
                        }
                        lastTdClass = 'last_td';
                        if (self._params.rowMenu) {
                            lastTdClass += ' hy-table-arrow-down';
                        }
                        $('tr.jqgrow>td:first-child', self.table).addClass('first_td');
                        $('tr.jqgrow>td:last-child', self.table).addClass(lastTdClass);
                    }

                    // restore selection if we are using sticky selection
                    if (self._selection !== undefined && self._selection.length > 0) {
                        ids = self.table.jqGrid('getDataIDs');
                        $.each(self._selection, function (i, v) {
                            if ($.inArray(v, ids) >= 0) {
                                self.table.jqGrid('setSelection', v, false);
                            }
                        });
                    } else {
                        self._lastSelected = null;
                    }

                    self._trigger('gridcomplete');

                    self._adaptWidth();
                },

                loadComplete: function (data) {
                    self.table.jqGrid('setGridParam', {
                        postData: {'refresh': ''}
                    });
                    if (self.options.messageArea) {
                        self.options.messageArea.hymessage('clear');
                    }
                    self._trigger('loadcomplete', null, {data: data});

                    // Note: we emit it here and not in grid complete, because when we restore the selection
                    // we do it in loadcomplete
                    self._trigger('selectionchanged');
                },

                loadError: function (xhr, status, error) {
                    var data = {xhr: xhr, status: status, error: error};
                    if (xhr.status !== 200 && self.options.messageArea) {
                        // If the status is ok (200) and we had an error, we assume
                        // we just got an empty response

                        jQuery.hydrogen.manageTableLoadErrorResult(data,
                            self.options.defaultLoadErrorMessage, self.options.messageArea);
                    }
                    self._trigger('loaderror', null, {data: data});
                },

                // I asked for a better method in
                // http://www.trirand.com/blog/?page_id=393/feature-request/cellattr-function-for-multiselect-checkboxes/
                afterInsertRow: !multiselect ? null : function (rowId, rowObject, e) {
                    if (rowObject.selectable !== undefined  && rowObject.selectable === 'false') {
                        $('#' + $.hydrogen.escapeSelector('jqg_' + self.table.attr('id') +
                            '_' + rowId)).prop("disabled", true);
                    }
                },

                /* beforeSelectRow: the false returning value permit the click manage by the bind function */
                beforeSelectRow: function (id, e) {
                    var row_top, row, row_width, rowObject, target, options, actionsServiceParams, currentSelectIndex,
                        initialSelectIndex, startID, endID, shouldSelectRow, inSelection, selection;

                    if (self._menu !== null) {
                        self._menu.destroy();
                        self._menu = null;
                    }

                    target = $(e.target);
                    row = target.parents('tr.jqgrow');

                    if (self._selectedRow !== null) {
                        self._selectedRow.removeClass('ui-state-ef-highlight');
                    }

                    row_top = -1;
                    row_width = e.currentTarget.clientWidth;

                    rowObject = self.table.jqGrid('getRowData', id);

                    options = {
                        minWidth: 150,
                        offsetLeft: row_width - 152,
                        offsetTop: -1 * row_top,
                        onClick: self._menuActivate,
                        divClass: "hy-table-menu",
                        // effect: "blind",
                        onClose: function () {
                            row.removeClass("ui-state-ef-highlight");
                            self._menu.destroy();
                        }
                    };  // 2px more cause margins

                    function addMenuItems(items) {
                        if (!self._menu) {
                            self._menu = new $.Menu(row, null, options);
                        }
                        $.each(items, function (i, item) {
                            if (!item.showIf || evaluateShowIfExpressionForSingleAction(item.showIf)) {
                                self._menu.addItem(new $.MenuItem({
                                    src: efEncodeHtml(item.name),
                                    icon: item.icon,
                                    addClass: item.classes,
                                    data: {
                                        menuid: item.id,
                                        table: self,
                                        rowid: id,
                                        action: item.action
                                    }
                                }, options));
                            }
                        });
                        if (self._menu.menuItems.length !== 0) {
                            self._menu.show();
                        }
                    }

                    if (!target.hasClass('cbox')) {

                        if (self.options.conf['single-action-items']) {
                            addMenuItems(self.options.conf['single-action-items']);
                        }

                        if (self._params.actionsServiceUri && self._params.actionsServiceUri.length > 0 &&
                                self._params.actionsServiceSDF && self._params.actionsServiceSDF.length > 0) {

                            if (self.lastRequest) {
                                self.lastRequest.abort();
                            }

                            actionsServiceParams = {
                                'rowId': id,
                                'widgetId': self._params.widgetId
                            };
                            $.extend(actionsServiceParams, self._params.actionsServiceParams);

                            // Expand special action params
                            $.each(actionsServiceParams, function (k, v) {
                                var newValue;
                                newValue = v.replace(/(^@\{col:)(.+)(\}$)/, function (match, p1, p2, p3, offset, string) {
                                    return rowObject[p2];
                                });
                                actionsServiceParams[k] = newValue.replace(/^@\{rowId\}$/, function () {
                                    return id;
                                });
                            });

                            // FIXME: do we really want to ignore error messages here?
                            self.lastRequest = $.enginframe.invokeService({
                                sdf: self._params.actionsServiceSDF,
                                uri: self._params.actionsServiceUri,
                                data: actionsServiceParams,
                                success: function (jsonObj) {
                                    addMenuItems(jsonObj);
                                },
                                dataType: 'json'
                            });

                            return false;
                        }
                    }

                    /* unselectable targets cannot be selected even with the check box */
                    if (rowObject.selectable !== undefined  && rowObject.selectable === 'false') {
                        return false;
                    }

                    /* in this if manage the click on the checkbox */
                    if (target.hasClass('cbox')) {
                        if (e.shiftKey && self._lastSelected !== null) {
                            /* Select a range */
                            currentSelectIndex = self.table.jqGrid('getInd', id);
                            initialSelectIndex = self.table.jqGrid('getInd', self._lastSelected);
                            startID = "";
                            endID = "";
                            if (currentSelectIndex > initialSelectIndex) {
                                startID = self._lastSelected;
                                endID = id;
                            } else {
                                startID = id;
                                endID = self._lastSelected;
                            }

                            shouldSelectRow = false;
                            selection = self.selected();

                            $.each(self.table.jqGrid('getDataIDs'), function (dummy, dataid) {
                                if (dataid === startID || shouldSelectRow) {
                                    shouldSelectRow = true;
                                    rowObject = self.table.jqGrid('getRowData', dataid);

                                    inSelection = $.inArray(dataid, selection) >= 0;

                                    /* unselectable targets cannot be selected even with the check box */
                                    if (!inSelection &&
                                            rowObject.selectable !== 'false' &&
                                            dataid !== startID &&
                                            dataid !== endID) {
                                        self.table.jqGrid('setSelection', dataid, false);
                                        if (self._selection) {
                                            self._selection.push(dataid);
                                        }
                                    }
                                }
                                return dataid !== endID;
                            });
                        }

                        if (target.attr('checked')) {
                            row.addClass('ui-state-highlight').attr('aria-selected', 'true');
                            self._lastSelected = id;
                        } else {
                            row.removeClass('ui-state-highlight').attr('aria-selected', 'false');
                            self._lastSelected = null;
                        }

                        return true;
                    }

                    if (target.is('a') || target.is('input') || target.hasClass('hy-table-active-element')) {
                        return true;
                    }

                    row.addClass('ui-state-ef-highlight').attr('aria-selected', 'true');
                    self._selectedRow = row;

		    var userAgent = navigator.userAgent.toLowerCase();
		    if (userAgent.indexOf("firefox") > -1 ) {
			// if ($.browser.name === "firefox") {
                        row_top = 1;
                    }



                    return self._menu === null ? true : false;
                },

                onSelectRow: function (id, status, e) {
                    if (self._selection) {
                        if (status && $.inArray(id, self._selection) < 0) {
                            self._selection.push(id);
                        } else if (!status && $.inArray(id, self._selection) >= 0) {
                            self._selection.splice($.inArray(id, self._selection), 1);
                        }
                    }

                    self._trigger('selectionchanged');
                },

                onSelectAll: function (rows, status) {
                    var unsel = [];

                    self._lastSelected = null;

                    // Hack to remove unselectable rows
                    if (status) {
                        $.each(rows, function (i, v) {
                            var rowObject = self.table.jqGrid('getRowData', v);
                            if (rowObject.selectable !== undefined  && rowObject.selectable === 'false') {
                                unsel.push(v);
                            } else if (self._selection && $.inArray(v, self._selection) < 0) {
                                self._selection.push(v);
                            }
                        });
                        $.each(unsel, function (i, v) {
                            var row = $('tr#' + v + '.jgrow');
                            self.table.jqGrid('setSelection', v, false);
                        });
                    } else if (self._selection) {
                        self._selection = $.grep(self._selection, function (v, i) {
                            return $.inArray(v, rows) >= 0;
                        }, true);
                    }

                    self._trigger('selectionchanged');
                },

                ondblClickRow: function (rowid, iRow, iCol, e) {
                    self._trigger('doubleclickrow', e, {
                        rowid: rowid,
                        irow: iRow,
                        icol: iCol
                    });
                }
            });

            this.widthDiv.bind('widthchange', function () {
                self._adaptWidth();
            });

            self._adaptWidth();
        },

        _adaptWidth: function () {
            if (this.table.is(':visible') && this.table.parents('.ui-helper-hidden-accessible').length === 0) {
                this.table.fluidGrid({example: this.widthDiv});
            }
        },

        setHeight: function (h) {
            return this.table.jqGrid('setGridHeight', h);
        },

        nRecords: function () {
            // It seems jqgrid's method returns a string...
            var r = this.table.jqGrid('getGridParam', 'records');
            return parseInt(r, 10);
        },

        destroy: function () {

            this.element.removeClass('hy-table ui-widget');

            this.widthDiv.remove();
            this.table.remove();
            this.pagerDiv.remove();

            $.Widget.prototype.destroy.apply(this, arguments);

            return this;
        },

        selected: function () {
            var selrow;
            if (this._selection) {
                return this._selection;
            }
            if (this.table.jqGrid('getGridParam', 'multiselect')) {
                return this.table.jqGrid('getGridParam', 'selarrrow');
            }
            selrow = this.table.jqGrid('getGridParam', 'selrow');
            return selrow === null ? [] : [selrow];
        },

        setSelection: function (sel) {
            var self, ids;

            self = this;
            ids = self.table.jqGrid('getDataIDs');

            this.table.jqGrid('resetSelection');
            if (sel && sel.length > 0) {
                $.each(sel, function (i, v) {
                    if ($.inArray(v, ids) >= 0) {
                        self.table.jqGrid('setSelection', v, false);
                    }
                });
            }
            if (self._selection) {
                self._selection = sel || [];
            }

            self._lastSelected = null;

            return this;
        },

        getRowData: function (rowid) {
            return this.table.jqGrid('getRowData', rowid);
        },

        setCell: function (rowid, col, data) {
            return this.table.jqGrid('setCell', rowid, col, data);
        },

        formattedCellValue: function (rowId, colId) {
            return this.table.jqGrid('getCell', rowId, colId);
        },

        reload: function (updateIds, refreshMode) {
            if (this.element.is(':visible')) {
                if (!this.options.loadDataOnInit) {
                    this.table.jqGrid('setGridParam', {datatype: 'xml'});
                    this.options.loadDataOnInit = true;
                }
                if (updateIds) {
                    this.table.jqGrid('setGridParam', {
                        postData: {'updateIds': updateIds}
                    });
                } else {
                    this.table.jqGrid('setGridParam', {
                        postData: {'updateIds': null}
                    });
                }
                if (refreshMode) {
                    this.table.jqGrid('setGridParam', {
                        postData: {'refresh': refreshMode}
                    });
                }
                this.table.trigger('reloadGrid');
            }
            return this;
        },

        // 'store' is an optional boolean parameter and it's true by default
        filter: function (newFilter, store) {
            var postData, savedFilter;

            postData = this.table.jqGrid('getGridParam', 'postData');
            savedFilter = postData.filter || '';

            if (newFilter === undefined) {
                return savedFilter;
            }

            this._setOption('filter', newFilter);

            if (store === false) {
                // Revert savedFilter, since newFilter was already stored by this._setOption
                this.table.jqGrid('setGridParam', {
                    postData: {'filter': savedFilter}
                });
            }

            return this;
        },

        setPostDataItem: function (key, value) {
            var d = {};
            d[key] = value;
            this.table.jqGrid('setGridParam', {
                postData: d
            });
        },

        setactionsServiceParams: function (params) {
            $.extend(this._params.actionsServiceParams, params);
        },

        _setOption: function (key, value) {
            switch (key) {
            case 'filter':
                this.table.jqGrid('setGridParam', {
                    postData: {'filter': value}
                });
                this.reload();
                this._trigger('filterchange', null, {formula: value});
                break;
            }

            $.Widget.prototype._setOption.apply(this, arguments);
        },

        _menuActivate: function (e, menuItem) {
            menuItem.data.table._trigger('action', null,
                                            {action: menuItem.data.action, currentId: menuItem.data.rowid});
        }
    });

}(jQuery));

// ex:ts=4:et:
