/*global jQuery, hydrogenConf, spoolerData */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var efShowSpooler = {
    refresh: function (id) {
        var fb, sj, vroot, path;

        // Refresh data and jobs
        // This assumes a bit about the internals, but otherwise
        // we would need to get more fancy
        fb = jQuery('.hy-spooler-data .hy-file-browser');
        fb.hyfilebrowser('reload');
        vroot = fb.hyfilebrowser('currentVRoot');
        path = fb.hyfilebrowser('currentPath');
        sj = jQuery('.hy-spooler-jobs .hy-table');
        if (sj.length !== 0) {
            sj.hytable('reload');
        }
        else {
            // Refresh the spooler status when spooler jobs table doesn't exist
            // (otherwise the refresh is performed by the spooler jobs table itself)
            jQuery('#' + id + '-spooler-bar').hyspoolerbar('refreshStatus');
        }

        // Call refresh on every other spooler box
        jQuery('.hy-spooler-box').hyspoolerbox('refresh', vroot, path, true);
    },

    // FIXME: verify the case when a spooler is not deleted
    remove: function (id, uri) {
        jQuery.hydrogen.invokeService({
            sdf: hydrogenConf[id].params.SDF,
            uri: hydrogenConf[id].params.deleteSpoolerServiceUri,
            data: {_selected: uri},
            success: function (xml) {
                location.search = "?_uri=" + "//com.enginframe.system/list.spoolers";
            },
            messagebox: jQuery(id + '-message')
        });
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, spoolerBar;

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: false
            });

	    spoolerData.name=decodeURIComponent(spoolerData.name); // we get an encoded name from DefaultSpoolerDetails.java
            spoolerBar = jQuery('#' + id + '-spooler-bar').hyspoolerbar({
                spoolerData: spoolerData,
                notificationArea: msg,
                conf: hydrogenConf[id]
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {},
                    function () {
                        efShowSpooler.refresh(id);
                    },
                    msg);
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, efShowSpooler.refresh);
        });
    }
};
// ex:ts=4:et:
