/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var efSpoolerBox = {
    init: function (id) {
        jQuery(document).ready(function () {
            var initialVRoot;

            if (hydrogenConf[id] && hydrogenConf[id].params.initialVRoot) {
                initialVRoot = hydrogenConf[id] && hydrogenConf[id].params.initialVRoot;
            } else {
                initialVRoot = hydrogenConf['ef-show-spooler'].params.spoolerVRoot;
            }

            if (initialVRoot === 'auto') {
                initialVRoot = hydrogenConf['ef-spooler-data'].vroots[0].id;
            }

            jQuery('#' + id).hyspoolerbox({
                conf: hydrogenConf[id],
                spooler: hydrogenConf['ef-show-spooler'].params.spoolerURI,
                initialVRoot: initialVRoot,
                initialPath: '/',
                updateMode: hydrogenConf['ef-show-spooler'].params.updateMode || 'never'
            });
        });
    }
};

// ex:ts=4:et:
