/*global jQuery, document, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var efSpoolerData = {
    refresh: function (id) {
        jQuery('#' + id + '-file-browser').hyfilebrowser('reload');
    },

    upload: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('uploadSingle');
    },

    downloadSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('downloadSelected');
    },

    getVrootType: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('getVrootType');
    },

    copyToLocal: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('copyToLocal');
    },

    createNewFolder: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('createNewFolder');
    },

    rename: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('rename', environment["%CURRENT_ID%"]);
    },

    compressSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('compressSelected');
    },

    deleteSelected: function (id) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('deleteSelected');
    },

    deleteItem: function (id, environment) {
        return jQuery('#' + id + '-file-browser').hyfilebrowser('deleteItem', environment["%CURRENT_ID%"]);
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var box, msg, fileBrowser, toolbar, isSearchEnabled;

            if (hydrogenConf[id].params.enableSearch === undefined) {
                isSearchEnabled = false;
            } else {
                isSearchEnabled = hydrogenConf[id].params.enableSearch;
            }

            box = jQuery('#' + id).collapsibleBox({
                cookieNamePrefix: 'spooler-data-box'
            });

            msg = jQuery('#' + id + '-message').hymessage();

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBox: isSearchEnabled
            });

            fileBrowser = jQuery('#' + id + '-file-browser').hyfilebrowser({
                conf: hydrogenConf[id],
                messageArea: msg
            });

            fileBrowser.bind('hyfilebrowserloadcomplete', function (e, data) {
                var hide;

                if (hydrogenConf[id].params.showSpoolerData === "always") {
                    hide = false;
                } else if (hydrogenConf[id].params.showSpoolerData === "never") {
                    hide = true;
                } else {
                    hide = (fileBrowser.hyfilebrowser('nVRoot') <= 1 &&
                            fileBrowser.hyfilebrowser('nFiles') === 0 &&
                            fileBrowser.hyfilebrowser('currentPath') === '/');
                }

                // Toggle hidden-accessible instead of show/hide
                // otherwise the table is not refreshed when hidden
                box.toggleClass('ui-helper-hidden-accessible', hide);
            });

            fileBrowser.bind('hytableloaderror', function (e, data) {
                box.toggleClass('ui-helper-hidden-accessible', (hydrogenConf[id].params.showSpoolerData === "never"));
            });

            fileBrowser.bind('hyfilebrowserdirectorychanged', function (e, data) {
                var sj;

                jQuery('.hy-spooler-jobs .hy-table').hytable('reload');

                sj = jQuery('.hy-spooler-jobs .hy-table');
                if (sj.length !== 0) {
                    sj.hytable('reload');
                } else {
                    // Refresh the spooler status when spooler jobs table doesn't exist
                    // (otherwise the refresh is performed by the spooler jobs table itself)
                    jQuery('.hy-spoolerbar').hyspoolerbar('refreshStatus');
                }

                // Call refresh on every other spooler box
                jQuery('.hy-spooler-box').hyspoolerbox('refresh', data.vroot, data.path, false);
            });

            fileBrowser.bind('hyfilebrowseraction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {
                        '%CURRENT_ID%': data.currentId,
                        '%CURRENT_DIR%': function () {
                            return fileBrowser.hyfilebrowser('currentPath');
                        },
                        '%CURRENT_VROOT%': function () {
                            return fileBrowser.hyfilebrowser('currentVRoot');
                        }
                    },
                    function () {
                        fileBrowser.hyfilebrowser('reload');
                    },
                    msg);
            });

            fileBrowser.bind('hyfilebrowserselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': fileBrowser.hyfilebrowser('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {
                        '%SELECTED_IDS%': function () {
                            return fileBrowser.hyfilebrowser('selected').join('\n');
                        },
                        '%CURRENT_DIR%': function () {
                            return fileBrowser.hyfilebrowser('currentPath');
                        },
                        '%CURRENT_VROOT%': function () {
                            return fileBrowser.hyfilebrowser('currentVRoot');
                        }
                    },
                    function () {
                        fileBrowser.hyfilebrowser('reload');
                    },
                    msg);
            });

            if (isSearchEnabled) {
                toolbar.bind('hytoolbarsearch', function (e, s) {
                    var formula;

                    if (s.search !== '') {
                        formula = "name *= '" + s.search + "'";
                    } else {
                        formula = "";
                    }

                    fileBrowser.hyfilebrowser('filter', formula);
                });
            }

        });
    }
};

// ex:ts=4:et:
