/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridClusterInfo = {
    refresh: function (id) {
        let _this = this
        let detailsDiv = jQuery('#' + id + '-cluster-details');
        let loadDiv = jQuery('#' + id + '-loaddiv').show();
        let msg = jQuery('#' + id + '-message');

        jQuery.hydrogen.invokeService({
            sdf: hydrogenConf[id].params.SDF,
            uri: hydrogenConf[id].params.serviceUri,
            data: hydrogenConf[id].params.serviceParams,
            complete: function () {
                loadDiv.hide();
            },
            success: function (html) {
                detailsDiv.html(html);
            },
            error: function () {
                // hide the cluster array list box too
                jQuery('#' + hydrogenConf[id].params.arrayClustersWidgetId).addClass('ui-helper-hidden-accessible');
                let err = msg.hymessage('alert') + '<div class="hy-message-action"><a href="#">Retry</a></div>';
                msg.hymessage('alert', err);
                jQuery('.hy-message-action a', msg).click(function () {
                    _this.refresh(id);
                });
            },
            dataType: 'html',
            messagebox: msg,
            defaultErrorMessage: 'Cannot obtain the cluster information from the server.'
        });
    },

    init: function (id) {
        let _this = this

        jQuery(document).ready(function () {
            let msg = jQuery('#' + id + '-message').hymessage();
            let clusterView = jQuery('#' + id + '-cluster-view');

            jQuery('<div id="' + id + '-loaddiv" class="loading ui-state-default ui-state-active">' +
                   '  Loading ...' +
                   '</div>').appendTo(clusterView);

            _this.refresh(id);

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, _this.refresh);
        });
    }
};

// ex:ts=4:et:

