/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridListTemplates = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    templateNameMaxlength: 23,
    clusterNameMaxlength: 50,

    init: function (id) {

        jQuery(document).ready(function () {
            let msg, toolbar, table, clusters, filters, queues, initialFilter;

            msg = hydrogenCommonUtils.message(id);

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search by configuration name'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'template-list',
                    row: 'template',
                    page: 'template-list>page',
                    total: 'template-list>total',
                    records: 'template-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of templates from the server.'
            });

            queues = jQuery('#' + id + '-queues').hyqueues({
                conf: hydrogenConf[id]
            });

            queues.bind('hyqueuesselect', function (e, filter) {
                toolbar.hytoolbar('search', '');
                table.hytable('filter', filter.formula);
            });

            table.bind('hytableloadcomplete', function (e, xhr) {
                queues.hyqueues('update');
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload', data.currentId);
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                var selectedIds;

                selectedIds = table.hytable('selected').join('\n');

                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': selectedIds},
                    function () {
                        table.hytable('reload', selectedIds);
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = table.hytable('filter');

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and configuration_name ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "configuration_name ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                table.hytable('filter', formula, false);
            });

            table.bind('hytablegridcomplete', function () {
                jQuery('td>span.hy-vtip').vtip();
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, function() { gridListTemplates.refresh(id) });
        });
    },

    redirectToClusterList: function () {
        window.location.href = '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml?_uri=//com.enginframe.grid/list.clusters.ext';
    },

    selectedIds: function (id) {
        return jQuery('#' + id + '-table').hytable('selected')
    },

    onResponse(id, xmlResponse) {
        let msg = hydrogenCommonUtils.message(id);
        msg.css('white-space', 'pre-wrap')
        let error = jQuery(xmlResponse).find('ef\\:error');
        if (error.size() === 1) {
            msg.hymessage('error', error)
            return false;
        } else {
            msg.hymessage('info', efEncodeHtml(jQuery(xmlResponse).find('ef\\:message, message').text()), 20000)
            return true;
        }
    },

    goRenameTemplate: function (id, templateId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListTemplates.renameTemplateDialog("Rename Cluster Configuration", "Rename", function (newName) {
            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/rename.template',
                data: {
                    template_id: templateId,
                    template_name: newName
                },
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) _this.refresh(id);
                },
                messagebox: msg
            });
        });
    },

    goDeleteTemplate: function (id, templateId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListTemplates.deleteTemplateDialog("Delete Cluster Configuration", "Delete", function () {
            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/delete.template',
                data: {
                    template_id: templateId
                },
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) _this.refresh(id);
                },
                messagebox: msg
            });
        });
    },

    goImportTemplate: function (id) {
        let _this = this
        let dialogTitle = "Register Cluster Configuration"
        let buttonLabel = "Register"

        gridListTemplates.importTemplateDialog(dialogTitle, buttonLabel, function (formId, dialog, msg) {
            let importButton = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
            let cancelButton = jQuery("button:contains('Cancel')", dialog.parent('div.ui-dialog'));
            let spinner = jQuery('#' + formId + '-submit-spinner');

            importButton.addClass('ui-state-disabled');
            cancelButton.addClass('ui-state-disabled');
            spinner.show();

            jQuery("#" + formId).ajaxSubmit({
                url: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml?_uri=//hpc.actions/import.template',
                type: 'POST',
                dataType: 'xml',
                success: function (xml, statusText, xhr) {
                    let error = jQuery(xml).find('ef\\:error');
                    if (error.size() === 1) {
                        _this._showClusterError(error, msg);
                        importButton.removeClass('ui-state-disabled');
                        cancelButton.removeClass('ui-state-disabled');
                        spinner.hide();
                    } else {
                        _this.onResponse(id, xml);
                        _this.refresh(id);
                        dialog.dialog("close");
                    }
                }
            });
        });
    },

    _showClusterError: function (error, box) {
        var message = error.find('ef\\:message, message').eq(0).text();
        // jQuery(null) is used to skip xml parsing and use the fallback message
        box.hymessage().hymessage('error', jQuery(null), "<div class=\"hy-error-primary-message\">" + efEncodeHtml(message) + "</div>")
    },

    goCreateCluster: function (id, templateId) {
        let _this = this
        let msg = hydrogenCommonUtils.message(id);
        gridListTemplates.createClusterDialog("Create Cluster", "Create", templateId, function (data) {
            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/create.cluster',
                data: data,
                success: function (xml, statusText, xhr) {
                    if (_this.onResponse(id, xml)) {
                        _this.redirectToClusterList()
                    }
                },
                messagebox: msg
            });
        });
    },

    goPCUpdateCluster: function (id, templateId) {
        let _this = this
        let buttonLabel = "Update"
        gridListTemplates.pcUpdateClusterDialog("Update Cluster", "Update", templateId, function (dialogId, dialog, msg, data) {
            let importButton = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
            let cancelButton = jQuery("button:contains('Cancel')", dialog.parent('div.ui-dialog'));
            let spinner = jQuery('#' + dialogId + '-submit-spinner');

            importButton.addClass('ui-state-disabled');
            cancelButton.addClass('ui-state-disabled');
            spinner.show();

            msg.hymessage() // hack to initialize msg

            jQuery.hydrogen.invokeService({
                sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
                uri: '//hpc.actions/update.cluster',
                data: data,
                success: function (xml, statusText, xhr) {
                    let error = jQuery(xml).find('ef\\:error');
                    if (error.size() === 1) {
                        _this._showClusterError(error, msg);
                        importButton.removeClass('ui-state-disabled');
                        cancelButton.removeClass('ui-state-disabled');
                        spinner.hide();
                    } else {
                        dialog.dialog("close");
                        if (_this.onResponse(id, xml)) {
                            _this.redirectToClusterList()
                        }
                    }
                },
                messagebox: msg
            });
        });
    },

    updateImportTemplateDialog: function() {
        // let templateType = jQuery("#hy-import-template-dialog select[name='template_type']").val();
        //
        // let regionEntry = hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'region');
        // let regionLabel = jQuery("#hy-import-template-dialog label[for='region']");
        //
        // if (templateType === 'ParallelCluster3') {
        //     regionLabel.show();
        //     regionEntry.show();
        //     regionEntry.val('');
        // } else {
        //     regionEntry.val('');
        //     regionLabel.hide();
        //     regionEntry.hide();
        // }

        let templateChoice = jQuery("#hy-import-template-dialog input[name='template_choice']:checked").val();

        let fileEntry = hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'template_file');
        let textEntry = hydrogenCommonUtils.dialogTagByName('hy-import-template-dialog', 'textarea', 'template_text');

        if (templateChoice === 'file') {
            fileEntry.show();
            textEntry.hide();
        } else {
            fileEntry.hide();
            textEntry.show();
        }
    },

    importTemplateDialog: function (dialogTitle, buttonLabel, actionfunc) {
        let formId = "import-template-form"
        let dialog = jQuery("#hy-import-template-dialog");

        if (dialog.length === 0) {
            let pcConfigLink = "<a href='https://docs.aws.amazon.com/parallelcluster/latest/ug/cluster-configuration-file-v3.html' target='_blank'>Learn More</a><i class='fa fa-external-link' aria-hidden='true' style='margin-left: 3px'></i>"

            dialog = jQuery('<div class="ef-manage-template-dialog hy-simple-input-dialog" id="hy-import-template-dialog"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);

            let form = jQuery('<form id="import-template-form"/>').appendTo(dialog);

            jQuery('<label for="template_name" style="display:block">Configuration Name:</label>').appendTo(form);
            jQuery('<input type="text" name="template_name" id="template_name" maxlength="'+ this.templateNameMaxlength +'" style="width: 99%"/>').appendTo(form);

            // DEMO TOGGLING: Mainline version
            // jQuery('<label for="account_id" style="display:block">Account Id:</label>').appendTo(form);
            // jQuery('<input type="text" name="account_id" id="account_id" maxlength="12" style="width: 110px"/>').appendTo(form);
            //
            // jQuery('<label for="bucket_name" style="display:block">Bucket Name:</label>').appendTo(form);
            // jQuery('<input type="text" name="bucket_name" id="bucket_name" maxlength="63" style="width: 99%"/>').appendTo(form);

            // jQuery('<label for="template_type" style="display:block">Type:</label>').appendTo(form);
            // let templateTypeSelect = jQuery('<select name="template_type" id="template_type" style="width: 99%; margin-top: 0; margin-left: 0; margin-bottom: 0.6em" onchange="gridListTemplates.updateImportTemplateDialog()"/>').appendTo(form);
            // jQuery('<option value="ParallelCluster2">ParallelCluster 2</option>').appendTo(templateTypeSelect);
            // jQuery('<option value="ParallelCluster3">ParallelCluster 3</option>').appendTo(templateTypeSelect);

            // jQuery('<label for="region" style="display:block">Region:</label>').appendTo(form);
            // jQuery('<input type="text" name="region" id="region" maxlength="63" style="width: 99%"/>').appendTo(form);

            jQuery('<label for="template_file">ParallelCluster configuration: '+pcConfigLink+'</label>').appendTo(form);
            let templateChoiceDiv = jQuery('<div class="row"/>').appendTo(form);
            jQuery('<input type="radio" id="is_template_file" name="template_choice" value="file" checked onchange="gridListTemplates.updateImportTemplateDialog()"/>').appendTo(templateChoiceDiv);
            jQuery('<label for="is_template_file">Upload file</label>').appendTo(templateChoiceDiv);
            jQuery('<input type="radio" id="is_template_text" name="template_choice" value="text" onchange="gridListTemplates.updateImportTemplateDialog()"/>').appendTo(templateChoiceDiv);
            jQuery('<label for="is_template_text">Paste text</label>').appendTo(templateChoiceDiv);

            jQuery('<input type="file" name="template_file" id="template_file" />').appendTo(form);
            jQuery('<textarea name="template_text" id="template_text" class="ef-manage-template-input-area" rows="10" style="width: 99%"/>').appendTo(form)
        }

        let msg = hydrogenCommonUtils.dialogMessage('hy-import-template-dialog').val('')
        let templateNameEntry = hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'template_name').val('');
        // let accountIdEntry = jQuery('#account_id').attr('type') === 'hidden' ?
        //     hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'account_id') :
        //     hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'account_id').val('');
        // let bucketNameEntry = jQuery('#bucket_name').attr('type') === 'hidden' ?
        //     hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'bucket_name') :
        //     hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'bucket_name').val('');
        // let regionEntry = hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'region').val('');
        let templateFileEntry = hydrogenCommonUtils.dialogInput('hy-import-template-dialog', 'template_file').val('');
        let templateTextEntry = hydrogenCommonUtils.dialogTagByName('hy-import-template-dialog', 'textarea', 'template_text').val('');

        jQuery("#hy-import-template-dialog input[name='template_choice'][value='file']").prop('checked', true)
        this.updateImportTemplateDialog()
        hydrogenCommonUtils.dialogClearWhenClosing('hy-import-template-dialog')

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };

        dialogButtons[buttonLabel] = function () {
            let templateName = templateNameEntry.val();
            // let accountId = accountIdEntry.val();
            // let bucketName = bucketNameEntry.val();
            // let region = regionEntry.val();
            let templateFile = templateFileEntry.val();
            let templateText = templateTextEntry.val();

            // Validation
            if (templateName.match("^\\s*$")) {
                msg.hymessage().hymessage('alert', "Configuration name cannot be empty");
                return false;
            }

            // if (accountId.length <= 0) {
            //     msg.hymessage().hymessage('alert', "AWS account id cannot be empty");
            //     return false;
            // }
            // if (!/^\d{12}$/.test(accountId)) {
            //     msg.hymessage().hymessage('alert', "AWS account id should contain exactly 12 digits");
            //     return false;
            // }
            //
            // if (bucketName.length <= 0) {
            //     msg.hymessage().hymessage('alert', "AWS S3 bucket name cannot be empty");
            //     return false;
            // }
            //
            // if (!/(?!^(\d{1,3}\.){3}\d{1,3}$)(^[a-z0-9]([a-z0-9-]*(\.[a-z0-9])?)*$(?<!\-))/.test(bucketName)) {
            //     msg.hymessage().hymessage('alert', "Invalid AWS S3 Bucket name (requirements <a href='https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html' target='_blank'>here</a>)");
            //     return false;
            // }

            // let templateType = jQuery("#hy-import-template-dialog input[name='template_type']:checked").val();
            // if (templateType === 'ParallelCluster3') {
            //     if (region.length <= 0) {
            //         msg.hymessage().hymessage('alert', "Region cannot be empty");
            //         return false;
            //     }
            // }

            let templateChoice = jQuery("#hy-import-template-dialog input[name='template_choice']:checked").val();
            if (templateChoice === 'file') {
                if (templateFile.match("^\\s*$")) {
                    msg.hymessage().hymessage('alert', "Configuration file cannot be empty");
                    return false;
                }
                templateTextEntry.val("")
            } else {
                if (templateText.match("^\\s*$")) {
                    msg.hymessage().hymessage('alert', "Configuration text cannot be empty");
                    return false;
                }
                templateFileEntry.val("")
            }

            actionfunc(formId, dialog, msg)
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
            width: "550px",
        });

        let importButton = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        importButton.addClass('ui-priority-primary');
        let cancelButton = jQuery("button:contains('Cancel')", dialog.parent('div.ui-dialog'));
        let spinnerId = formId + '-submit-spinner'
        let spinner = jQuery("<i>", {id: spinnerId, "class": "fa fa-spinner fa-spin", "style": "margin:10px"});
        spinner.hide();
        cancelButton.before(spinner);
    },

    renameTemplateDialog: function (dialogTitle, buttonLabel, actionfunc) {
        let dialog = jQuery("#hy-rename-template-dialog");
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-template-dialog hy-simple-input-dialog" id="hy-rename-template-dialog"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<label for="template_name" style="display:block">Configuration Name:</label>').appendTo(dialog);
            jQuery('<input type="text" name="template_name" id="template_name" maxlength="'+ this.templateNameMaxlength +'" style="width: 99%"/>').appendTo(dialog);
        }

        let msg = hydrogenCommonUtils.dialogMessage('hy-rename-template-dialog').val('')
        let templateNameEntry = hydrogenCommonUtils.dialogInput('hy-rename-template-dialog', 'template_name').val('');
        hydrogenCommonUtils.dialogClearWhenClosing('hy-rename-template-dialog')

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            let templateName = templateNameEntry.val();

            // Validation
            if (templateName.match("^\\s*$")) {
                msg.hymessage().hymessage('alert', "Configuration name cannot be empty");
                return false;
            }

            jQuery(this).dialog("close");

            actionfunc(templateName);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },

    deleteTemplateDialog: function (dialogTitle, buttonLabel, actionfunc) {
        let dialog = jQuery("#hy-delete-template-dialog");
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-template-dialog hy-simple-input-dialog" id="hy-delete-template-dialog"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<label for="template_name" style="display:block">Do you really want to delete the selected configuration?</label>').appendTo(dialog);
        }

        let msg = hydrogenCommonUtils.dialogMessage('hy-delete-template-dialog').val('')
        hydrogenCommonUtils.dialogClearWhenClosing('hy-delete-template-dialog')

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            jQuery(this).dialog("close");
            actionfunc();
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },

    pcUpdateClusterDialog: function (dialogTitle, buttonLabel, templateId, actionfunc) {
        let _this = this
        let dialogId = "hy-update-cluster-dialog"
        let dialog = jQuery("#" + dialogId);
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-template-dialog hy-simple-input-dialog" id="'+dialogId+'"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<div style="display: flex"><label for="update_cluster_id" style="display:block">Cluster Name:</label><select name="update_cluster_id" id="update_cluster_id"/></div>').appendTo(dialog);
        }

        jQuery.hydrogen.invokeService({
            sdf: '/' + jQuery.enginframe.rootContext + '/applications/applications.admin.xml',
            uri: '//hpc.actions/clusters.list',
            success: function (xml, statusText, xhr) {
                if (_this.onResponse(dialogId, xml)) {
                    let clusters = jQuery("#update_cluster_id");
                    jQuery(clusters).empty();
                    jQuery(xml).find('grid\\:cluster').each(function(index) {
                        let status = jQuery(this).attr("status")
                        if (["READY", "STOPPED"].includes(status)) {
                            let id = jQuery(this).attr("id")
                            let name = jQuery(this).attr("name")
                            jQuery(clusters).append($("<option></option>")
                                .attr("value", id).text(name));
                        }
                    });
                }
            },
        });

        let msg = hydrogenCommonUtils.dialogMessage(dialogId).val('')
        hydrogenCommonUtils.dialogClearWhenClosing(dialogId)
        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };

        dialogButtons[buttonLabel] = function () {
            let clusterId = jQuery("#update_cluster_id").val();

            let data = {
                template_id: templateId,
                cluster_name: clusterId
            }

            actionfunc(dialogId, dialog, msg, data);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
            width: "550px",
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');

        let cancelButton = jQuery("button:contains('Cancel')", dialog.parent('div.ui-dialog'));
        let spinnerId = dialogId + '-submit-spinner'
        let spinner = jQuery("<i>", {id: spinnerId, "class": "fa fa-spinner fa-spin", "style": "margin:10px"});
        spinner.hide();
        cancelButton.before(spinner);
    },

    createClusterDialog: function (dialogTitle, buttonLabel, templateId, actionfunc) {
        let dialogId = "hy-create-cluster-dialog"

        let dialog = jQuery("#" + dialogId);
        if (dialog.length === 0) {
            dialog = jQuery('<div class="hy-manage-template-dialog hy-simple-input-dialog" id="'+dialogId+'"/>').appendTo(jQuery('body'));
            jQuery('<div class="dialog-message" style="display:none;" />').appendTo(dialog);
            jQuery('<label for="cluster_name" style="display:block">Cluster Name:</label>').appendTo(dialog);
            jQuery('<input type="text" name="cluster_name" id="cluster_name" maxlength="'+ this.clusterNameMaxlength +'" style="width: 99%"/>').appendTo(dialog);
            gridUserModes.addToDialog(dialog)
        }

        let _this = this
        let msg = hydrogenCommonUtils.dialogMessage(dialogId).val('')
        let clusterNameEntry = hydrogenCommonUtils.dialogInput(dialogId, 'cluster_name').val('');
        gridUserModes.prepareDialog(dialogId);
        hydrogenCommonUtils.dialogClearWhenClosing(dialogId)

        let dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };

        dialogButtons[buttonLabel] = function () {
            let clusterName = clusterNameEntry.val();

            // Validation
            if (clusterName.match("^\\s*$")) {
                msg.hymessage().hymessage('alert', "Cluster name cannot be empty");
                return false;
            }

            if (!gridUserModes.validate(dialogId)) return false;

            jQuery(this).dialog("close");

            let data = {
                template_id: templateId,
                cluster_name: clusterName,
                user_mode: gridUserModes.selectedUserModeJson(dialogId)
            }

            actionfunc(data);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true,
            width: "550px",
        });

        let button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
    },

};

// ex:ts=4:et:
