/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var gridSpoolerJobs = {
    refresh: function (id) {
        jQuery('#' + id + '-table').hytable('reload');
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var box, msg, toolbar, table, searchBoxHint;

            if (hydrogenConf[id].params.title && hydrogenConf[id].params.title !== '') {
                jQuery('#' + id + '-title').html(hydrogenConf[id].params.title);
            }

            box = jQuery('#' + id).collapsibleBox({
                cookieNamePrefix: 'spooler-jobs-box'
            });

            msg = jQuery('#' + id + '-message').hymessage();

            searchBoxHint = 'Search in all columns';
            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: searchBoxHint,
                searchBoxTooltip: 'Dates can be searched using YYYY/MM/DD notation or part of it, e.g. YYYY/MM, MM/DD, MM/'
            });

            hydrogenConf[id].colmodel.push({
                hidden: true,
                name: 'selectable',
                xmlmap: function (row) {
                    if (jQuery(row).attr('id').startsWith("app://")) {
                        return 'false';
                    }
                    return 'true';
                }
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'job-list',
                    row: 'job',
                    page: 'job-list>page',
                    total: 'job-list>total',
                    records: 'job-list>records',
                    repeatitems: false,
                    id: 'id'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultLoadErrorMessage: 'Cannot obtain the list of jobs from the server.'
            });

            table.bind('hytablegridcomplete', function (e, data) {
                jQuery('td>span.hy-vtip').vtip();

                box.toggleClass('ui-helper-hidden-accessible',
                    (table.hytable('nRecords') === 0 && toolbar.hytoolbar('search') === searchBoxHint));
                jQuery('.hy-spoolerbar').hyspoolerbar('refreshStatus');
            });

            table.bind('hytableloaderror', function (e, data) {
                box.toggleClass('ui-helper-hidden-accessible', true);
            });

            table.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {
                        '%SELECTED_IDS%': function () {
                            return table.hytable('selected').join('\n');
                        }
                    },
                    function () {
                        table.hytable('reload');
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula, params, date;

                if (s.search !== '') {
                    params = [
                        { key: "id", value: s.search, comparator: "?:=" },
                        { key: "ef-status", value: s.search, comparator: "?:=" },
                        { key: "queue", value: s.search, comparator: "?:=" },
                        { key: "execution-host", value: s.search, comparator: "?:=" },
                        { key: "name", value: s.search, comparator: "?:=" }
                    ];
                    if (s.search.match(/^\d*\/\d*\/?\d*$/)) {
                        date = ".*" + s.search.replaceAll("/", "-") + ".*";
                        params.push({ key: "submission-time", value: date, comparator: "~=" });
                    }

                    formula = jQuery.hydrogen.composeFilter(params, "or");
                } else {
                    formula = "";
                }

                table.hytable('filter', formula);
            });
        });
    }
};

// ex:ts=4:et:
