var gridUserModes = {
    onSelect: function() {
        let user_mode = jQuery("#user_mode").val()
        jQuery(".user_mode_options").each(function () {
            let selected = this.id === "user_mode_" + user_mode + "_options"
            jQuery(this).css("display", selected ? "block" : "none")
        })
    },

    addToDialog: function(dialog) {
        jQuery('<label for="user_mode" style="display:block">User Mode:</label>').appendTo(dialog);
        let user_mode = jQuery('<select style="width:100%" name="user_mode" id="user_mode" onchange="gridUserModes.onSelect()"/>')
            .css("width", "99%")
            .css("margin-left", "0")
            .appendTo(dialog);

        // Available User Modes
        jQuery(user_mode).append(jQuery("<option></option>").attr("value", 'none').text("Select user mode..."))
        jQuery(user_mode).append(jQuery("<option></option>").attr("value", "single_user").text("Single User"))
        jQuery(user_mode).append(jQuery("<option></option>").attr("value", "multi_user_1_1").text("Multi User 1:1"))

        // Options for each user mode
        // none
        jQuery('<div style="display: none" id="user_mode_none_options" class="user_mode_options"/>').appendTo(dialog)

        // single_user
        let user_mode_single_user_options = jQuery('<div style="display: none" id="user_mode_single_user_options" class="user_mode_options"/>').appendTo(dialog)
        jQuery('<label for="user_name" style="display:block">User:</label>').appendTo(user_mode_single_user_options);
        jQuery('<input type="text" name="user" value="ec2-user" class="user_mode_option" style="width: 99%"/>').appendTo(user_mode_single_user_options);

        // multi_user
        jQuery('<div style="display: none" id="user_mode_multi_user_1_1_options" class="user_mode_options"/>').appendTo(dialog)

    },

    userModeEntry: function (dialogId) {
        return hydrogenCommonUtils.dialogTagByName(dialogId, 'select', 'user_mode');
    },

    prepareDialog: function (dialogId) {
        this.userModeEntry(dialogId).val('none');
        this.onSelect();
    },

    validate: function(dialogId) {
        let msg = hydrogenCommonUtils.dialogMessage(dialogId)
        let userMode = this.userModeEntry(dialogId).val();

        if (userMode === "none") {
            msg.hymessage().hymessage('alert', "Please select a User Mode");
            return false;
        }

        let userModeValidation = this.userModeValidations[userMode];
        if (userModeValidation) return userModeValidation(msg);

        return true;
    },

    userModeOptions: function(userMode) {
        let userModeOptions = {}
        jQuery("#user_mode_" + userMode + "_options > .user_mode_option").each(function () {
            userModeOptions[this.name] = jQuery(this).val()
        })
        return userModeOptions
    },

    userModeTypes: {
        "single_user": "com.enginframe.plugin.hpc.common.remoteuser.SingleUserAsRemoteUserMapper",
        "multi_user_1_1": "com.enginframe.plugin.hpc.common.remoteuser.LocalUserAsRemoteUserMapper",
    },

    userModeValidations: {
        "single_user": function(msg) {
            let options = gridUserModes.userModeOptions("single_user")
            let user = options["user"]

            if (!user || user.match("^\\s*$")) {
                msg.hymessage().hymessage('alert', "User cannot be empty");
                return false;
            }

            return true;
        }
    },

    selectedUserModeJson: function(dialogId) {
        let userMode = this.userModeEntry(dialogId).val();

        return JSON.stringify({
            type: this.userModeTypes[userMode],
            config: JSON.stringify(this.userModeOptions(userMode))
        });
    }
}
