/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */

var interactiveDcv2Settings = {

    init: function (id) {

        jQuery(document).ready(function () {
            var title, msg, geometryEl, windowManagerEl, viewerTypeEl, passwordEl;

            // Remove from HTML unused components or show them if they are needed
            if (hydrogenConf[id].params.canSelectGeometry !== "true") {
                jQuery('#' + id + '-fieldset-geometry').closest("tr").remove();
            } else {
                jQuery('#' + id + '-fieldset-geometry').closest("tr").removeClass("ui-helper-hidden");
            }

            if (hydrogenConf[id].params.canSelectViewerType !== "true") {
                jQuery('#' + id + '-fieldset-viewerType').closest("tr").remove();
            } else {
                jQuery('#' + id + '-fieldset-viewerType').closest("tr").removeClass("ui-helper-hidden");
            }

            if (hydrogenConf[id].params.canSelectWindowManager !== "true") {
                jQuery('#' + id + '-fieldset-windowManager').closest("tr").remove();
            } else {
                jQuery('#' + id + '-fieldset-windowManager').closest("tr").removeClass("ui-helper-hidden");
            }

            if (hydrogenConf[id].params.canSetPasswd !== "true") {
                jQuery('#' + id + '-fieldset-password').closest("tr").remove();
            } else {
                jQuery('#' + id + '-fieldset-password').closest("tr").removeClass("ui-helper-hidden");
                passwordEl = jQuery('input[name="' + id + '-password"]');
                if (hydrogenConf[id].params.passwd) {
                    passwordEl.val(hydrogenConf[id].params.passwd);
                }
            }

            title = hydrogenConf[id].params.title || "Settings";
            jQuery('#' + id + '-title').html(title);

            msg = jQuery('#' + id + '-message').hymessage();

            geometryEl = jQuery('input[name="' + id + '-geometry"]').val(hydrogenConf[id].params.defaultGeometry).interactiveResolution('dcv2');

            windowManagerEl = jQuery('select[name="' + id + '-windowManager"]');

            jQuery('<option value="auto">default</option>').appendTo(windowManagerEl);
            jQuery.each(hydrogenConf[id].params.windowManagerList, function (i, v) {
                var option = jQuery('<option value="' + efEncodeHtml(v.id) + '">' + efEncodeHtml(v.label) + '</option>').appendTo(windowManagerEl);
                if (v.id === hydrogenConf[id].params.defaultWindowManager) {
                    option.prop('selected', true);
                }
            });

            viewerTypeEl = jQuery('input[name="' + id + '-viewerType"]');
            viewerTypeEl.filter('[value="' + hydrogenConf[id].params.defaultViewerType + '"]').attr('checked', true);

            jQuery('input[name="' + id + '-cancel"]').click(function () {
                var loc = window.location.protocol + '//' + window.location.host +
                    window.location.pathname + window.location.search;
                window.location = hydrogenConf[id].params.onCancelRedirectTo || loc;
            });
            jQuery('input[name="' + id + '-save"]').click(function () {
                var serviceData;

                serviceData = {remote: "dcv2"};

                if (hydrogenConf[id].params.canSelectGeometry === "true") {
                    serviceData.remote_dcv2_geometry = geometryEl.val();
                }
                if (hydrogenConf[id].params.canSelectWindowManager === "true") {
                    serviceData.remote_dcv2_windowManager = jQuery("option:selected", windowManagerEl).val();
                }
                if (hydrogenConf[id].params.canSelectViewerType === "true") {
                    serviceData.remote_dcv2_viewerType = viewerTypeEl.filter(':checked').val();
                }
                if (hydrogenConf[id].params.canSetPasswd === "true") {
                    serviceData.remote_dcv2_passwd = passwordEl.val();
                }

                jQuery.hydrogen.invokeService({
                    sdf: hydrogenConf[id].params.SDF,
                    uri: hydrogenConf[id].params.saveSettingsServiceUri,
                    data: serviceData,
                    success: function (xml) {
                        msg.hymessage('info', "DCV2 settings have been successfully saved.", 0);
                        setTimeout(function () {
                            var loc = window.location.protocol + '//' + window.location.host +
                                window.location.pathname + window.location.search;
                            window.location = hydrogenConf[id].params.onSaveRedirectTo || loc;
                        }, 1000);
                    },
                    dataType: 'xml',
                    messagebox: msg,
                    defaultErrorMessage: 'Cannot save DCV2 settings.'
                });
            });
        });
    }
};

// ex:ts=4:et:
