/*global jQuery, hydrogenConf */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */


var interactiveListSessions = {

    sessionNameFormatter: function (cellvalue, options, rowObject) {
        var encCellValue, status, html, title, warning, warning_class, owner, isShareable, remote, encRemote;

        encCellValue = efEncodeHtml(decodeURIComponent(cellvalue));
        status = jQuery(rowObject).children('status').text();
        warning = jQuery(rowObject).children('warning').text();
        isShareable = jQuery('isShareable', rowObject).text();
        owner = jQuery('owner', rowObject).text();
        remote = jQuery('remote', rowObject).text();
        encRemote = efEncodeHtml(remote);

        if (warning) {
            warning_class = 'hy-connect-session-warning';
        } else {
            warning_class = 'ui-helper-hidden';
        }

        if ('Running' === status) {
            if (isShareable !== "false" || owner === jQuery.enginframe.user.name) {
                title = warning ? efEncodeHtml(warning) : 'Connect to session ' + encCellValue;
                html = '<span class="hy-connect-session-name hy-connect-session-link" title="' + title + '">' + encCellValue +
                         '<div class="ui-helper-hidden hy-connect-session-param-uri">' + efEncodeHtml(options.rowId) + '</div>' +
                         '<div class="ui-helper-hidden hy-connect-session-param-name">' + encCellValue + '</div>' +
                         '<div class="ui-helper-hidden hy-connect-session-param-remote">' + encRemote + '</div>' +
                         '<div class="' + warning_class + '"/>' +
                       '</span>';
            }
            else {
                title = warning ? efEncodeHtml(warning) : 'Session ' + encCellValue;
                html = '<span class="hy-connect-session-name" title="' + title + '">' + encCellValue +
                         '<div class="' + warning_class + '"/>' +
                       '</span>';
            }
        } else {
            title = warning ? efEncodeHtml(warning) : 'Session ' + encCellValue + ' is not running';
            html = '<span class="hy-connect-session-name" title="' + title + '">' + encCellValue +
                     '<div class="' + warning_class + '"/>' +
                   '</span>';
        }

        return html;
    },

    sessionNameUnformatter: function (cellvalue, options, cell) {
        var sessionName = jQuery('.hy-connect-session-param-name', cell).text();
        return sessionName ? sessionName : jQuery('.hy-connect-session-name', cell).text();
    },

    sessionStatusFormatter: function (cellvalue, options, rowObject) {
        var classes;

        classes = "hy-session-status hy-session-status-" + efEncodeHtml(cellvalue.toLowerCase());

        return '<span class="' + classes + '">' + efEncodeHtml(cellvalue) + '</span>';
    },

    executionHostFormatter: function (cellvalue, options, rowObject) {
        var value, href;

        if ($(rowObject).children('type').text().toLowerCase() !== 'delegate') {
            href = document.location.pathname + "?_uri=//com.enginframe.grid/host.info" +
                "&host=" + encodeURIComponent(cellvalue) +
                "&grid=" + encodeURIComponent($(rowObject).children("job-manager").text()) +
                "&cluster=" + encodeURIComponent($(rowObject).children("cluster").text());
            value = "<a href=\"" + href + "\">" + efEncodeHtml(decodeURIComponent(cellvalue)) + "</a>";
        }
        else {
            value = efEncodeHtml(cellvalue);
        }

        return value;
    },

    sessionShareFormatter: function (cellvalue, options, rowObject) {
        var owner, isShareable, isAdmin, guests, users, viewers, n, sessionUri, text, tip, helperClasses, helperDivs;

        isShareable = jQuery('isShareable', rowObject).text();
        owner = jQuery('owner', rowObject).text();
        isAdmin = (options.colModel.formatoptions !== undefined) &&
                  (options.colModel.formatoptions.isAdmin !== undefined);

        if (owner === jQuery.enginframe.user.name || isAdmin) {
            guests = jQuery('guests', rowObject);
            users = jQuery.map(jQuery('user', guests), function (v, i) {
                return jQuery(v).text();
            });
            viewers = jQuery.map(jQuery('viewer', guests), function (v, i) {
                return jQuery(v).text();
            });
            n = users.length + viewers.length;

            sessionUri = options.rowId;

            if (n === 0) {
                text = 'Not shared';
            } else if (n === 1 && users.length > 0) {
                text = 'Shared with ' + efEncodeHtml(users[0]);
            } else if (n === 1 && viewers.length > 0) {
                text = 'Shared with ' + efEncodeHtml(viewers[0]);
            } else {
                text = 'Shared with ' + n + ' people';
                tip = '<p>';
                if (users.length > 0) {
                    tip += '<strong>Collaborators: </strong>' + efEncodeHtml(users.join(', ')) + '<br />';
                }
                if (viewers.length > 0) {
                    tip += '<strong>Viewers: </strong>' + efEncodeHtml(viewers.join(', '));
                }
                tip += '</p>';
            }
        } else {
            text = 'Shared by ' + efEncodeHtml(owner);
        }

        helperClasses = '';
        helperDivs = '';
        if (tip !== undefined && isShareable !== 'false') {
            helperClasses += "hy-vtip";
            helperDivs += '<div class="ui-helper-hidden hy-vtip-content">' + tip + '</div>';
        }

        if (sessionUri !== undefined && isShareable !== 'false') {
            helperClasses += " hy-share-session-link";
            helperDivs += '<div class="ui-helper-hidden hy-share-session-param-uri">' + efEncodeHtml(sessionUri) + '</div>';
        }

        // Force title to text or jqgrid will include the content of the helper divs
        return '<span title="' + text + '" class="' + helperClasses + '">' + helperDivs + text + '</span>';
    },

    refresh: function (id) {
        var updateMode;

        // a bit of a hack since they are not strictly part of the widget, but clear also submission errors
        jQuery('.interactive-submit-error').remove();

        updateMode = hydrogenConf[id].params.forceUpdateOnManualRefresh === "true" ? "manual" : "";
        jQuery('#' + id + '-list-view').hytable('reload', null, updateMode);
        if (this._params.showCompactView) {
            jQuery('#' + id + '-compact-view').hysessions('reload', null, updateMode);
        }
    },

    connect: function (id, data) {
        jQuery('#' + id + '-connectionbar').hyconnectionbar('start', data);
    },

    renameDialog: function (id, environment) {
        var msg = jQuery('#' + id + '-message').hymessage();
        jQuery.hydrogen.renameSessionDialog(environment["%CURRENT_ID%"], msg, function () {
            interactiveListSessions.refresh(id);
        });
    },

    shareDialog: function (id, sessionUri, sessionProps) {
        var dialog;

        jQuery('<div class="hy-action-dialog"/>').hysessionsharedialog({
            conf: hydrogenConf[id],
            sessionUri: sessionUri,
            supportViewOnly: sessionProps.supportViewOnly,
            onSave: function () {
                interactiveListSessions.refresh(id);
            }
        });
    },

    init: function (id) {
        var self;

        self = this;

        this._params = {
            showCompactView: true
        };

        jQuery.extend(this._params, hydrogenConf[id].params);

        function createListView(msg, initialFilter, initialQuery) {
            var listView;

            listView = jQuery('#' + id + '-list-view').hytable({
                xmlreader: {
                    root: 'list-spoolers',
                    row: 'spooler',
                    page: 'list-spoolers>page',
                    total: 'list-spoolers>total',
                    records: 'list-spoolers>records',
                    repeatitems: false,
                    id: '[uri]'
                },
                conf: hydrogenConf[id],
                loadDataOnInit: false,
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the list of sessions from the server.'
            }).hide();
            listView.hytable('setPostDataItem', 'query', initialQuery);

            return listView;
        }

        function createCompactView(msg, initialFilter, initialQuery) {
            var compactView;

            compactView = jQuery('#' + id + '-compact-view').hysessions({
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultFilter: initialFilter,
                defaultLoadErrorMessage: 'Cannot obtain the list of sessions from the server.'
            }).hide();
            compactView.hysessions('query', initialQuery);

            return compactView;
        }

        jQuery(document).ready(function () {
            var msg, views, connectionBar, toolbar, listView, compactView, filters, initialFilter, initialQuery;

            msg = jQuery('#' + id + '-message').hymessage();

            if (self._params.showCompactView) {
                views = [
                    {id: 'compact', icon: 'grid'},
                    {id: 'list', icon: 'list'}
                ];
            } else {
                views = [];
            }

            connectionBar = jQuery('#' + id + '-connectionbar').hyconnectionbar({
                conf: hydrogenConf[id],
                messageArea: msg
            });

            connectionBar.bind('hyconnectionbarupdated', function (e, data) {
                var rowData;
                if (compactView === undefined || toolbar.hytoolbar('activeView').id === 'list') {
                    listView.hytable('setCell', data.sessionUri, 'status', data.status);
                    rowData = listView.hytable('getRowData', data.sessionUri);
                    if (rowData.name && data.status === 'Running') {
                        jQuery('tr#' + jQuery.hydrogen.escapeSelector(data.sessionUri) + '>td>span.hy-connect-session-name').wrap('<a href="#"/>').click(function (event) {
                            event.stopPropagation();
                            self.connect(id, {
                                sessionUri: data.sessionUri,
                                sessionRemote: data.sessionRemote,
                                sessionName: rowData.name,
                                initialStatus: 'Running',
                                allowStarting: false
                            });
                        });
                    }
                } else {
                    compactView.hysessions('updateSession', data.sessionUri, data.status, data.sessionRemote);
                }
            });

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                views: views,
                searchBoxHint: 'Search by session name'
            });

            filters = jQuery('#' + id + '-filters').hyfilters({
                conf: hydrogenConf[id]
            });

            // The initialFilter contains just the "formula" for backward compatibility
            initialFilter = filters.hyfilters('selected');
            initialQuery = filters.hyfilters('selectedDataSourceQuery');
            listView = createListView(msg, initialFilter, initialQuery);
            if (self._params.showCompactView) {
                compactView = createCompactView(msg, initialFilter, initialQuery);
            }

            if (compactView === undefined || toolbar.hytoolbar('activeView').id === 'list') {
                listView.show();
                listView.hytable('reload');
            } else {
                compactView.show();
                compactView.hysessions('reload');
            }

            filters.bind('hyfiltersselect', function (e, filter) {
                toolbar.hytoolbar('search', '');
                listView.hytable('setPostDataItem', 'query', filter.dataSourceQuery);
                listView.hytable('filter', filter.formula);
                if (compactView !== undefined) {
                    compactView.hysessions('query', filter.dataSourceQuery);
                    compactView.hysessions('filter', filter.formula);
                    compactView.hysessions('reload');
                }
            });

            if (compactView !== undefined) {
                toolbar.bind('hytoolbarviewchanged', function (e, view) {
                    if (view.id === 'list') {
                        compactView.hide();
                        listView.show();
                        listView.hytable('reload');
                    } else {
                        listView.hide();
                        compactView.show();
                        compactView.hysessions('reload');
                    }
                });
            }

            listView.bind('hytablegridcomplete', function () {
                jQuery('td>div.hy-star').toggleStar();
                jQuery('td>span.hy-vtip').vtip();
                jQuery('td>span.hy-connect-session-link').wrap('<a href="#"/>').click(function (event) {
                    var sessionUri, sessionName, sessionRemote;
                    event.stopPropagation();
                    sessionUri = jQuery(this).find('.hy-connect-session-param-uri').text();
                    sessionName = jQuery(this).find('.hy-connect-session-param-name').text();
                    sessionRemote = jQuery(this).find('.hy-connect-session-param-remote').text();
                    self.connect(id, {
                        sessionUri: sessionUri,
                        sessionName: sessionName,
                        sessionRemote: sessionRemote,
                        initialStatus: 'Running',
                        allowStarting: false
                    });
                });
                jQuery('td>span.hy-share-session-link').wrap('<a href="#"/>').click(function (event) {
                    var sessionUri;
                    event.preventDefault();
                    sessionUri = jQuery(this).find('.hy-share-session-param-uri').text();

                    jQuery.hydrogen.invokeService({
                        sdf: "/" + jQuery.enginframe.rootContext + "/hydrogen/ui.hydrogen.xml",
                        uri: "//ui.hydrogen/interactive.session.share.dialog.options",
                        data: {
                            sessionUri: sessionUri
                        },
                        dataType: "json",
                        success: function (jsonResult) {
                            interactiveListSessions.shareDialog(id, sessionUri, {supportViewOnly: (jsonResult.supportViewOnly == 'true')});
                        }
                    });
                    return false;
                });
            });

            listView.bind('hytableaction', function (e, data) {
                jQuery.hydrogen.executeAction(data.action,
                    {'%CURRENT_ID%': data.currentId},
                    function () {
                        listView.hytable('reload');
                    },
                    msg);
            });

            listView.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': listView.hytable('selected').length
                });
            });

            if (compactView !== undefined) {
                compactView.bind('hysessionsconnect', function (e, data) {
                    self.connect(id, {
                        sessionUri: data.sessionUri,
                        sessionName: data.sessionName,
                        sessionRemote: data.sessionRemote,
                        initialStatus: data.status,
                        allowStarting: false
                    });
                });

                compactView.bind('hysessionsaction', function (e, data) {
                    jQuery.hydrogen.executeAction(data.action,
                        {'%CURRENT_ID%': data.currentId},
                        function () {
                            compactView.hysessions('reload');
                        },
                        msg);
                });

                compactView.bind('hysessionsselectionchanged', function (e, data) {
                    toolbar.hytoolbar('viewProperties', {
                        'selected': compactView.hysessions('selected').length
                    });
                });
            }

            toolbar.bind('hytoolbaraction', function (e, action) {
                jQuery.hydrogen.executeAction(action,
                    {'%SELECTED_IDS%': function () {
                        if (compactView === undefined || toolbar.hytoolbar('activeView').id === 'list') {
                            return listView.hytable('selected').join('\n');
                        }
                        return compactView.hysessions('selected').join('\n');
                    }},
                    function () {
                        if (compactView === undefined || toolbar.hytoolbar('activeView').id === 'list') {
                            listView.hytable('reload');
                        } else {
                            compactView.hysessions('reload');
                            compactView.hysessions('editMode', false);
                        }
                    },
                    msg);
            });

            toolbar.bind('hytoolbarsearch', function (e, s) {
                var formula;

                formula = filters.hyfilters('selected');

                if (formula !== null && formula !== '') {
                    if (s.search !== '') {
                        formula += " and name ?:= '" + s.search + "'";
                    }
                } else {
                    if (s.search !== '') {
                        formula = "name ?:= '" + s.search + "'";
                    } else {
                        formula = "";
                    }
                }

                listView.hytable('filter', formula);
                if (compactView !== undefined) {
                    compactView.hysessions('filter', formula);
                    compactView.hysessions('reload');
                }
            });

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, function () {
                listView.hytable('reload', null, 'auto');
                if (self._params.showCompactView) {
                    compactView.hysessions('reload', null, 'auto');
                }
            });

            if (self._params.connectTo) {
                self.connect(id, {
                    sessionUri: self._params.connectTo.sessionUri,
                    sessionName: self._params.connectTo.sessionName,
                    sessionRemote: self._params.connectTo.sessionRemote,
                    initialStatus: 'Pending',
                    allowStarting: false
                });
            }
        });
    }
};

// ex:ts=4:et:
