/**
 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license - This software is used under the MPL 2 license.
 */

CKEDITOR.editorConfig = function( config ) {

    // Toolbar groups arrangement
    config.toolbarGroups = [
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'styles', groups: [ 'styles' ] },
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'links', 'editing' ] },
        { name: 'insert', groups: [ 'insert' ] },
        { name: 'forms', groups: [ 'forms' ] },
        { name: 'tools', groups: [ 'tools' ] },
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'others', groups: [ 'others' ] },
        { name: 'paragraph', groups: [ 'align', 'list', 'indent', 'blocks', 'bidi', 'paragraph' ] },
        { name: 'colors', groups: [ 'colors' ] },
        { name: 'about', groups: [ 'about' ] }
    ];

    config.removeButtons = 'Underline,Subscript,Superscript,Source,Maximize,Image,Table,HorizontalRule,SpecialChar,Strike,RemoveFormat,Blockquote,About,Cut,Copy,Paste,PasteText,PasteFromWord,Scayt,Anchor,Unlink';

    // Most common block elements
    config.format_tags = 'p;h1;h2;h3;pre';

    // Simplify the dialog windows.
    config.removeDialogTabs = 'image:advanced;link:advanced';

    // Default title
    config.title = 'Click to Edit';

    // Avoid ckeditor entities
    config.htmlEncodeOutput = false;
    config.entities = false;
};
