<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:ia="http://www.enginframe.com/2012/Interactive"
  exclude-result-prefixes="ef ia"
>

  <xsl:template match="/">
    <xsl:apply-templates select="/ef:show-spooler"/>
  </xsl:template>

  <xsl:template match="/ef:show-spooler[(ef:spooler/ef:metadata[@attribute='INTERACTIVE_SESSION_STATUS']='Starting' or
                                         ef:spooler/ef:metadata[@attribute='INTERACTIVE_SESSION_STATUS']='Running')]">
    <connection>
      <xsl:apply-templates select="/ef:show-spooler/ef:spooler/ia:session/ia:attr"/>
    </connection>
  </xsl:template>

  <xsl:template match="/ef:show-spooler" priority="-1">
    <xsl:variable name="name" select="ef:spooler/ef:name"/>
    <xsl:variable name="status" select="ef:spooler/ef:metadata[@attribute='INTERACTIVE_SESSION_STATUS']"/>
    <error status="{$status}">
      Impossible to connect to the session "<xsl:value-of select="$name"/>": the session is <xsl:value-of select="$status"/> 
    </error>
  </xsl:template>

  <xsl:template match="ia:attr">
    <param name="{@id}"><xsl:value-of select="text()"/></param>
  </xsl:template>

</xsl:transform>
