<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fm="http://www.enginframe.com/2009/fm"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="fm filter encode"
  >

  <!-- import generic adapter library -->
  <xsl:import href="hydrogen.adapter.library.xsl" />

  <!--
    Override the common case (file and folders) since the generic adapter
    is expensive (dyn xpath eval)
  -->
  <xsl:template match="fm:items/fm:item">
    <!-- <item name="{@name}" type="{@type}" > -->
    <item>
      <xsl:attribute name="name">
        <xsl:value-of select="encode:forUriComponent(@name)" />
      </xsl:attribute>
      <xsl:attribute name="type">
        <xsl:value-of select="@type" />
      </xsl:attribute>
      <xsl:attribute name="id">
        <!-- jqgrid ids cannot contain double quote characters -->
        <xsl:value-of select="encode:forUriComponent(@name)" />
      </xsl:attribute>
      <!--
        If we have children or extra attributes, it means we merged
        information from an extension script and we need to apply the
        generic adapter
      -->
      <xsl:choose>
        <xsl:when test="* or @*[name()!='type' and name()!='name' and name()!='label' and name()!='size' and name()!='modified']">
          <!-- copy extra attributes -->
          <xsl:apply-templates select="@*[name()!='type' and name()!='name' and name()!='label' and name()!='size' and name()!='modified']" />
          <!-- call template with mode="adapter" that may be overwritten -->
          <xsl:apply-templates select="//filter:mapper-list/filter:mapper" mode="adapter">
            <xsl:with-param name="row" select="." />
          </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
          <name>
            <xsl:choose>
              <xsl:when test="@label!=''">
                <xsl:value-of select="@label"/>
              </xsl:when>
              <xsl:when test="@name!=''">
                <!-- <xsl:value-of select="@name"/> --> 
		<xsl:value-of select="encode:forUriComponent(@name)" />
              </xsl:when>
              <xsl:otherwise>N/A</xsl:otherwise>
            </xsl:choose>
          </name>
          <modified>
            <xsl:value-of select="@modified"/>
          </modified>
          <xsl:if test="@type!='folder'">
            <size unit="bytes"><xsl:value-of select="@size"/></size>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </item>
  </xsl:template>

  <!-- define the name -->
  <xsl:template match="filter:mapper[@id='name']" mode="adapter">
    <xsl:param name="row" />
    <xsl:attribute name="id">
      <xsl:value-of select="$row/@name" />
    </xsl:attribute>
    <name>
      <xsl:choose>
        <xsl:when test="$row/@label and not($row/@label='')">
          <xsl:value-of select="$row/@label" />
        </xsl:when>
        <xsl:when test="$row/@name and not($row/@name='')">
          <xsl:value-of select="$row/@name" />
        </xsl:when>
        <xsl:otherwise>N/A</xsl:otherwise>
      </xsl:choose>
    </name>
  </xsl:template>

  <!-- define an extra attribute for size -->
  <xsl:template match="filter:mapper[@id='size']" mode="adapter">
    <xsl:param name="row" />
    <xsl:if test="$row/@size">
      <size unit="bytes">
        <xsl:value-of select="$row/@size" />
      </size>
    </xsl:if>
  </xsl:template>

</xsl:transform>
