<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:option[@type='rfb' and $ef.serviceform.option.rfb.renderer='hydrogen']" mode="renderer">
    <xsl:param name="update"/>

    <xsl:variable name="contents">
      <xsl:apply-templates select="." mode="option.value">
        <xsl:with-param name="update" select="$update"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:variable name="serviceid">
      <xsl:value-of select="ancestor::ef:service/@id"/>
    </xsl:variable>

    <!-- strip trailing ":" from the label (if it is there) -->
    <xsl:variable name="title">
      <xsl:choose>
        <xsl:when test="substring(@label, string-length(@label)) = ':'">
          <xsl:value-of select="substring(@label, 1, string-length(@label) - 1)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@label"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td valign="middle">
          <xsl:choose>
            <xsl:when test="@multi = 'true'">
              <textarea wrap="off">
                <xsl:attribute name="rows">
                  <xsl:choose>
                    <xsl:when test="@height">
                      <xsl:value-of select="@height"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_multi_default_height"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="cols">
                  <xsl:choose>
                    <xsl:when test="@width">
                      <xsl:value-of select="@width"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_multi_default_width"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:call-template name="ef_option_common_attributes"/>
                <xsl:call-template name="ef:intrinsic_events"/>
                <xsl:value-of select="$contents"/>
                <!-- Fix a problem in XSLT when rendering XHTML (this is fixed in XSLT 2) -->
                <xsl:if test="$contents = ''">
                  <xsl:text>&#10;</xsl:text>
                </xsl:if>
              </textarea>
            </xsl:when>
            <xsl:otherwise>
              <input type="text" value="{$contents}">
                <xsl:attribute name="size">
                  <xsl:choose>
                    <xsl:when test="@width">
                      <xsl:value-of select="@width"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$rfb_default_width"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:call-template name="ef_option_common_attributes"/>
                <xsl:call-template name="ef:intrinsic_events"/>
              </input>
            </xsl:otherwise>
          </xsl:choose>
          <div class="button_service_RFB">
            <button id="button_serviceopt_{@id}RFB" name="{@id}RFB" type="button">
              <xsl:if test="@disabled">
                <xsl:attribute name="disabled">
                  <xsl:value-of select="@disabled"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:text>Select...</xsl:text>
            </button>
            <xsl:if test="@multi = 'true'">
              <button type="button" value="Clear" id="button_clear_{@id}RFB">
                <xsl:text>Clear</xsl:text>
              </button>
              <xsl:apply-templates select="@extra"/>
            </xsl:if>
            <xsl:if test="@extra and not(@multi = 'true')">
              <xsl:apply-templates select="@extra"/>
            </xsl:if>
          </div>
        </td>
      </tr>
    </table>

    <script type="text/javascript">
        jQuery(document).ready(function () {
            jQuery.hydrogen.initRFB({
                id: "<xsl:value-of select="encode:forJavaScriptBlock(@id)"/>",
                serviceid: "<xsl:value-of select="encode:forJavaScriptBlock($serviceid)"/>",
                vrootId: "<xsl:value-of select="encode:forJavaScriptBlock(@vroot-id)"/>",
                vrootSpooler: "<xsl:value-of select="encode:forJavaScriptBlock(@vroot-spooler)"/>",
                title: "<xsl:value-of select="encode:forJavaScriptBlock($title)"/>",
                base: "<xsl:value-of select="encode:forJavaScriptBlock(@base)"/>",
                target: "<xsl:value-of select="encode:forJavaScriptBlock(@target)"/>",
                plugin: "<xsl:value-of select="encode:forJavaScriptBlock(@plugin)"/>",
                filter: "<xsl:value-of select="encode:forJavaScriptBlock(@filter)"/>",
                multi: "<xsl:value-of select="encode:forJavaScriptBlock(@multi)"/>",
                rowNum: "<xsl:value-of select="encode:forJavaScriptBlock($hy.rfb.page.size)"/>",
                class: "<xsl:value-of select="encode:forJavaScriptBlock(@class)"/>"
            });
        });
    </script>
  </xsl:template>

</xsl:stylesheet>
