<?xml version="1.0" encoding="utf-8"?>

<!--
Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
Copyright 1999-2023 by Nice, srl., All rights reserved.
This software includes confidential and proprietary information
of NI SP Software GmbH ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NI SP Software.-->


<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
  xmlns:encode="org.owasp.encoder.Encode"
  extension-element-prefixes="efx"
  exclude-result-prefixes="ef efx encode"
  >


  <xsl:template match="ef:service[$ef.serviceprofile.renderer='hydrogen']" mode="serviceprofile">

    <xsl:variable name="serviceid">
      <xsl:value-of select="@id"/>
    </xsl:variable>

    <xsl:variable name="cancertify">
      <efx:acl>
        <ef:apply-acl select="certify-service-profiles">
          true
        </ef:apply-acl>
      </efx:acl>
    </xsl:variable>

    <script type="text/javascript">
      <xsl:comment>
      jQuery(document).ready(function () {
        jQuery.hydrogen.serviceProfileSelector({
          agentId: "<xsl:value-of select="encode:forJavaScriptBlock($agent)"/>",
          serviceId: "<xsl:value-of select="encode:forJavaScriptBlock($serviceid)"/>",
          canCertify: <xsl:value-of select="contains($cancertify, 'true')"/>
        });
      });
      //</xsl:comment>
    </script>

  </xsl:template>

</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

