<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:func="http://exslt.org/functions"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:f="http://www.enginframe.com/2011/EnginFrame/functions"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef grid func f encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.
-->

  <!-- Input parameters -->
  <xsl:param name="_root_context">enginframe</xsl:param>

  <xsl:variable name="count-job-arrays">
    <xsl:value-of select="count(grid:job-list[@mode='array']/grid:job)" />
  </xsl:variable>

  <xsl:template match="grid:job-list[@mode='array']">
    <xsl:if test="$count-job-arrays > 0" ><xsl:apply-templates /></xsl:if>
  </xsl:template>

  <xsl:template match="grid:job-list">
    <xsl:choose>
      <xsl:when test="$count-job-arrays > 0" ></xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="grid:array-status">
    <!-- 
      The class hy-gridjobs-array-title is used inside hydrogen.grid-array-jobs.js
      to infer that this job is actually a job array.
    -->
    <div class="hy-gridjobs-array-title">Job array status</div>
    <div class="hy-gridjobs-array-values">
      <div class="hy-gridjobs-array-status">Total jobs</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='']" /> </div>
      <div class="hy-gridjobs-array-status">Pending</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Pending']" /> </div>
      <div class="hy-gridjobs-array-status">Successful</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Done']" /> </div>
      <div class="hy-gridjobs-array-status">Running</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Running']" /> </div>
      <div class="hy-gridjobs-array-status">Exited with errors</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Exit']" /> </div>
      <div class="hy-gridjobs-array-status">System suspended</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Interrupted']" /> </div>
      <div class="hy-gridjobs-array-status">User/process suspended</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="sum(grid:counter[@ef='Suspended'])" /> </div>
      <div class="hy-gridjobs-array-status">Total terminated</div><div class="hy-gridjobs-array-status-value"><xsl:value-of select="grid:counter[@ef='Exit'] + grid:counter[@ef='Done']" /> </div>
    </div>
  </xsl:template>

  <xsl:template match="grid:job" >

    <xsl:variable name="job-id">
      <xsl:choose>
        <xsl:when test="@minIndex and @maxIndex">
          <xsl:value-of select="concat(@id, ' [', @minIndex, '-', @maxIndex, ']')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@id" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="job-name">
      <xsl:choose>
        <xsl:when test="grid:name">
          <xsl:value-of select="grid:name" />
        </xsl:when>
        <xsl:when test="grid:command">
          <xsl:value-of select="grid:command" />
        </xsl:when>
        <xsl:when test="grid:name">-not available-</xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="job-status">
      <xsl:choose>
        <xsl:when test="grid:status/@ef">
          <xsl:value-of select="grid:status/@ef" />
        </xsl:when>
        <xsl:otherwise>unknown</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cluster_type">
      <xsl:choose>
        <xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
        <xsl:when test="../@type"><xsl:value-of select="../@type"/></xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cluster_id">
      <xsl:choose>
        <xsl:when test="@cluster"><xsl:value-of select="@cluster"/></xsl:when>
        <xsl:when test="../@cluster"><xsl:value-of select="../@cluster"/></xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="cluster_name">
      <xsl:if test="count(/grid:list-clusters/grid:cluster) > 1">
        <xsl:choose>
          <xsl:when test="grid:clusterName!=''">
            <xsl:value-of select="grid:clusterName"/>
          </xsl:when>
          <xsl:when test="grid:cluster-id!=''">
            <xsl:value-of select="grid:cluster-id"/>
          </xsl:when>
          <xsl:when test="$cluster_id!=''">
            <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$cluster_type and @id=$cluster_id]"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="/grid:list-clusters/grid:cluster[@type=$cluster_type][1]"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>

    <xsl:variable name="has-resources">
      <xsl:choose>
        <xsl:when test="grid:total-cpu-usage|grid:memory-usage|grid:swap-usage|grid:thread|grid:pid-group|grid:pids">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <div class="hy-gridjobs-panel-container">
      <div class="hy-gridjobs-panel-head">
        <div class="hy-gridjobs-panel-title">
          <img class="hy-gridjobs-panel-title-icon" src="/{$_root_context}/third-party/fugue-icons/bonus/icons-24/gear.png" />
          <div class="hy-gridjobs-panel-title-job-id">Job <xsl:value-of select="$job-id"/></div>
          <div class="hy-gridjobs-panel-title-job-name"><xsl:value-of select="$job-name"/></div>
        </div>

        <div class="hy-gridjobs-panel-jobdata">
          <div class="hy-gridjobs-data-name">Job Id</div>
          <div class="hy-gridjobs-data-value">
            <xsl:value-of select="$job-id"/>
          </div>

          <xsl:apply-templates select="../ef:show-spooler" mode="show-spooler"/>

          <xsl:copy-of select="f:resource(grid:owner, 'User')" />
          <div class="hy-gridjobs-data-name">Project</div>
          <div class="hy-gridjobs-data-value">
            <xsl:choose>
              <xsl:when test="grid:account and grid:account!='' and grid:account!='(null)'">
                <xsl:value-of select="grid:account"/>
              </xsl:when>
              <xsl:otherwise>
                -
              </xsl:otherwise>
            </xsl:choose>
          </div>

          <xsl:choose>
            <xsl:when test="grid:status">
              <div class="hy-gridjobs-data-name">Status</div>
              <div class="hy-gridjobs-data-value">
                <div>
                  <xsl:attribute name="class"><xsl:value-of select="concat('hy-job-status hy-job-status-', f:lowercase($job-status))" /></xsl:attribute>
                  <xsl:value-of select="$job-status" />
                  <xsl:if test="grid:status/@grid!=''">
                    <span class="hy-job-grid-status"> (<xsl:value-of select="grid:status/@grid" />)</span>
                  </xsl:if>
                </div>
              </div>
            </xsl:when>
            <xsl:when test="grid:array-status">
              <xsl:apply-templates select="grid:array-status" />
            </xsl:when>
            <xsl:otherwise>
              <div class="hy-gridjobs-data-name">Status</div>
              <div class="hy-gridjobs-data-value"><xsl:text>-</xsl:text></div>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:copy-of select="f:resource(grid:queue, 'Queue')" />

          <xsl:if test="grid:nice!=''">
            <div class="hy-gridjobs-data-name">Nice</div>
            <div class="hy-gridjobs-data-value">
              <div class="hy-gridjobs-command">
                <!-- grid:command is already html-encoded -->
                <div><xsl:value-of select="grid:nice" /></div>
              </div>
            </div>
          </xsl:if>

          <xsl:if test="grid:command!=''">
            <div class="hy-gridjobs-data-name">Command</div>
            <div class="hy-gridjobs-data-value">
              <div class="hy-gridjobs-command">
                <!-- grid:command is already html-encoded -->
                <div><xsl:value-of select="grid:command" /></div>
              </div>
            </div>
          </xsl:if>

          <xsl:if test="$cluster_name != ''">
            <br /> <!-- Vertical space -->
            <div class="hy-gridjobs-data-name">
              &#160;
            </div>
            <div class="hy-gridjobs-data-value hy-gridjobs-job-list-link">
              <a href="{f:job-list-link($cluster_type, $cluster_id)}">All jobs on <xsl:value-of select="$cluster_name"/></a>
            </div>
          </xsl:if>

          <xsl:if test="$cluster_id != ''">
            <div class="hy-gridjobs-data-name">
              Cluster Id
            </div>
            <div class="hy-gridjobs-data-value">
              <xsl:value-of select="$cluster_id"/>
            </div>
          </xsl:if>

          <div class="hy-gridjobs-data-name">Location</div>
          <div class="hy-gridjobs-data-value">
            <xsl:choose>
              <xsl:when test="grid:location != ''">
                <xsl:value-of select="grid:location"/>
              </xsl:when>
              <xsl:otherwise>Local</xsl:otherwise>
            </xsl:choose>
          </div>
        </div>

        <div class="ui-helper-clearfix">

          <div class="hy-gridjobs-panel-jobhistory">

            <!-- Check if first column must expand to 100% -->
              <xsl:variable name="first-col-css-mod">
                <xsl:choose>
                  <xsl:when test="$has-resources = 'true' or grid:requirements"></xsl:when>
                  <xsl:otherwise>hy-gridjobs-width-auto</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>

            <xsl:if test="grid:submission-host">
              <div class="hy-gridjobs-box-left {$first-col-css-mod}">
                <div class="hy-gridjobs-box-left-head">
                  <h2 class="hy-gridjobs-submission-icon">Submission</h2>
                </div>
                <div class="hy-gridjobs-box-left-body">
                  <xsl:if test="grid:submission-time!=''">
                    <div class="hy-gridjobs-data-name">Time</div>
                    <div class="hy-gridjobs-data-value">
                      <xsl:copy-of select="f:iso8601time(grid:submission-time)"/>
                    </div>
                  </xsl:if>
                  <xsl:copy-of select="f:resource(grid:submission-host, 'Host')" />

                  <xsl:if test="grid:submission-directory!=''">
                    <div class="hy-gridjobs-data-name">Directory</div>
                    <xsl:variable name="submission-dir">
                      <xsl:value-of select="grid:submission-directory" />
                    </xsl:variable>
                    <div class="hy-gridjobs-data-value" title="{$submission-dir}">
                      <xsl:value-of select="$submission-dir" />
                    </div>
                  </xsl:if>

                  <xsl:if test="grid:reasons/grid:reason">
                    <div class="hy-gridjobs-data-name">Pending reasons:</div>
                    <div class="hy-gridjobs-data-value">
                      <ul>
                        <xsl:for-each select="grid:reasons/grid:reason">
                          <li><xsl:apply-templates select="."/></li>
                        </xsl:for-each>
                      </ul>
                    </div>
                  </xsl:if>
                </div>
              </div>
            </xsl:if>

            <xsl:if test="grid:execution-host">
              <div class="hy-gridjobs-box-left {$first-col-css-mod}">
                <div class="hy-gridjobs-box-left-head">
                  <h2 class="hy-gridjobs-execution-icon">Execution</h2>
                </div>
                <div class="hy-gridjobs-box-left-body">
                  <xsl:if test="grid:execution-time!=''">
                    <div class="hy-gridjobs-data-name">Time</div>
                    <div class="hy-gridjobs-data-value">
                      <xsl:copy-of select="f:iso8601time(grid:execution-time)" />
                    </div>
                  </xsl:if>
                  <xsl:variable name="numhost" select="count(./grid:execution-host[not(text() = preceding-sibling::grid:execution-host/text())])"/>
                  <xsl:choose>
                    <xsl:when test="$numhost &gt; 1">
                      <div class="hy-gridjobs-data-name">Hosts</div>
                    </xsl:when>
                    <xsl:otherwise>
                      <div class="hy-gridjobs-data-name">Host</div>
                    </xsl:otherwise>
                  </xsl:choose>
                  <div class="hy-gridjobs-data-value">
                    <xsl:choose>
                      <xsl:when test="$numhost &gt; 10">
                        <div class="hy-gridjobs-data-scroll">
                          <ul>
                            <xsl:apply-templates select="grid:execution-host">
                              <xsl:with-param name="grid-manager" select="$cluster_type"/>
                              <xsl:with-param name="cluster" select="$cluster_id"/>
                            </xsl:apply-templates>
                          </ul>
                        </div>
                      </xsl:when>
                      <xsl:when test="$numhost &gt; 0">
                        <ul>
                          <xsl:apply-templates select="grid:execution-host">
                            <xsl:with-param name="grid-manager" select="$cluster_type"/>
                            <xsl:with-param name="cluster" select="$cluster_id"/>
                          </xsl:apply-templates>
                        </ul>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text>-</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>

                  <xsl:if test="grid:execution-directory!=''">
                    <div class="hy-gridjobs-data-name">Directory</div>
                    <xsl:variable name="execution-dir">
                      <xsl:value-of select="grid:execution-directory" />
                    </xsl:variable>
                    <div class="hy-gridjobs-data-value" title="{$execution-dir}" >
                      <xsl:value-of select="$execution-dir" />
                    </div>
                  </xsl:if>
                </div>
              </div>
            </xsl:if>

            <xsl:if test="grid:termination-time">
              <div class="hy-gridjobs-box-left">
                <div class="hy-gridjobs-box-left-head">
                  <h2 class="hy-gridjobs-termination-icon">Termination</h2>
                </div>
                <div class="hy-gridjobs-box-left-body">
                  <div class="hy-gridjobs-data-name">Time</div>
                  <div class="hy-gridjobs-data-value">
                    <xsl:copy-of select="f:iso8601time(grid:termination-time)" />
                  </div>

                  <xsl:copy-of select="f:resource(grid:exit-code, 'Exit code')" />
                  <xsl:copy-of select="f:resource(grid:post-process, 'Post process')" />
                </div>
              </div>
            </xsl:if>

            <div class="hy-gridjobs-box-right">
              <xsl:if test="grid:requirements!=''">
                <div class="hy-gridjobs-box-right-head">
                  <h2 class="hy-gridjobs-resources-icon">Resource requirements</h2>
                </div>
                <div class="hy-gridjobs-box-right-body">
                  <div class="hy-gridjobs-data-1colvalue">
                    <xsl:value-of select="grid:requirements" />
                  </div>
                </div>
              </xsl:if>

              <xsl:if test="$has-resources = 'true'">
                <div class="hy-gridjobs-box-right-head">
                  <h2 class="hy-gridjobs-resource-consumption-icon">Resource consumption</h2>
                </div>
                <div class="hy-gridjobs-box-right-body">
                  <xsl:copy-of select="f:resource(grid:total-cpu-usage, 'CPU Usage')" />
                  <xsl:copy-of select="f:resource(grid:memory-usage, 'Memory usage')" />
                  <xsl:copy-of select="f:resource(grid:swap-usage, 'Swap usage')" />
                  <xsl:copy-of select="f:resource(grid:thread, 'Threads')" />
                  <xsl:copy-of select="f:resource(grid:pid-group, 'Pgid')" />
                  <xsl:copy-of select="f:resource(grid:pids, 'Pids')" />
                </div>
              </xsl:if>
            </div>
            <div class="hy-gridjobs-padder" ></div>
          </div>
        </div>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="grid:job/grid:execution-host">
    <xsl:param name="grid-manager"/>
    <xsl:param name="cluster"/>
    <!-- Test if the execution host is different from the previous execution hosts of the current job -->
    <xsl:if test="not(text() = preceding-sibling::grid:execution-host/text())">
      <xsl:variable name="host" select="text()" />
      <xsl:variable name="host-info-url">
        <xsl:text>?_uri=//com.enginframe.grid</xsl:text>
        <xsl:text>/host.info&amp;host=</xsl:text>
        <xsl:value-of select="encode:forUriComponent(text())"/>
        <xsl:text>&amp;grid=</xsl:text>
        <xsl:value-of select="encode:forUriComponent($grid-manager)"/>
        <xsl:text>&amp;cluster=</xsl:text>
        <xsl:value-of select="encode:forUriComponent($cluster)"/>
      </xsl:variable>
      <li>
        <a href="{$host-info-url}"><xsl:value-of select="text()"/></a>
        <xsl:variable name="numhost">
          <xsl:choose>
            <xsl:when test="@cores">
              <xsl:value-of select="@cores" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="count(../grid:execution-host[$host = text()])" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="$numhost > 1">
          <xsl:text> [</xsl:text>
          <xsl:value-of select="$numhost"/>
          <xsl:text> cores]</xsl:text>
        </xsl:if>
      </li>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ef:show-spooler|grid:list-clusters">
  </xsl:template>

  <xsl:template match="ef:show-spooler" mode="show-spooler">
    <xsl:if test="ef:spooler/ef:metadata[@attribute='EF_SPOOLER_TYPE']/text()='data'">
      <div class="hy-gridjobs-data-name">Data</div>
      <div class="hy-gridjobs-data-value">
        <a href="?_uri=//com.enginframe.system/show.spooler&amp;_spooler={@enc-uri}">
          <!-- ef:spooler/ef:name is already html-encoded -->
          <xsl:value-of select="ef:spooler/ef:name"/>
        </a>
      </div>
      <br /> <!-- vertical spacer -->
    </xsl:if>
    <xsl:if test="ef:spooler/ef:metadata[@attribute='EF_SPOOLER_TYPE']/text()='session'">
      <div class="hy-gridjobs-data-name">Session</div>
      <div class="hy-gridjobs-data-value">
        <a href="?_uri=//com.enginframe.interactive/session.info&amp;sessionUri={@enc-uri}">
          <!-- ef:spooler/ef:name is already html-encoded -->
          <xsl:value-of select="ef:spooler/ef:name"/>
        </a>
      </div>
      <br /> <!-- vertical spacer -->
    </xsl:if>
  </xsl:template>

  <!-- propagate ef:errors -->
  <xsl:template match="/ef:error" priority="-1">
    <xsl:apply-templates select="." mode="error"/>
  </xsl:template>

  <xsl:template match="node()|@*" mode="error" >
    <xsl:copy>
      <xsl:apply-templates select="node()|@*" mode="error"/>
    </xsl:copy>
  </xsl:template>

  <func:function name="f:lowercase">
    <xsl:param name="text" />
    <func:result>
      <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
      <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
      <xsl:value-of select="translate($text, $uppercase, $lowercase)"/>
    </func:result>
  </func:function>

  <func:function name="f:job-list-link">
    <xsl:param name="grid-manager"/>
    <xsl:param name="cluster" />
    <func:result>
      <xsl:text>?_uri=//com.enginframe.grid/list.jobs</xsl:text>
      <xsl:text>&amp;grid=</xsl:text>
      <xsl:value-of select="encode:forUriComponent($grid-manager)"/>
      <xsl:text>&amp;cluster=</xsl:text>
      <xsl:value-of select="encode:forUriComponent($cluster)"/>
    </func:result>
  </func:function>

  <func:function name="f:iso8601time">
    <xsl:param name="time" />
    <func:result>
      <span class="hy-iso8601-time">
        <xsl:value-of select="$time"/>
      </span>
    </func:result>
  </func:function>

  <func:function name="f:resource">
    <xsl:param name="value" />
    <xsl:param name="label" />
    <func:result>
      <xsl:if test="$value!=''">
        <div class="hy-gridjobs-data-name"><xsl:value-of select="$label" /></div>
        <div class="hy-gridjobs-data-value">
          <xsl:for-each select="$value">
            <xsl:value-of select="text()" /><xsl:text> </xsl:text>
          </xsl:for-each>
        </div>
      </xsl:if>
    </func:result>
  </func:function>

</xsl:stylesheet>
