<?xml version="1.0" encoding="UTF-8"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:transform version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  xmlns:filter="http://www.enginframe.com/2010/EnginFrame/Filter"
  exclude-result-prefixes="grid filter"
  >

  <!-- import generic adapter library -->
  <xsl:import href="hydrogen.adapter.library.xsl" />

  <xsl:template match="//grid:cluster">
      <xsl:if test="@type != 'awsbatch'">
          <cluster>
            <id><xsl:value-of select="@id"/></id>
            <type><xsl:value-of select="@type"/></type>
            <scheduler><xsl:value-of select="translate(@scheduler[. != ''] | @type, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/></scheduler>
            <queues><xsl:value-of select="@queues"/></queues>
            <status><xsl:if test="not(@status)">READY</xsl:if><xsl:value-of select="@status"/></status>
            <location><xsl:if test="not(@location)">Local</xsl:if><xsl:value-of select="@location"/></location>
            <userGroups><xsl:value-of select="@userGroups"/></userGroups>
            <name><xsl:value-of select="@name"/></name>
          </cluster>
      </xsl:if>
  </xsl:template>
</xsl:transform>
