<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  exclude-result-prefixes="ef hy">

 <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:include href="hydrogen.widgets.xsl" />

  <xsl:include href="widgets/hydrogen.ef-list-spoolers.xsl" />
  <xsl:include href="widgets/hydrogen.ef-show-spooler.xsl" />
  <xsl:include href="widgets/hydrogen.ef-spooler-box.xsl" />
  <xsl:include href="widgets/hydrogen.ef-spooler-data.xsl" />
  <xsl:include href="widgets/hydrogen.fm-browse.xsl" />
  <xsl:include href="widgets/hydrogen.grid-array-jobs.xsl" />
  <xsl:include href="widgets/hydrogen.grid-host-info.xsl" />
  <xsl:include href="widgets/hydrogen.grid-host-jobs.xsl" />
  <xsl:include href="widgets/hydrogen.grid-job-info.xsl" />
  <xsl:include href="widgets/hydrogen.grid-list-clusters.xsl" />
  <xsl:include href="widgets/hydrogen.grid-list-hosts.xsl" />
  <xsl:include href="widgets/hydrogen.grid-list-jobs.xsl" />
  <xsl:include href="widgets/hydrogen.grid-list-templates.xsl" />
  <xsl:include href="widgets/hydrogen.grid-template-info.xsl" />
  <xsl:include href="widgets/hydrogen.grid-cluster-info.xsl" />
  <xsl:include href="widgets/hydrogen.grid-spooler-jobs.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-list-sessions.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-connect-session.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-session-info.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-session-info.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-dcv2-settings.xsl" />
  <xsl:include href="widgets/hydrogen.interactive-dcv2sm-settings.xsl" />

  <xsl:include href="hydrogen.rfb.xsl" />
  <xsl:include href="hydrogen.interactive.xsl" />
  <xsl:include href="hydrogen.serviceprofile.xsl" />

  <xsl:template match="*|@*" mode="ui.head.copy">
    <xsl:copy-of select="."/>
  </xsl:template>

  <xsl:template match="hy:head" mode="ui.head">
    <xsl:apply-templates mode="ui.head.copy"/>
  </xsl:template>

  <xsl:template match="hy:head"/>

  <!-- Right now we include the hy css and js in all the pages, since it also contains stuff used in
       service forms outside hy widgets (for instance the rfb and the interactive reconnect).
       If we add new UIs we will need to make this more restrictive -->
  <xsl:template match="/ef:agent" mode="ui.head">

    <link rel="stylesheet" type="text/css" media="screen" href="/{$_root_context}/hydrogen/third-party/jqgrid/css/ui.jqgrid.css?{$_ef_cache_timestamp}" />
    <link rel="stylesheet" type="text/css" media="screen" href="/{$_root_context}/hydrogen/css/ef.ui.jqgrid.css?{$_ef_cache_timestamp}" />
    <link rel="stylesheet" type="text/css" media="screen" href="/{$_root_context}/hydrogen/css/ef.ui.menu.css?{$_ef_cache_timestamp}" />
    <link rel="stylesheet" type="text/css" media="screen" href="/{$_root_context}/hydrogen/css/ui.hydrogen.css?{$_ef_cache_timestamp}" />
    <link rel="stylesheet" type="text/css" media="screen" href="/{$_root_context}/hydrogen/css/token-input-hydrogen.css?{$_ef_cache_timestamp}" />
    <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/jqgrid/js/i18n/grid.locale-en.js?{$_ef_cache_timestamp}">
      <xsl:comment>//</xsl:comment>
    </script>
    <xsl:choose>
      <xsl:when test="($ef.js.debug = 'debug')">
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/jqgrid/js/jquery.jqGrid.src.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <!-- Hydrogen third party libraries -->
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.browser.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.menu.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.jBreadCrumb.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.form.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.bgiframe.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.query.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/json2.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/detect-zoom.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.jqGrid.fluid.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.deserialize.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jquery.tokeninput.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/spin.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/js/jQuery.dynacloud.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <!-- Hydrogen libraries -->
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.hyutils.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hymessage.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hytable.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hytoolbar.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyclusters.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyfilters.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hycharts.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyprojects.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyqueues.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hycompactview.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyspoolerbar.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyfilebrowser.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyspoolerbox.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hysessionsharedialog.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyrfb.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyinteractive.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyjobs.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hylistspoolers.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyconnectionbar.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hysessions.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/hy/jquery.ui.hyserviceprofile.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:when>
      <xsl:otherwise>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/third-party/jqgrid/js/jquery.jqGrid.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
        <script type="text/javascript" src="/{$_root_context}/hydrogen/js/jquery.hydrogen.min.js?{$_ef_cache_timestamp}">
          <xsl:comment>//</xsl:comment>
        </script>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:apply-templates select="//hy:head" mode="ui.head"/>

    <!--  FIXME: if the same widget was used more than once, here we would duplicate the header -->
    <xsl:apply-templates select="//ef:ui-widget[@ui='hydrogen']" mode="widget.head"/>
  </xsl:template>

</xsl:stylesheet>
