<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:encode="org.owasp.encoder.Encode"
  exclude-result-prefixes="ef hy encode">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:metadata" mode="widget">
    <xsl:value-of select="@attribute"/>
    <xsl:text>: "</xsl:text>
    <xsl:value-of select="encode:forJavaScriptBlock(text())"/>
    <xsl:text>"</xsl:text>
    <xsl:if test="position() != last()">
      <xsl:text>, </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="ef:spooler" mode="widget">
    var spoolerData = {
      <xsl:text>'uri': "</xsl:text>
      <xsl:value-of select="encode:forJavaScriptBlock(@uri)"/>
      <xsl:text>", 'name': "</xsl:text>
      <xsl:value-of select="encode:forJavaScriptBlock(ef:name)"/>
      <xsl:text>", 'creation-time': '</xsl:text>
      <xsl:value-of select="encode:forJavaScriptBlock(ef:creation-time)" />'
      <xsl:if test="ef:expiration-time">
        <xsl:text>, 'expiration-time': '</xsl:text>
        <xsl:value-of select="encode:forJavaScriptBlock(ef:expiration-time)" />'
      </xsl:if>
        , metadata: {
          <xsl:apply-templates select="ef:metadata" mode="widget"/>
        }
      };
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='ef-show-spooler']" mode="widget.head">
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.{@type}.js?{$_ef_cache_timestamp}"></script>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='ef-show-spooler']" mode="widget">

    <div id="{@id}" class="hy-content">
      <div id="{concat(@id,'-message')}"/>
      <div id="{concat(@id,'-toolbar')}"/>
      <div id="{concat(@id,'-spooler-bar')}" />
    </div>

    <!-- FIXME: gestire il caso di spooler non esistente -->

    <script type="text/javascript"><xsl:comment>
      <xsl:apply-templates select="ef:show-spooler/ef:spooler" mode="widget"/>
      efShowSpooler.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>

</xsl:stylesheet>
