<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:efdate="http://www.enginframe.com/2009/EF/Date"
  exclude-result-prefixes="ef hy"
  extension-element-prefixes="efdate">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='ef-spooler-data']" mode="widget.head">
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.{@type}.js?{$_ef_cache_timestamp}"></script>

    <!-- NOTE: to avoid duplication we share the dynamic actions with the fm-browse widget, so we need
         to also include the corresponding js file -->
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.fm-browse.js?{$_ef_cache_timestamp}"></script>

    <!-- for the download applet -->
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.applets.js?{$_ef_cache_timestamp}"></script>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='ef-spooler-data']" mode="widget">
    <!-- We use the ui-helper-hidden-accessible class since normal hiding while loading the table breaks on IE -->
    <div id="{@id}" class="hy-box hy-spooler-section hy-spooler-data ui-widget ui-helper-hidden-accessible">
      <div>Data</div>
      <div>
        <div id="{concat(@id,'-message')}" />
        <div id="{concat(@id,'-toolbar')}"/>
        <div id="{concat(@id,'-file-browser')}"/>
      </div>
    </div>

    <!-- FIXME: gestire il caso di spooler non esistente -->

    <script type="text/javascript"><xsl:comment>
      <xsl:apply-templates select="ef:show-spooler/ef:spooler" mode="widget"/>
      efSpoolerData.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>

</xsl:stylesheet>
