<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:efdate="http://www.enginframe.com/2009/EF/Date"
  exclude-result-prefixes="ef hy xalan"
  extension-element-prefixes="efdate">

  <!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='fm-browse']" mode="widget.head">
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.{@type}.js?{$_ef_cache_timestamp}"></script>

    <!-- for the download applet -->
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.applets.js?{$_ef_cache_timestamp}"></script>

    <!-- for the drag drop functionality  -->
    <script type="text/javascript" src="/{$_root_context}/third-party/fine-uploader/fine-uploader.min.js?{$_ef_cache_timestamp}"></script>
    <script type="text/javascript" src="/{$_root_context}/lib/js/sha1asm.js?{$_ef_cache_timestamp}"></script>
    <script type="text/javascript" src="/{$_root_context}/lib/js/com.enginframe.fileupload.js?{$_ef_cache_timestamp}"></script>
    <link rel="stylesheet" type="text/css" href="/{$_root_context}/third-party/fine-uploader/fine-uploader-new.min.css?{$_ef_cache_timestamp}" />
    <link rel="stylesheet" type="text/css" href="/{$_root_context}/lib/css/com.enginframe.fileupload.css?{$_ef_cache_timestamp}" />
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='fm-browse']" mode="widget">

    <div id="{@id}" class="hy-content ui-helper-clearfix">
      <div id="{concat(@id,'-message')}" />
      <div id="{concat(@id,'-toolbar')}"/>
      <div id="{concat(@id,'-file-browser')}"/>
    </div>

    <script type="text/javascript"><xsl:comment>
      fmBrowse.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>

</xsl:stylesheet>
