<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
  xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
  exclude-result-prefixes="ef hy">

  <!--
    * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.  -->

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='interactive-session-info']" mode="widget.head">
    <script type="text/javascript" src="/{$_root_context}/hydrogen/js/widgets/hydrogen.{@type}.js?{$_ef_cache_timestamp}"></script>
  </xsl:template>

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='interactive-session-info']" mode="widget">
    <div id="{@id}" class="hy-content">
      <div id="{concat(@id,'-message')}"/>
      <div id="{concat(@id,'-connectionbar')}"/>
      <div id="{concat(@id,'-toolbar')}"/>
      <div id="{concat(@id,'-session-view')}" class="hy-session-info">
        <div id="{concat(@id,'-session-details')}"/>
      </div>
    </div>

    <script type="text/javascript"><xsl:comment>
      interactiveSessionInfo.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>

</xsl:stylesheet>
