<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
    xmlns:hy="http://www.enginframe.com/2009/UI/Hydrogen"
    exclude-result-prefixes="ef hy">

<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

  <xsl:template match="ef:ui-widget[@ui='hydrogen' and @type='interactive-vnc-settings']" mode="widget">
    <!-- This HTML snippet has been copied, with some small cleanup, from the one generated by VNC while processing 
        the following service:
        
         <ef:service id="settings">
          <ef:name>Settings</ef:name>

          <ef:option-group id="resolution" label="Display Resolution" collapsible="false">
            <ef:info>
              <p>
                <div class="hy-message ui-widget">
                  <div class="ui-state-info ui-corner-all">
                    <table width="100%">  
                      <tr>
                        <td><span class="ui-icon ui-icon-info"></span></td>
                        <td width="99%">
                          <span><div class="hy-error-primary-message">Existing sessions will not be affected by changes to this setting.</div></span>
                        </td>
                      </tr>
                    </table>
                  </div>
                </div>
              </p>
              <p>
                Specify the display resolution to use for new VNC sessions (Linux only).
              </p>
            </ef:info>
            <ef:option id="geometry" type="text"  class="interactive-vnc-geometry_2" label="Display Resolution:">SESSION_VAR</ef:option>
          </ef:option-group>
          <ef:option-group id="viewer" label="Viewer Type" collapsible="false">
            <ef:info>
              <p>
                Select the type of VNC viewer you want to use to connect to a remote session.
              </p>
            </ef:info>
            <ef:option id="viewerType" type="radio" label="">
              <ef:option label="Default VNC Viewer">client</ef:option>
              <ef:option label="Applet-based VNC Viewer (embedded in the current browser tab)">embed</ef:option>
              <ef:option label="Applet-based VNC Viewer (open a new browser window)">window</ef:option>
            </ef:option>
          </ef:option-group>
          
          <ef:action label="Cancel" context="client" id="cancel" mode="button" type="javascript"><![CDATA[
            alert("Cancel");
          ]]></ef:action>
          <ef:action label="Save" context="client" id="save" mode="button" type="javascript"><![CDATA[
            alert("Save");
          ]]></ef:action>
        </ef:service>
    -->
    <div id="{@id}" class="hy-interactive-vnc-settings">
      <h2 id="{@id}-title" class="ef-service-title">Settings</h2>
      <div id="{concat(@id,'-message')}"/>
      <table class="ui-widget">
        <tr>
          <td>
            <table style="border-width: 0px">
              <tr class="ui-helper-hidden">
                <td colspan="2">
                  <fieldset id="{@id}-fieldset-geometry" class="ef_option_group ui-widget ef_option_group_not_collapsible">
                    <legend class="ui-widget-header ui-state-default"><span class="ef_option_group_not_collapsible"><!----></span>Display Resolution</legend>
                    <div class="ef_option_group_content ui-widget-content ">
                      <table style="border-width: 0px" width="100%">
                        <tr>
                          <td colspan="2">
                            <p/>
                            <div class="hy-message ui-widget">
                              <div class="ui-state-highlight ui-corner-all">
                                <table width="100%">
                                  <tr>
                                    <td>
                                      <span class="ui-icon ui-icon-info"/>
                                    </td>
                                    <td width="99%">
                                      <span>
                                        <div class="hy-error-secondary-message">Existing sessions will not be affected by changes to this setting.</div>
                                      </span>
                                    </td>
                                  </tr>
                                </table>
                              </div>
                            </div>
                            <p>Specify the display resolution to use for new VNC sessions (Linux only).</p>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <label class="ef-option-label" for="serviceopt_geometry">Display Resolution:</label>
                          </td>
                          <td>
                            <input size="15" value="" name="{@id}-geometry" style="display: none" 
                                   class="hy-interactive-vnc-settings-geometry" type="text"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </fieldset>
                </td>
              </tr>
              <tr class="ui-helper-hidden">
                <td colspan="2">
                  <p/>
                  <fieldset id="{@id}-fieldset-windowManager" class="ef_option_group ui-widget ef_option_group_not_collapsible">
                    <legend class="ui-widget-header ui-state-default"><span class="ef_option_group_not_collapsible"><!----></span>Window Manager</legend>
                    <div class="ef_option_group_content ui-widget-content ">
                      <table style="border-width: 0px" width="100%">
                        <tr>
                          <td colspan="2">
                            <p/>
                            <div class="hy-message ui-widget">
                              <div class="ui-state-highlight ui-corner-all">
                                <table width="100%">
                                  <tr>
                                    <td>
                                      <span class="ui-icon ui-icon-info"/>
                                    </td>
                                    <td width="99%">
                                      <span>
                                        <div class="hy-error-secondary-message">Existing sessions will not be affected by changes to this setting.</div>
                                      </span>
                                    </td>
                                  </tr>
                                </table>
                              </div>
                            </div>
                            <p>Specify the window manager to use for new VNC sessions (Linux only).</p>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <label for="serviceopt_window_manager" class="ef-option-label">Window Manager:</label>
                          </td>
                          <td>
                            <select id="serviceopt_window_manager" name="{@id}-windowManager" style="width: auto"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </fieldset>
                </td>
              </tr>
              <tr class="ui-helper-hidden">
                <td colspan="2">
                  <p/>
                  <fieldset id="{@id}-fieldset-viewerType" class="ef_option_group ui-widget ef_option_group_not_collapsible">
                    <legend class="ui-widget-header ui-state-default">
                      <span class="ef_option_group_not_collapsible"><!----></span>Viewer Type
                    </legend>
                    <div class="ef_option_group_content ui-widget-content ">
                      <table style="border-width: 0px" width="100%">
                        <tr>
                          <td colspan="2">
                            <p>Select the type of VNC viewer you want to use to connect to a remote session.</p>
                          </td>
                        </tr>
                        <tr>
                          <td valign="top">
                            <label class="ef-option-label" for="serviceopt_viewerType">
                            </label>
                          </td>
                          <td>
                            <input value="client" name="{@id}-viewerType" type="radio"/>
                            <label class="ef-option-label">Default VNC Viewer</label>
                            <br/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </fieldset>
                </td>
              </tr>
              <tr class="ui-helper-hidden">
                <td colspan="2">
                  <p/>
                  <fieldset id="{@id}-fieldset-password" class="ef_option_group ui-widget ef_option_group_not_collapsible">
                    <legend class="ui-widget-header ui-state-default">
                      <span class="ef_option_group_not_collapsible"><!----></span>Password
                    </legend>
                    <div class="ef_option_group_content ui-widget-content ">
                      <table style="border-width: 0px" width="100%">
                        <tr>
                          <td colspan="2">
                            <p>Specify the VNC password for the remote session.</p>
                          </td>
                        </tr>
                        <tr>
                          <td valign="top">
                            <label class="ef-option-label" for="serviceopt_password">
                            </label>
                          </td>
                          <td>
                            <input size="20" value="" name="{@id}-password" type="password"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </fieldset>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
      <p/>
      <div class="{@id}-buttons">
        <!--placeholder-->
        <input value="Cancel" name="{@id}-cancel" type="button"/>
        <input value="Save" name="{@id}-save" type="button"/>
      </div>
    </div>

    <script type="text/javascript"><xsl:comment>
      interactiveVncSettings.init('<xsl:value-of select="@id"/>');
    //</xsl:comment></script>

  </xsl:template>
</xsl:stylesheet>
