function is_ip_in_network(ip, network_filter) {
    ipaddr=inet_aton(ip)
    split(network_filter, tmp, "/")
    expected_network=inet_aton(tmp[1])
    mask=prefix_to_netmask(tmp[2])
    # Logical AND of IP address and mask will equal the network address if it matches
    actual_network=and(ipaddr, mask)

#    print "IP               : " bits2str(ipaddr)  " = " ipaddr
#    print "MASK             : " bits2str(mask)    " = " mask
#    print "ACTUAL NETWORK   : " bits2str(actual_network)  " = " actual_network
#    print "EXPECTED NETWORK : " bits2str(expected_network) " = " expected_network
#    print "MATCH            : " (expected_network == actual_network)

    return expected_network == actual_network
}

BEGIN {
    FS="[ \t]+";
    client_host = tolower(client_host);
    server_host = tolower(server_host);
    proxytype = toupper(proxytype);
}

# skip comments
/^[ \t]*#/ {
    next;
}
# skip empty lines
/^[ \t]*$/ {
    next;
}

function client_matches(client, client_pattern) {
    return is_ip_in_network(client, client_pattern)
}

function server_matches(server, server_pattern) {
    # In case we want to switch from glob to regex, here is the place
    regex = glob2ere(tolower(server_pattern))
    where = match(server, regex)
    if (where != 0) {
        return 1
    }
    else {
        return 0
    }
}

function type_matches(requested_proxy_type, configured_proxy_type) {
    return (configured_proxy_type == "DIRECT") || (configured_proxy_type == "NONE") || (requested_proxy_type == "") || (requested_proxy_type == configured_proxy_type)
}

{
    priority=$1
    client_host_pattern=$2
    server_host_pattern=$3
    proxy_type=$4
    proxy_address=$5

    if (client_matches(client_host, client_host_pattern) && server_matches(server_host, server_host_pattern) && type_matches(proxytype, proxy_type)) {
        if (proxy_type == "NONE") {
            print priority " " proxy_type
        }
        else {
            print priority " " proxy_type ":" proxy_address
        }
    }
}
