#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################

# Sample pre-submit hook script to show basic environment management
# Variable prefixed with SESSION_ and exported in the environment
# can be used later by starting and closing hooks.
# The SESSION_INTERACTIVE_ADDITIONAL_SUBMITOPTS name is a reserved name
# and can be used to propagate additional requirements to the scheduler or DCV SM

printf "This is a sample pre-submit hook script\n\n"

echo "Session ${EF_SPOOLER_NAME} for OS ${INTERACTIVE_SESSION_OS} is going to be submitted on cluster ${INTERACTIVE_SESSION_CLUSTER}"
printf "\nSession data are located in %s\n\n" "$INTERACTIVE_SESSION_DIR"

echo "Variable prefixed with SESSION_ and exported in the environment can be used later by starting and closing hooks."
echo "Performing:"
echo "$ export SESSION_HOOK_DATA=\"Some data from the pre-submit hook\""
echo "to show the described behavior."
export SESSION_HOOK_DATA="Some data from the pre-submit hook"

printf "\nFollowing is the full environment available:\n\n"
env
