<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
                xmlns:encode="org.owasp.encoder.Encode"
                extension-element-prefixes="efx"
                exclude-result-prefixes="ef efx encode">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->


  <!-- Configuration variables (i9 namespace)-->

  <!-- Navigation width in pixel. Default: 210 -->
  <xsl:variable name="i9.navigation.width">210</xsl:variable>
  
  <!-- Right (hydrogen filters/charts) column width in pixel. Default: 200 -->
  <xsl:variable name="i9.right.column.width">200</xsl:variable>

  <xsl:variable name="i9.navigation.title">
    <xsl:value-of select="/ef:agent/descendant::ef:folder[@id=$ef.navigation.root]/ef:name"/>
  </xsl:variable>

  <!-- HTML Title (default: agent name) -->
  <xsl:variable name="i9.title" select="$agent_name"/>

  <!-- Logo displayed in the top banner -->
  <xsl:variable name="i9.logo" select="concat($i9_img, '/logo_ef_180x45.png')"/>
  <xsl:variable name="i9.logo.href" select="concat($agent, '.xml')"/>

  <!-- Title displayed in the top banner -->
  <xsl:variable name="i9.headline"/>

  <!-- Show admin portal link near the logout link for admin users -->
  <xsl:variable name="i9.show.admin.link" select="true()"/>
  <xsl:variable name="i9.admin.portal.uri" select="$i9_admin_uri"/>
  <xsl:variable name="i9.admin.portal.name">Administration</xsl:variable>

  <!-- Show interactive settings link near the logout link  -->
  <xsl:variable name="i9.show.interactive.settings.link" select="true()"/>
  <xsl:variable name="i9.interactive.settings.uri" select="$i9_interactive_settings_uri"/>
  <xsl:variable name="i9.interactive.settings.name">Settings</xsl:variable>

  <!-- Favicon -->
  <xsl:variable name="i9.favicon" select="concat('/', $_root_context, '/images/favicon.ico')"/>

  <!-- Login service uri -->
  <xsl:variable name="i9.login.uri"/>

  <!-- Logout service uri -->
  <xsl:variable name="i9.logout.uri" select="concat($agent,'.xml?_uri=//com.enginframe.system/logout')"/>

  <!-- Footer logo -->
  <xsl:variable name="i9.footer.logo" select="concat($i9_img, '/nice_logo.png')"/>
  <xsl:variable name="i9.footer.logo.href">https://www.ni-sp-software.com</xsl:variable>

  <!-- Copyright message -->
  <xsl:variable name="i9.copyright">
    Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.<br/>
    Copyright 1999-2023 by Nice, srl., All rights reserved.<br/>
    All trademarks and logos on this page are owned by NI SP Software GmbH, NICE s.r.l. or by their respective owners.
  </xsl:variable>

  <!-- Private variables -->

  <!-- store current user login in variable -->
  <xsl:variable name="i9_login_name" select="//ef:profile/ef:login-name/."/>

  <!-- images and css directories locations -->
  <xsl:variable name="i9_img" select="concat('/', $_root_context, '/themes/ice-nine/images')"/>
  <xsl:variable name="i9_css" select="concat('/', $_root_context, '/themes/ice-nine/css')"/>
  <xsl:variable name="i9_js" select="concat('/', $_root_context, '/themes/ice-nine/js/layout.js', '?', $_ef_cache_timestamp)"/>

  <!-- admin portal uri -->
  <xsl:variable name="i9_admin_uri" select="concat('/', $_root_context, '/admin/com.enginframe.admin.xml')"/>

  <xsl:variable name="i9_interactive_settings_uri">?_uri=//com.enginframe.interactive/settings</xsl:variable>
  <!-- CSS parameters -->
  <xsl:template name="i9_css_params">
    <style type="text/css">
      <xsl:if test="$i9.navigation.width &lt;= 500">
        #i9-container {
          background-position: -<xsl:value-of select="499 - $i9.navigation.width" />px 0;
        }
      </xsl:if>
      #i9-navigation-wrapper {
        min-width: <xsl:value-of select="$i9.navigation.width" />px;
        width: <xsl:value-of select="$i9.navigation.width" />px !important;
      }
      #i9-contents-rendering {
        margin-left: -<xsl:value-of select="$i9.navigation.width" />px;
      }
      #i9-content-wrapper {
        margin-left: <xsl:value-of select="$i9.navigation.width" />px;
      }
      .hy-left-column-content {
        margin-right: <xsl:value-of select="$i9.right.column.width" />px;
      }
      .hy-right-column {
        margin-left: -<xsl:value-of select="$i9.right.column.width" />px;
        width: <xsl:value-of select="$i9.right.column.width" />px;
      }
    </style>
  </xsl:template>
  
  <!-- html header rendering -->
  <xsl:template name="i9_head_rendering">
    <title><xsl:value-of select="$i9.title"/></title>

    <link rel="shortcut icon" href="{$i9.favicon}" />

    <!-- include css stylesheets -->
    <link type="text/css" rel="StyleSheet" href="{$i9_css}/layout.css?{$_ef_cache_timestamp}" />

    <!-- System head -->
    <xsl:call-template name="head_rendering"/>

    <!-- Custom head section hook -->
    <xsl:apply-templates select="/ef:agent" mode="layout.head"/>

    <!-- navigation hide/show animation -->
    <script type="text/javascript" src="{$i9_js}">
      <xsl:comment>//</xsl:comment>
    </script>

    <!-- CSS parameters -->
    <xsl:call-template name="i9_css_params"/>
  </xsl:template>

  <!-- banner rendering -->
  <xsl:template name="i9_banner_rendering">
    <xsl:apply-templates select="/ef:agent" mode="layout.banner"/>
  </xsl:template>

  <xsl:template name="i9_menu_rendering">
    <!-- open navigation button -->
    <span id="i9-navigation-open-button">
      <a href="#"/>
    </span>

    <!-- default menu -->
    <div id="i9-menu">
      <xsl:choose>
        <xsl:when test="/ef:agent/ef:item-action-list[@id='ef_menu_list']">
          <xsl:call-template name="item_action_list_rendering">
            <xsl:with-param name="id">ef_menu_list</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:comment/> <!-- DIV placeholder -->
        </xsl:otherwise>
      </xsl:choose>
    </div>

    <!-- upper level menu -->
    <xsl:if test="/ef:agent/ef:item-action-list[@id='ef_upper_menu_list']">
      <div id="i9-upper-menu">
        <xsl:call-template name="item_action_list_rendering">
          <xsl:with-param name="id">ef_upper_menu_list</xsl:with-param>
        </xsl:call-template>
      </div>
    </xsl:if>
  </xsl:template>

  <!-- contents rendering -->
  <xsl:template name="i9_contents_rendering">
    <div id="i9-contents-rendering">
       <!-- main content -->
       <div id="i9-content-wrapper">
         <xsl:call-template name="i9_menu_rendering"/>
         <div id="i9-content-div">
           <!-- System content -->
           <xsl:call-template name="content_rendering"/>
         </div>
       </div>
    </div>

    <!-- navigation -->
    <xsl:call-template name="i9_navigation_rendering"/>
  </xsl:template>

  <!-- navigation rendering -->
  <xsl:template name="i9_navigation_rendering">
     <div id="i9-navigation-wrapper">
       <div id="i9-navigation-title">
         <span>
           <xsl:value-of select="$i9.navigation.title"/>
         </span>

         <!-- close navigation button -->
         <span id="i9-navigation-close-button">
           <a href="#"/>
         </span>

       </div>
       <div id="i9-navigation-div">
         <xsl:call-template name="navigation_rendering"/>
       </div>
     </div>
  </xsl:template>

  <!-- footer rendering -->
  <xsl:template name="i9_footer_rendering">
    <xsl:apply-templates select="/ef:agent" mode="layout.footer"/>
  </xsl:template>

  <!-- Overridable templates -->

  <!-- head section hook -->
  <xsl:template match="/ef:agent" mode="layout.head" priority="-1" />

  <!-- banner content -->
  <xsl:template match="/ef:agent" mode="layout.banner" priority="-1">
    <div id="i9-banner">
      <xsl:if test="$i9.logo">
        <a href="{$i9.logo.href}">
          <img id="i9-banner-logo" src="{$i9.logo}"/>
        </a>
      </xsl:if>
      <xsl:if test="$i9.headline">
        <h1 id="i9-banner-headline"><xsl:value-of select="$i9.headline"/></h1>
      </xsl:if>
      <div id="i9-banner-actions" >
        <xsl:choose>
          <xsl:when test="$i9_login_name != ''">
            <span>Welcome, <xsl:value-of select="$i9_login_name"/><span class="i9-banner-actions-separator">&#160;|</span></span>
            <xsl:if test="$i9.show.interactive.settings.link">
              <span>
                <a href="{$i9.interactive.settings.uri}" title="{$i9.interactive.settings.name}">
                  <xsl:value-of select="$i9.interactive.settings.name"/>
                </a>
                <span class="i9-banner-actions-separator">&#160;|</span>
              </span>
            </xsl:if>
            <xsl:if test="$i9.show.admin.link='true'">
<efx:acl>
  <ef:apply-acl select="admin-only">
              <span>
                <a href="{$i9.admin.portal.uri}" title="{$i9.admin.portal.name}">
                  <xsl:value-of select="$i9.admin.portal.name"/>
                </a>
                <span class="i9-banner-actions-separator">&#160;|</span>
              </span>
  </ef:apply-acl>
</efx:acl>
            </xsl:if>
            <a id="i9-logout-link" href="{$i9.logout.uri}">Logout</a>
            <script type="text/javascript">
              if (jQuery.cookie('EF_AUTH_COOKIE')) {
                jQuery('#i9-logout-link').hide();
                jQuery('.i9-banner-actions-separator').hide();
              } else {
                jQuery('#i9-logout-link').show();
                jQuery('.i9-banner-actions-separator').show();
              }
            </script>
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="$i9.login.uri">
              <a href="{$i9.login.uri}">Login</a>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </div>
    </div>
  </xsl:template>

  <!-- footer content -->
  <xsl:template match="/ef:agent" mode="layout.footer" priority="-1">
    <div id="i9-footer">
      <a href="{$i9.footer.logo.href}">
        <img id="i9-footer-logo" src="{$i9.footer.logo}" />
      </a>
      <div id="i9-footer-copyright">
        <xsl:copy-of select="$i9.copyright"/>
      </div>
    </div>
  </xsl:template>

</xsl:stylesheet>
