#!/bin/bash

# How many time we want to cycle
MAX_STEPS=10

# The series 10+9+...+2+1 sum
TOTAL_SLEEPTIME=55

# Helper to track steps done
COUNTER=0

"${EF_ROOT}/plugins/ef/bin/ef.set.output" --file progress "0%"
while [ ${MAX_STEPS} -gt 0 ]
do
    # Let'ìs fake we're doing some intensive work
    sleep ${MAX_STEPS}

    # Increment counter and then calculate percentage of work done
    # We have to use 100 since we don't have floats here
    let COUNTER=COUNTER+MAX_STEPS
    let step_time=(COUNTER*100)/TOTAL_SLEEPTIME

    # Let somebody know how much work has been completed
    "${EF_ROOT}/plugins/ef/bin/ef.set.output" --file progress "${step_time}%"

    # We don't loop forever...
    let MAX_STEPS--
done
