#!/bin/bash

port() {
    local _old_directory="$1";
    local _new_directory="$2";
    local _plugin;

    for _plugin in $(ls -1 "${_old_directory}"); do
        if [ ! -e "${_new_directory}/${_plugin}" ]; then
            echo "Copying \"${_old_directory}/${_plugin}\" to \"${_new_directory}\""
            cp -a "${_old_directory}/${_plugin}" "${_new_directory}"
        fi
    done
}

main() {
    local _directory;
    local _output_report_dir;
    local _input_report_dir;
    local _old_directory;
    local _new_directory;
  
    if [ "$1" = "track" ]; then
        _directory="$2"
        _output_report_dir="$3"

        echo "Creating track of ${_directory} to ${_output_report_dir}..."
    elif [ "$1" = "check" ]; then
        _directory="$2"
        _input_report_dir="$3"

        echo "Checking ${_directory} against report ${_input_report_dir}..."
    elif [ "$1" = "port" ]; then
        _old_directory="$2/enginframe/plugins"
        _new_directory="$3/enginframe/plugins"

        echo "Porting custom plugins from ${_old_directory} to ${_new_directory}..."
        port "${_old_directory}" "${_new_directory}"
    else
        echo "Error" >&2
        exit 1
    fi
}

main "$@"
