#!/bin/bash

absolute_path() {
  local _path
  pushd "$1" > /dev/null
  _path="$(pwd)"
  popd > /dev/null
  echo "${_path}"
}

load_env() {
  # The top enginframe directory. Example: /opt/nisp/enginframe
  export EF_TOP=$(absolute_path "${EF_VERSION_ROOT}/..")

  # In case no enginframe.conf is specified, fallback to EF_TOP/conf
  [ -z "${EF_CONF}" ] && EF_CONF="${EF_TOP}/conf/enginframe.conf"

  # The conf id used to load enginframe.[EF_CONF_ID].conf, server.[EF_CONF_ID].conf, agent.[EF_CONF_ID].conf
  [ -z "${EF_CONF_ID}" ] && EF_CONF_ID=$(hostname)
  export EF_CONF_ID

  # The hostname, used for logging
  EF_HOSTNAME=$(hostname)
  export EF_HOSTNAME

  # Reset the variables defined inside EF_CONF
  JAVA_HOME=""
  TOMCAT_USER=""
  AGENT_JAVA_OPTIONS=""
  SERVER_JAVA_OPTIONS=""
  EF_LOCALE=""

  # Check configuration file
  if [ ! -f "${EF_CONF}" ] && [ ! -r "${EF_CONF}" ] ; then
    echo "${efmsg_wrongconf}"
    echo "${EF_CONF}"
    exit 1
  fi

  # Set the default EF_CONF_ROOT
  EF_CONF_ROOT="$(dirname "${EF_CONF}")"

  echo "Loading configuration from:"
  echo " - \"${EF_CONF}\""
  . "${EF_CONF}"

  EF_CONF_LOCAL="${EF_CONF_ROOT}/enginframe.${EF_CONF_ID}.conf"
  if [ -r "${EF_CONF_LOCAL}" ]; then
    echo " - \"${EF_CONF_LOCAL}\""
    . "${EF_CONF_LOCAL}"
  fi

  #
  # Set defaults when missing from conf file
  #
  [ -z "${EF_ROOT}" ] && EF_ROOT="${EF_VERSION_ROOT}/enginframe"

  # The EF_DYNAMIC_ROOT is deprecated. The default is EF_ROOT
  # You should use EF_DATA_ROOT, EF_CONF_ROOT, EF_LOGS_ROOT, EF_TEMP_ROOT
  [ -z "${EF_DYNAMIC_ROOT}" ] && EF_DYNAMIC_ROOT="${EF_ROOT}"

  [ -z "${EF_LICENSE_PATH}" ] && EF_LICENSE_PATH="${EF_TOP}/license"

  [ -z "${EF_TEMP_ROOT}" ] && EF_TEMP_ROOT="${EF_TOP}/tmp"
  [ -z "${EF_DATA_ROOT}" ] && EF_DATA_ROOT="${EF_TOP}/data"
  [ -z "${EF_LOGS_ROOT}" ] && EF_LOGS_ROOT="${EF_TOP}/logs"
  [ -z "${EF_SPOOLERDIR}" ] && EF_SPOOLERDIR="${EF_TOP}/spoolers"
  [ -z "${EF_ERRORS_DIR}" ] && EF_ERRORS_DIR="${EF_DATA_ROOT}/errors"
  [ -z "${EF_REPOSITORYDIR}" ] && EF_REPOSITORYDIR="${EF_TOP}/repository"

  [ -z "${EF_SESSION_SPOOLERDIR}" ] && EF_SESSION_SPOOLERDIR="${EF_SPOOLERDIR}"

  [ -z "${CATALINA_HOME}" ] && CATALINA_HOME="${EF_VERSION_ROOT}/tomcat"
  [ -z "${CATALINA_BASE}" ] && CATALINA_BASE="${EF_CONF_ROOT}/tomcat"

  [ -z "${CATALINA_TMPDIR}" ] && CATALINA_TMPDIR="${EF_TEMP_ROOT}/${EF_HOSTNAME}/tomcat/temp"
  [ -z "${CATALINA_WORKDIR}" ] && CATALINA_WORKDIR="${EF_TEMP_ROOT}/${EF_HOSTNAME}/tomcat/work"

  [ -z "${CATALINA_LOGDIR}" ] && CATALINA_LOGDIR="${EF_LOGS_ROOT}/${EF_HOSTNAME}/tomcat"

  [ -z "${EF_LOGDIR}" ] && EF_LOGDIR="${EF_LOGS_ROOT}/${EF_HOSTNAME}"
  [ -z "${EF_TEMPDIR}" ] && EF_TEMPDIR="${EF_TEMP_ROOT}/${EF_HOSTNAME}"

  # This is useful to override the default logging.properties location
  # for more information read the tomcat documentation.
  [ -z "${LOGGING_CONFIG}" ] && { [ -f "${EF_CONF_ROOT}/enginframe/logging.properties" ] && LOGGING_CONFIG="-Djava.util.logging.config.file=${EF_CONF_ROOT}/enginframe/logging.properties" \
    || LOGGING_CONFIG="-Djava.util.logging.config.file=${EF_ROOT}/conf/logging.properties"; }


  [ -z "${DERBY_DIST_HOME}" ] && DERBY_DIST_HOME="${EF_VERSION_ROOT}/derby"
  [ -z "${DERBY_SYSTEM_HOME}" ] && DERBY_SYSTEM_HOME="${EF_CONF_ROOT}/derby"
  [ -z "${DERBY_OS_USER}" ] && DERBY_OS_USER="$TOMCAT_USER"

  [ -z "${DERBY_LOGDIR}" ] && DERBY_LOGDIR="${EF_LOGS_ROOT}/${EF_HOSTNAME}/derby"
  [ -z "${DERBY_DATA}" ] && DERBY_DATA="${EF_DATA_ROOT}/derby"

  [ -z "${EF_NODE}" ] && EF_NODE="${EF_VERSION_ROOT}/node"
  [ -z "${EF_SHELL_HOME}" ] && EF_SHELL_HOME="${EF_VERSION_ROOT}/shell"
  [ -z "${EF_PROXY_HOME}" ] && EF_PROXY_HOME="${EF_VERSION_ROOT}/proxy"

  [ -z "${CATALINA_PID}" ] && CATALINA_PID="${CATALINA_LOGDIR}/catalina.pid"
  [ -z "${CATALINA_OUT}" ] && CATALINA_OUT="${CATALINA_LOGDIR}/catalina.out"
  [ -z "${EF_AGENTPID}" ] && EF_AGENTPID="${EF_LOGDIR}/agent.remote.pid"
  [ -z "${EF_AGENTOUT}" ] && EF_AGENTOUT="${EF_LOGDIR}/agent.remote.stdout"
  [ -z "${EF_AGENTERR}" ] && EF_AGENTERR="${EF_LOGDIR}/agent.remote.stderr"
  [ -z "${EF_SHELLPID}" ] && EF_SHELLPID="${EF_LOGDIR}/ef.shell.pid"
  [ -z "${EF_SHELLOUT}" ] && EF_SHELLOUT="${EF_LOGDIR}/ef.shell.stdout"
  [ -z "${EF_SHELLERR}" ] && EF_SHELLERR="${EF_LOGDIR}/ef.shell.stderr"
  [ -z "${EF_PROXYPID}" ] && EF_PROXYPID="${EF_LOGDIR}/ef.proxy.pid"
  [ -z "${EF_PROXYOUT}" ] && EF_PROXYOUT="${EF_LOGDIR}/ef.proxy.stdout"
  [ -z "${EF_PROXYERR}" ] && EF_PROXYERR="${EF_LOGDIR}/ef.proxy.stderr"

  [ -z "${EF_JVM_ROUTE}" ] && EF_JVM_ROUTE=$(hostname)

  [ -z "${EF_ADMIN_USERGROUP}" ] && EF_ADMIN_USERGROUP=$(id -ng "$(grep EF_ADMIN= "${EF_CONF_ROOT}/enginframe/server.conf" | sed 's/^EF_ADMIN=//')")

  [ -z "${EF_THEME}" ] && EF_THEME="next-round"

  TOMCAT_START="${CATALINA_HOME}/bin/catalina.sh"
  TOMCAT_START_OPTIONS="start"
  TOMCAT_STOP="${CATALINA_HOME}/bin/shutdown.sh"
  EF_SHELL_START="${EF_SHELL_HOME}/bin/remote.shell.sh"
  EF_PROXY_START="${EF_PROXY_HOME}/bin/web.proxy.sh"
  export TOMCAT_START TOMCAT_START_OPTIONS TOMCAT_STOP EF_SHELL_START EF_PROXY_START

  # When starting EF Server with jpda enabled, this parameter allows to stop the Tomcat process
  # waiting for a remote debugger to connect to the Tomcat JVM
  #
  # JPDA_SUSPEND='n'  # ['y'|'n']

  # In case you want to disable JConsole access, add this option to the desired ..._JAVA_OPTIONS variable
  #    -XX:+DisableAttachMechanism \

  # The common settings for both Agent & Server JVM
  [ -z "${COMMON_JAVA_OPTIONS}" ] && COMMON_JAVA_OPTIONS="\
      -XX:+HeapDumpOnOutOfMemoryError \
      -DEF_ROOT=${EF_ROOT} \
      -DEF_DYNAMIC_ROOT=${EF_DYNAMIC_ROOT} \
      -DEF_CONF_ROOT=${EF_CONF_ROOT} \
      -DEF_TEMP_ROOT=${EF_TEMP_ROOT} \
      -DEF_DATA_ROOT=${EF_DATA_ROOT} \
      -Def.tmp.dir=${EF_TEMPDIR} \
      -DEF_SPOOLER_DIR=${EF_SPOOLERDIR} \
      -DEF_SESSION_SPOOLER_DIR=${EF_SESSION_SPOOLERDIR} \
      -DEF_LOGDIR=${EF_LOGDIR} \
      -Dfile.encoding=UTF-8 \
      -Djava.net.preferIPv4Stack=true \
      -Dsun.rmi.dgc.client.gcInterval=3600000 \
      -Dsun.rmi.dgc.server.gcInterval=3600000 \
      -DEF_CONF_ID=${EF_CONF_ID} \
      -DEF_HOSTNAME=${EF_HOSTNAME} \
      -DEF_THEME=${EF_THEME} \
      "

  EF_SERVER_LOG4J_CONFIG=$( [ -f "${EF_TOP}/conf/enginframe/log4j2.server.xml" ] && echo "${EF_TOP}/conf/enginframe/log4j2.server.xml" || echo "${EF_ROOT}/conf/log4j2.server.xml")
  EF_AGENT_LOG4J_CONFIG=$( [ -f "${EF_TOP}/conf/enginframe/log4j2.agent.xml" ] && echo "${EF_TOP}/conf/enginframe/log4j2.agent.xml" || echo "${EF_ROOT}/conf/log4j2.agent.xml")

  # Java configuration for EFServer
  [ -z "${SERVER_JAVA_OPTIONS}" ] && SERVER_JAVA_OPTIONS="\
      -XX:HeapDumpPath=${EF_TEMPDIR}/dumps/server.pid$$.hprof \
      -XX:ErrorFile=${EF_TEMPDIR}/dumps/server.hs_err_pid$$.log \
      -DjvmRoute=${EF_JVM_ROUTE} \
      -DEF_LICENSE_PATH=${EF_LICENSE_PATH} \
      -DDERBY_DATA=${DERBY_DATA} \
      -DEF_ERRORS_DIR=${EF_ERRORS_DIR} \
      -Djava.awt.headless=true \
      -Dcatalina.logdir=${CATALINA_LOGDIR} \
      -Dcatalina.workdir=${CATALINA_WORKDIR} \
      -Dorg.apache.catalina.session.StandardSession.ACTIVITY_CHECK=true \
      -Def.repository.dir=${EF_REPOSITORYDIR} \
      -Djava.util.prefs.userRoot=${EF_OLD_USER_PREFS_ROOT} \
      -Djava.nio.channels.spi.SelectorProvider=sun.nio.ch.PollSelectorProvider \
      ${COMMON_JAVA_OPTIONS} \
      -Dnet.sourceforge.cobertura.datafile=${EF_ROOT}/tools/cobertura.ser \
      -Dlog4j2.configurationFile=${EF_SERVER_LOG4J_CONFIG} \
      "
  [ -n "${SERVER_MAX_HEAP}" ] && SERVER_JAVA_OPTIONS=" -Xmx${SERVER_MAX_HEAP} ${SERVER_JAVA_OPTIONS}"
  [ -n "${SERVER_MIN_HEAP}" ] && SERVER_JAVA_OPTIONS=" -Xms${SERVER_MIN_HEAP} ${SERVER_JAVA_OPTIONS}"

  # Java configuration for EFAgent
  [ -z "${AGENT_JAVA_OPTIONS}" ] && AGENT_JAVA_OPTIONS="\
      -XX:HeapDumpPath=${EF_TEMPDIR}/dumps/agent.pid$$.hprof \
      -XX:ErrorFile=${EF_TEMPDIR}/dumps/agent.hs_err_pid$$.log \
      ${COMMON_JAVA_OPTIONS} \
      -Dnet.sourceforge.cobertura.datafile=${EF_DYNAMIC_ROOT}/agent/cobertura.ser \
      -Dlog4j2.configurationFile=${EF_AGENT_LOG4J_CONFIG} \
      "
  [ -n "${AGENT_MAX_HEAP}" ] && AGENT_JAVA_OPTIONS=" -Xmx${AGENT_MAX_HEAP} ${AGENT_JAVA_OPTIONS}"
  [ -n "${AGENT_MIN_HEAP}" ] && AGENT_JAVA_OPTIONS=" -Xms${AGENT_MIN_HEAP} ${AGENT_JAVA_OPTIONS}"

  # To enable the remote debugging for EFAgent.
  # Note: configured with port 8001 since 8000 is used by default by Tomcat
  # -agentlib:jdwp=transport=dt_socket,address=8001,server=y,suspend=n \

  # Java configuration for Derby
  [ -z "${DERBY_JAVA_OPTIONS}" ] && DERBY_JAVA_OPTIONS="\
      \"-Dderby.system.home=${DERBY_SYSTEM_HOME}\" \
      \"-Dderby.stream.error.file=${DERBY_LOGDIR}/derby.log\" \
      \"-Dderby.install.url=file://${DERBY_DIST_HOME}/lib/\" \
      \"-Dport=${DERBY_PORT}\" \
      \"-Djava.security.manager\" \
      \"-Djava.security.policy=${DERBY_SYSTEM_HOME}/server.policy\" \
      "

  # Configuration for EF Remote Shell Server
  [ -z "${EF_SHELL_OPTIONS}" ] && EF_SHELL_OPTIONS="\
    export EF_SHELL_HOME=${EF_SHELL_HOME} \
    export EF_SHELLPID=${EF_SHELLPID} \
    export EF_NODE=${EF_NODE} \
    export EF_DATA_ROOT=${EF_DATA_ROOT} \
    export EF_CONF_ROOT=${EF_CONF_ROOT} \
    export EF_VERSION_ROOT=${EF_VERSION_ROOT} \
    "

  # Configuration for EF Web Proxy
  [ -z "${EF_PROXY_OPTIONS}" ] && EF_PROXY_OPTIONS="\
    export EF_PROXY_HOME=${EF_PROXY_HOME} \
    export EF_PROXYPID=${EF_PROXYPID} \
    export EF_NODE=${EF_NODE} \
    export EF_DATA_ROOT=${EF_DATA_ROOT} \
    export EF_CONF_ROOT=${EF_CONF_ROOT} \
    export EF_VERSION_ROOT=${EF_VERSION_ROOT} \
    "
}
