#!/bin/bash

################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################

# Usage:
#   source node.init.sh "<APP_HOME>"

# Error function: print to stderr
error() {
  echo "ERROR: $*" >&2
}

APP_HOME="$1"

if [ -z "$APP_HOME" ]; then
  error "Expected app home folder as parameter. Usage: source node.init.sh <APP_HOME>"
  return 1
fi

# Detect machine architecture and normalize for Node.js binaries
machine=$(uname -m)
machine=${machine/aarch64/arm64}
machine=${machine/x86_64/x64}

# Define Node.js version package name
export NODE_VERSION="node-v22.16.0-linux-$machine"

# Ensure EF_NODE is defined and not empty
if [ -z "$EF_NODE" ]; then
  error "EF_NODE is not set. Please export EF_NODE before sourcing this script."
  return 1
fi

# Unpack Node.js only if needed; normally handled by the installer
if [ ! -f "$EF_NODE/$NODE_VERSION/bin/node" ]; then
  if ! cd "$EF_NODE" ; then
    error "Failed to cd into EF_NODE: $EF_NODE"
    return 1
  fi
  tar xfz "node-$(uname -m).tar.gz"
fi

# Move to application home directory
if ! cd "$APP_HOME" ; then
  error "Failed to cd into APP_HOME: $APP_HOME"
  return 1
fi

# Unpack node_modules only if needed; normally handled by the installer
if [ ! -d "node_modules" ]; then
  tar xfz "node_modules-$(uname -m).tar.gz"
fi

# Export environment variables
export NODE_ENV="production"
