const minimatch = require('minimatch');
const glob      = require('glob');
const path      = require('path');
const yaml      = require('js-yaml');
const fs        = require('fs');
const os        = require('os');

function hostInAllowList(allowlist, host) {
    allowlist = Array.from(allowlist);
    return allowlist.some((value) => minimatch(host, value))
}

function definedHosts() {
    const hosts = {
        'default': process.env.DEFAULT_SSHHOST || os.hostname(),
        'hosts': []
    };

    glob.sync(path.join((process.env.SHELL_CLUSTERS || process.env.EF_CONF_ROOT + '/shell/clusters.d'), '*.y*ml'))
        .map((yml) => {
            try {
                return yaml.safeLoad(fs.readFileSync(yml));
            } catch(err) { /* skip invalid files */}
        })
        .filter(config => config && config.v2 && Array.isArray(config.v2.login))
        .forEach((config) => {
            config.v2.login.forEach(loginHost => {
                if (loginHost.hidden) {
                    console.log(loginHost.host + ' is hidden');
                } else {
                    console.log(loginHost.host + ' was added');
                    hosts['hosts'].push(loginHost.host);
                    if (loginHost.default) {
                        console.log(loginHost.host + ' is default');
                        hosts['default'] = loginHost.host;
                    }
                }
            });
        });

    // couldn't find a defined default, so let's just make one now if we can
    if (hosts['default'] === null && hosts['hosts'].length > 0) {
        console.log('No default host found, using ' + hosts['hosts'][0]);
        hosts['default'] = hosts['hosts'][0];
    }

    return hosts;
}

module.exports = {
    hostInAllowList,
    definedHosts
}
