// Formats a given number of seconds into a time string "HH:MM:SS", using the pad function to maintain the two-digit format.
const formatTime = (seconds) => {
  return [
    pad(Math.floor(seconds / 3600)),
    pad(Math.floor(seconds / 60) % 60),
    pad((seconds % 60).toFixed(2)),
  ].join(":");
};
// Pads a number with a leading zero if it is less than 10, ensuring that it always has at least two digits.
const pad = (num) => {
  if (num < 10) {
    return "0" + num;
  } else {
    return "" + num;
  }
};

const monthNames = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December",
];

// Converts a time string in the format "HH:MM:SS" into the total number of seconds.
// Formats we have seen: HH:MM:SS D-HH:MM:SS MM:SS MM:SS.something
const timeStrToSec = (timeStr) => {
  var parts = timeStr.split(":");
  var dayhourparts = parts[0].split("-");
  if(parts.length == 1)
    return Number(parts[0]);

  var hasday = dayhourparts.length > 1;
  var days = hasday ? dayhourparts[0] : 0;
  // If the date has - in it, hours are guaranteed to exist
  // If the date doesn't, hours are guaranteed to exist if parts.length == 3
  var hours = hasday ? dayhourparts[1] : (parts.length == 3 ? parts[0] : 0);
  // If parts.length == 3, the minutes is in index 1, else 0
  var minutes = parts.length == 3 ? parts[1] : parts[0];
  // If parts.length == 3, the seconds are in index 2, else 1
  var seconds = parts.length == 3 ? parts[2] : parts[1];

  var seconds = Number(days) * 86400 + Number(hours) * 3600 + Number(minutes) * 60 + Number(seconds); 
  if (isNaN(seconds)) console.log("Invalid timeStr:", timeStr);
  return seconds;
};

// Converts a UNIX timestamp into a human-readable date and time string. It seems to reference an undefined monthNames array for month name conversion.
const timeConverter = (timestamp) => {
  if (timestamp == 0) {
    return "";
  }

  let a = new Date(timestamp * 1000);
  let year = a.getFullYear();
  let month = monthNames[a.getMonth()];
  let date = a.getDate();
  let hour = a.getHours();
  let min = a.getMinutes() < 10 ? "0" + a.getMinutes() : a.getMinutes();
  let sec = a.getSeconds() < 10 ? "0" + a.getSeconds() : a.getSeconds();
  return date + " " + month + " " + year + " " + hour + ":" + min + ":" + sec;
  //dateTimeFormat.format(new Date(data))
};

// Generates an array of date objects representing each day within a range, given the start and end UNIX timestamps.
const getDatesInTimestampRange = (start, end) => {
    start = new Date(start * 1000);
    end = new Date(end * 1000);

    let dates = [];
    for (let d = start; d <= end; d.setDate(d.getDate() + 1)) {
        dates.push({
            year: d.getFullYear(),
            month: d.getMonth(),
            day: d.getDate()
        });
    }
    return dates;
}

// Returns the ordinal indicator ("st", "nd", "rd", "th") for a given number, which is useful for formatting numbers with their corresponding rank/order suffix.
const getOrdinalIndicator = (number) => {
    if (number >= 11 && number <= 13) {
        return "th";
    }

    const lastDigit = number % 10;

    switch (lastDigit) {
        case 1:
            return "st";
        case 2:
            return "nd";
        case 3:
            return "rd";
        default:
            return "th";
    }
}
