<?xml version="1.0" encoding="utf-8"?>

<!--
Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
Copyright 1999-2023 by Nice, srl., All rights reserved.
This software includes confidential and proprietary information
of NI SP Software GmbH ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NI SP Software.

This file contains the XSLT which modifies axis2.xml
in case of HTTP installation to use the "http" transportReceiver
in place of the "https" one.

-->

<xsl:stylesheet
        version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xalan="http://xml.apache.org/xalan"
        exclude-result-prefixes="xalan"
>

  <xsl:output
          method="xml"
          encoding="utf-8"
          indent="yes"
          xalan:indent-amount="2"
          media-type="text/xml"/>

  <!-- Modify transportReceiver -->
  <xsl:template match="transportReceiver">
    <xsl:text>&#10;    </xsl:text>
    <xsl:comment> Modified by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;    </xsl:text>
    <transportReceiver name="http" class="org.apache.axis2.transport.http.AxisServletListener" />
  </xsl:template>

  <!-- Copy template -->
  <xsl:template match="@*|*|processing-instruction()|comment()|text()">
    <xsl:copy>
      <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()" />
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
