<?xml version="1.0" encoding="utf-8"?>

<!--
Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
Copyright 1999-2023 by Nice, srl., All rights reserved.
This software includes confidential and proprietary information
of NI SP Software GmbH ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NI SP Software.

SVN $Id$

This file contains the XSLT which modifies server.xml
-->

<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xalan="http://xml.apache.org/xalan"
  exclude-result-prefixes="xalan"
  >

  <xsl:output
    method="xml"
    encoding="utf-8"
    indent="yes"
    xalan:indent-amount="2"
    media-type="text/xml"/>

  <xsl:param name="shutdown_port">8005</xsl:param>
  <xsl:param name="shutdown_pass">SHUTDOWN</xsl:param>
  <xsl:param name="httpd_port">8080</xsl:param>
  <xsl:param name="httpsd_port">8443</xsl:param>
  <xsl:param name="jvmRoute">ef</xsl:param>
  <xsl:param name="https_enabled">false</xsl:param>
  <xsl:param name="https_keystore">ef.tomcat.keystore</xsl:param>
  <xsl:param name="https_truststore">ef.tomcat.truststore</xsl:param>
  <xsl:param name="https_pass">dev-pass</xsl:param>
  <xsl:param name="https_client_auth">false</xsl:param>

  <!-- Server -->
  <xsl:template match="Server">
    <xsl:text>&#10;    </xsl:text>
    <xsl:comment> Modified by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;    </xsl:text>
    <Server port="{$shutdown_port}" shutdown="{$shutdown_pass}" >
      <xsl:apply-templates/>
    </Server>
  </xsl:template>

  <!-- Connector 8080 -->
  <xsl:template match="Connector[@port='8080']">
    <xsl:text>&#10;    </xsl:text>
    <xsl:comment> Modified by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;    </xsl:text>


    <xsl:choose>
      <xsl:when test="$https_enabled='true'">
        <!-- setup HTTPS connector -->
        <xsl:choose>
          <xsl:when test="$https_client_auth='true'">
            <Connector port="{$httpsd_port}"
                       maxThreads="150" SSLEnabled="true" scheme="https" secure="true"
                       clientAuth="true" sslProtocol="TLS"
                       keystoreFile="conf/certs/{$https_keystore}"
                       keystoreType="JKS"
                       keystorePass="{$https_pass}"
                       truststoreFile="conf/certs/{$https_truststore}"
                       truststoreType="JKS"
                       truststorePass="{$https_pass}"
                       server="Apache"
                       URIEncoding="utf-8"/>
            <xsl:comment> Commented out by EnginFrame Installer
              <![CDATA[<Connector port="8080" maxHttpHeaderSize="8192"
                         maxThreads="150" minSpareThreads="25"
                         enableLookups="false" redirectPort="8443" acceptCount="100"
                         connectionTimeout="20000" disableUploadTimeout="true"
                         URIEncoding="utf-8" />]]>
            </xsl:comment>
          </xsl:when>
          <xsl:otherwise>
            <Connector port="{$httpsd_port}"
                       maxThreads="150" SSLEnabled="true" scheme="https" secure="true"
                       clientAuth="false" sslProtocol="TLS"
                       keystoreFile="conf/certs/{$https_keystore}"
                       keystorePass="{$https_pass}"
                       server="Apache"
                       URIEncoding="utf-8"/>
            <xsl:comment> Commented out by EnginFrame Installer
              <![CDATA[<Connector port="8080" maxHttpHeaderSize="8192"
                         maxThreads="150" minSpareThreads="25"
                         enableLookups="false" redirectPort="8443" acceptCount="100"
                         connectionTimeout="20000" disableUploadTimeout="true"
                         URIEncoding="utf-8" />]]>
            </xsl:comment>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- setup HTTP connector-->
        <Connector port="{$httpd_port}" maxHttpHeaderSize="8192"
                   maxThreads="150" minSpareThreads="25"
                   enableLookups="false" redirectPort="8443" acceptCount="100"
                   connectionTimeout="20000" disableUploadTimeout="true"
                   server="Apache"
                   URIEncoding="utf-8" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Valve -->
  <xsl:template match="Valve[@className='org.apache.catalina.valves.AccessLogValve']">
    <xsl:text>&#10;        </xsl:text>
    <xsl:comment> Modified by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;        </xsl:text>
    <Valve className="org.apache.catalina.valves.AccessLogValve"
           directory="${{catalina.logdir}}" prefix="localhost_access_log" suffix=".txt"
           pattern="combined" maxDays="60" resolveHosts="false"/>
  </xsl:template>

  <xsl:template name="error-valve">
    <xsl:text>&#10;        </xsl:text>
    <xsl:comment> Added by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;        </xsl:text>
    <Valve className="org.apache.catalina.valves.ErrorReportValve" showReport="false" showServerInfo="false"/>
  </xsl:template>

  <!-- Host -->
  <xsl:template match="Host">
    <xsl:text>&#10;    </xsl:text>
    <xsl:comment> Modified by EnginFrame Installer </xsl:comment>
    <xsl:text>&#10;    </xsl:text>
    <Host workDir="${{catalina.workdir}}"  name="localhost" appBase="webapps" unpackWARs="true" autoDeploy="false">
      <xsl:apply-templates/>
      <xsl:call-template name="error-valve" />
    </Host>
  </xsl:template>

  <!-- Copy template -->
  <xsl:template match="@*|*|processing-instruction()|comment()|text()">
    <xsl:copy>
      <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()" />
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
