#!/bin/bash

__main() {
    local -- _efroot _profile
    local -- _lsf _openlava
    local -a _files

    printf 'EF_ROOT? '; read _efroot
    printf 'OPENLAVA PROFILE? '; read _profile

    [[ -n ${_efroot} ]] || return 1
    [[ -d ${_efroot} ]] || return 1

    _lsf="${_efroot}/plugins/lsf"
    [[ -d ${_lsf} ]] || return 1

    _openlava="${_efroot}/plugins/openlava"
    if [[ -d "${_openlava}" ]]; then
        mv "${_openlava}" "${_openlava}.backup.$(date '+%Y%m%d%H%M%S')"
    fi

    sed -i "s/^LSF_LOAD_PROFILE=\".*$/LSF_LOAD_PROFILE=\"always\"/g" \
        "${_lsf}/conf/ef.lsf.conf"

    cp -a "${_lsf}" "${_openlava}"

    while read -r; do
        if [[ ${REPLY} =~ ^(.*)lsf(.*)$ ]]; then
            mv "${REPLY}" "${BASH_REMATCH[1]}openlava${BASH_REMATCH[2]}"
            _files+=("${BASH_REMATCH[1]}openlava${BASH_REMATCH[2]}")
        elif [[ ${REPLY} =~ ^(.*)LSF(.*)$ ]]; then
            mv "${REPLY}" "${BASH_REMATCH[1]}OPENLAVA${BASH_REMATCH[2]}"
            _files+=("${BASH_REMATCH[1]}OPENLAVA${BASH_REMATCH[2]}")
        else
            _files+=("${REPLY}")
        fi
    done < <(find "${_openlava}" -type f)

    sed -i \
        -e 's/lsf/openlava/g' \
        -e 's/LSF/OPENLAVA/g' \
        -e 's/OPENLAVA_\(BINDIR\|ENVDIR\|LIBDIR\|SERVERDIR\)/LSF_\1/g' \
        -e 's/\${LSF_ENVDIR}\/openlava/\${LSF_ENVDIR}\/lsf/g' \
        "${_files[@]}"

    _profile=$(
        echo "${_profile}" | sed \
            -e 's#\\#\\\\#g' \
            -e 's#/#\\/#g' \
            -e 's/\./\\./g' \
            -e 's/\*/\\*/g' \
            -e 's/\^/\\^/g' \
            -e 's/\$/\\$/g' \
            -e 's/\[/\\[/g' \
            -e 's/\]/\\]/g'
    )
    sed -i "s/^OPENLAVA_PROFILE=\".*$/OPENLAVA_PROFILE=\"${_profile}\"/g" \
        "${_openlava}/conf/ef.openlava.conf"
}

__main "$@"


